/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import java.util.Map;
import org.jboss.as.web.session.AffinityLocator;

public class AffinitySessionConfig
implements SessionConfig {
    private final SessionConfig sessionConfig;
    private final Map<SessionConfig.SessionCookieSource, SessionConfig> affinityConfigMap;
    private final AffinityLocator locator;

    public AffinitySessionConfig(SessionConfig sessionConfig, Map<SessionConfig.SessionCookieSource, SessionConfig> affinityConfigMap, AffinityLocator locator) {
        this.sessionConfig = sessionConfig;
        this.affinityConfigMap = affinityConfigMap;
        this.locator = locator;
    }

    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        String affinity;
        String requestedSessionId = this.sessionConfig.findSessionId(exchange);
        if (!sessionId.equals(requestedSessionId)) {
            this.sessionConfig.setSessionId(exchange, sessionId);
        }
        if ((affinity = this.locator.locate(sessionId)) != null) {
            this.sessionConfigInUse(exchange).setSessionId(exchange, affinity);
        }
    }

    public void clearSession(HttpServerExchange exchange, String sessionId) {
        this.sessionConfig.clearSession(exchange, sessionId);
        SessionConfig sessionConfigInUse = this.sessionConfigInUse(exchange);
        String existingAffinity = sessionConfigInUse.findSessionId(exchange);
        if (existingAffinity != null) {
            sessionConfigInUse.clearSession(exchange, existingAffinity);
        }
    }

    public String findSessionId(HttpServerExchange exchange) {
        return this.sessionConfig.findSessionId(exchange);
    }

    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        return this.sessionConfig.sessionCookieSource(exchange);
    }

    public String rewriteUrl(String originalUrl, String sessionId) {
        String url = this.sessionConfig.rewriteUrl(originalUrl, sessionId);
        String route = this.locator.locate(sessionId);
        if (route != null) {
            if (url.equals(originalUrl)) {
                return this.affinityConfigMap.get(SessionConfig.SessionCookieSource.COOKIE).rewriteUrl(url, route);
            }
            return this.affinityConfigMap.get(SessionConfig.SessionCookieSource.URL).rewriteUrl(url, route);
        }
        return url;
    }

    private SessionConfig sessionConfigInUse(HttpServerExchange exchange) {
        switch (this.sessionConfig.sessionCookieSource(exchange)) {
            case URL: {
                return this.affinityConfigMap.get(SessionConfig.SessionCookieSource.URL);
            }
        }
        return this.affinityConfigMap.get(SessionConfig.SessionCookieSource.COOKIE);
    }
}

