/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.wildfly.clustering.marshalling.protostream.EnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.FieldSetProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.FunctionalScalarMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.Scalar;
import org.wildfly.clustering.marshalling.protostream.time.DurationMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.InstantMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalDateMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalDateTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.MonthDayMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.OffsetDateTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.OffsetTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.PeriodMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.YearMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.YearMonthMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.ZoneOffsetMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.ZonedDateTimeMarshaller;
import org.wildfly.common.function.Functions;

public enum TimeMarshallerProvider implements ProtoStreamMarshallerProvider
{
    DAY_OF_WEEK(new EnumMarshaller<DayOfWeek>(DayOfWeek.class)),
    DURATION(new FieldSetProtoStreamMarshaller<Duration, Duration>(DurationMarshaller.INSTANCE)),
    INSTANT(new InstantMarshaller()),
    LOCAL_DATE(new FieldSetProtoStreamMarshaller<LocalDate, LocalDate>(LocalDateMarshaller.INSTANCE)),
    LOCAL_DATE_TIME(new LocalDateTimeMarshaller()),
    LOCAL_TIME(new FieldSetProtoStreamMarshaller<LocalTime, LocalTime>(LocalTimeMarshaller.INSTANCE)),
    MONTH(new EnumMarshaller<Month>(Month.class)),
    MONTH_DAY(new MonthDayMarshaller()),
    OFFSET_DATE_TIME(new OffsetDateTimeMarshaller()),
    OFFSET_TIME(new OffsetTimeMarshaller()),
    PERIOD(new PeriodMarshaller()),
    YEAR(new FieldSetProtoStreamMarshaller<Year, Year>(YearMarshaller.INSTANCE)),
    YEAR_MONTH(new YearMonthMarshaller()),
    ZONE_ID(new FunctionalScalarMarshaller<ZoneId, String>(ZoneId.class, Scalar.STRING.cast(String.class), Functions.constantSupplier((Object)ZoneOffset.UTC), ZoneId::getId, ZoneId::of)),
    ZONE_OFFSET(new FieldSetProtoStreamMarshaller<ZoneOffset, ZoneOffset>(ZoneOffsetMarshaller.INSTANCE)),
    ZONED_DATE_TIME(new ZonedDateTimeMarshaller());

    private final ProtoStreamMarshaller<?> marshaller;

    private TimeMarshallerProvider(ProtoStreamMarshaller<?> marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this.marshaller;
    }
}

