/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso.elytron;

import io.undertow.server.session.SessionIdGenerator;
import java.net.URI;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.msc.Service;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.CascadeRemovalLifecycleListener;
import org.wildfly.clustering.service.ChildTargetService;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SimpleSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.container.SecurityDomainSingleSignOnManagementConfiguration;
import org.wildfly.clustering.web.service.WebDefaultProviderRequirement;
import org.wildfly.clustering.web.service.WebProviderRequirement;
import org.wildfly.clustering.web.service.sso.DistributableSSOManagementProvider;
import org.wildfly.clustering.web.service.sso.LegacySSOManagementProviderFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.sso.SSOManagerServiceConfigurator;
import org.wildfly.clustering.web.undertow.sso.elytron.DistributableSingleSignOnManager;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContext;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContextFactory;
import org.wildfly.clustering.web.undertow.sso.elytron.SessionIdGeneratorAdapter;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.http.util.sso.SingleSignOnManager;

public class DistributableSingleSignOnManagerServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Function<SSOManager<CachedIdentity, String, Map.Entry<String, URI>, LocalSSOContext, Batch>, SingleSignOnManager> {
    private final SecurityDomainSingleSignOnManagementConfiguration configuration;
    private final LegacySSOManagementProviderFactory legacyProviderFactory;
    private volatile SupplierDependency<DistributableSSOManagementProvider> provider;
    private volatile SupplierDependency<SSOManager<CachedIdentity, String, Map.Entry<String, URI>, LocalSSOContext, Batch>> manager;
    private volatile Consumer<ServiceTarget> installer;

    public DistributableSingleSignOnManagerServiceConfigurator(ServiceName name, SecurityDomainSingleSignOnManagementConfiguration configuration, LegacySSOManagementProviderFactory legacyProviderFactory) {
        super(name);
        this.configuration = configuration;
        this.legacyProviderFactory = legacyProviderFactory;
    }

    @Override
    public SingleSignOnManager apply(SSOManager<CachedIdentity, String, Map.Entry<String, URI>, LocalSSOContext, Batch> manager) {
        return new DistributableSingleSignOnManager(manager);
    }

    public ServiceConfigurator configure(OperationContext context) {
        final String securityDomainName = this.configuration.getSecurityDomainName();
        final Supplier generator = this.configuration.getIdentifierGenerator();
        final CapabilityServiceSupport support = context.getCapabilityServiceSupport();
        final SupplierDependency<DistributableSSOManagementProvider> provider = this.getProvider(context, securityDomainName);
        final ServiceName managerServiceName = this.getServiceName().append(new String[]{"manager"});
        this.manager = new ServiceSupplierDependency(managerServiceName);
        this.provider = provider;
        this.installer = new Consumer<ServiceTarget>(){

            @Override
            public void accept(ServiceTarget target) {
                ServiceConfigurator factoryConfigurator = ((DistributableSSOManagementProvider)provider.get()).getServiceConfigurator(securityDomainName).configure(support);
                factoryConfigurator.build(target).install();
                ServiceSupplierDependency factoryDependency = new ServiceSupplierDependency((ServiceNameProvider)factoryConfigurator);
                SimpleSupplierDependency generatorDependency = new SimpleSupplierDependency((Object)new SessionIdGeneratorAdapter(generator));
                new SSOManagerServiceConfigurator(managerServiceName, factoryDependency, (SupplierDependency<SessionIdGenerator>)generatorDependency, LocalSSOContextFactory.INSTANCE).configure(support).build(target).install();
            }
        };
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceController installerController = this.provider.register(target.addService(name.append(new String[]{"installer"}))).setInstance((Service)new ChildTargetService(this.installer)).install();
        ServiceBuilder builder = target.addService(name).addListener((LifecycleListener)new CascadeRemovalLifecycleListener(installerController));
        Consumer manager = this.manager.register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(manager, (Function)this, this.manager);
        return builder.setInstance((Service)service);
    }

    private SupplierDependency<DistributableSSOManagementProvider> getProvider(OperationContext context, String securityDomainName) {
        String securityDomainCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.undertow.application-security-domain", (String)securityDomainName);
        if (context.hasOptionalCapability(WebProviderRequirement.SSO_MANAGEMENT_PROVIDER.resolve(securityDomainName), securityDomainCapabilityName, null)) {
            return new ServiceSupplierDependency(WebProviderRequirement.SSO_MANAGEMENT_PROVIDER.getServiceName(context, securityDomainName));
        }
        if (context.hasOptionalCapability(WebDefaultProviderRequirement.SSO_MANAGEMENT_PROVIDER.getName(), securityDomainCapabilityName, null)) {
            return new ServiceSupplierDependency(WebDefaultProviderRequirement.SSO_MANAGEMENT_PROVIDER.getServiceName(context));
        }
        UndertowClusteringLogger.ROOT_LOGGER.legacySingleSignOnProviderInUse(securityDomainName);
        return new SimpleSupplierDependency((Object)this.legacyProviderFactory.createSSOManagementProvider());
    }
}

