/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.metadata.property.JBossASSimpleExpressionResolver;
import org.jboss.metadata.property.SimpleExpressionResolver;

public class CompositePropertyResolver
implements SimpleExpressionResolver {
    private final Collection<SimpleExpressionResolver> expressionResolvers;
    final boolean hasJBossASExpressionSupport;

    public CompositePropertyResolver(SimpleExpressionResolver ... resolvers) {
        this.expressionResolvers = new ArrayList<SimpleExpressionResolver>(resolvers.length);
        boolean jbossSupport = false;
        for (SimpleExpressionResolver ser : resolvers) {
            this.expressionResolvers.add(ser);
            if (jbossSupport) continue;
            if (ser instanceof JBossASSimpleExpressionResolver) {
                jbossSupport = true;
                continue;
            }
            if (!(ser instanceof CompositePropertyResolver) || !((CompositePropertyResolver)ser).hasJBossASExpressionSupport) continue;
            jbossSupport = true;
        }
        this.hasJBossASExpressionSupport = jbossSupport;
    }

    @Override
    public SimpleExpressionResolver.ResolutionResult resolveExpressionContent(String expressionContent) {
        SimpleExpressionResolver.ResolutionResult value = null;
        SimpleExpressionResolver.ResolutionResult defaultValue = null;
        if (this.expressionResolvers != null) {
            Iterator<SimpleExpressionResolver> iter = this.expressionResolvers.iterator();
            while (iter.hasNext() && value == null) {
                SimpleExpressionResolver.ResolutionResult rr = iter.next().resolveExpressionContent(expressionContent);
                if (rr == null) continue;
                if (!rr.isDefault()) {
                    value = rr;
                    continue;
                }
                if (defaultValue != null) continue;
                defaultValue = rr;
            }
        }
        return value == null ? defaultValue : value;
    }
}

