/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.AddIfAbsentStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.DescribedAddStepHandler;
import org.jboss.as.clustering.controller.ManagementRegistrar;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.RuntimeResourceRegistration;
import org.jboss.as.clustering.controller.RuntimeResourceRegistrationStepHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.DefaultResourceAddDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AddStepHandler
extends AbstractAddStepHandler
implements ManagementRegistrar<ManagementResourceRegistration>,
DescribedAddStepHandler {
    private final AddStepHandlerDescriptor descriptor;
    private final ResourceServiceHandler handler;

    public AddStepHandler(AddStepHandlerDescriptor descriptor) {
        this(descriptor, null);
    }

    public AddStepHandler(AddStepHandlerDescriptor descriptor, ResourceServiceHandler handler) {
        this.descriptor = descriptor;
        this.handler = handler;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && this.handler != null;
    }

    @Override
    public AddStepHandlerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress parentAddress = address.getParent();
        PathElement path = address.getLastElement();
        OperationStepHandler parentHandler = context.getRootResourceRegistration().getOperationHandler(parentAddress, "add");
        if (parentHandler instanceof DescribedAddStepHandler) {
            AddStepHandlerDescriptor parentDescriptor = (AddStepHandlerDescriptor)((DescribedAddStepHandler)parentHandler).getDescriptor();
            if (parentDescriptor.getRequiredChildren().contains(path) && context.readResourceFromRoot(parentAddress, false).hasChild(path)) {
                context.addStep(Util.createRemoveOperation((PathAddress)address), context.getRootResourceRegistration().getOperationHandler(address, "remove"), OperationContext.Stage.MODEL);
                context.addStep(operation, (OperationStepHandler)this, OperationContext.Stage.MODEL);
                return;
            }
            for (PathElement requiredPath : parentDescriptor.getRequiredSingletonChildren()) {
                Set childrenNames;
                String requiredPathKey = requiredPath.getKey();
                if (!requiredPath.getKey().equals(path.getKey()) || (childrenNames = context.readResourceFromRoot(parentAddress, false).getChildrenNames(requiredPathKey)).isEmpty()) continue;
                for (String childName : childrenNames) {
                    PathAddress singletonAddress = parentAddress.append(requiredPathKey, childName);
                    context.addStep(Util.createRemoveOperation((PathAddress)singletonAddress), context.getRootResourceRegistration().getOperationHandler(singletonAddress, "remove"), OperationContext.Stage.MODEL);
                }
                context.addStep(operation, (OperationStepHandler)this, OperationContext.Stage.MODEL);
                return;
            }
        }
        super.execute(context, operation);
        if (this.requiresRuntime(context)) {
            for (RuntimeResourceRegistration registration : this.descriptor.getRuntimeResourceRegistrations()) {
                context.addStep((OperationStepHandler)new RuntimeResourceRegistrationStepHandler(registration), OperationContext.Stage.MODEL);
            }
        }
    }

    protected Resource createResource(OperationContext context) {
        Resource resource = Resource.Factory.create((boolean)context.getResourceRegistration().isRuntimeOnly());
        if (context.isDefaultRequiresRuntime()) {
            resource = (Resource)this.descriptor.getResourceTransformation().apply(resource);
        }
        context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        return resource;
    }

    protected Resource createResource(OperationContext context, ModelNode operation) {
        Integer index;
        UnaryOperator<Resource> transformation = context.isDefaultRequiresRuntime() ? this.descriptor.getResourceTransformation() : UnaryOperator.identity();
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        Resource resource = (Resource)transformation.apply(Resource.Factory.create((boolean)registration.isRuntimeOnly(), (Set)registration.getOrderedChildTypes()));
        Integer n = index = registration.isOrderedChildResource() && operation.hasDefined("add-index") ? operation.get("add-index").asIntOrNull() : null;
        if (index == null) {
            context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        } else {
            context.addResource(PathAddress.EMPTY_ADDRESS, index.intValue(), resource);
        }
        return resource;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        for (AttributeDefinition definition : this.descriptor.getExtraParameters()) {
            definition.validateOperation(operation);
        }
        PathAddress currentAddress = context.getCurrentAddress();
        Map<AttributeDefinition, AttributeTranslation> translations = this.descriptor.getAttributeTranslations();
        for (Map.Entry<AttributeDefinition, AttributeTranslation> entry : translations.entrySet()) {
            ImmutableManagementResourceRegistration registration;
            AttributeDefinition sourceParameter = entry.getKey();
            AttributeTranslation translation = entry.getValue();
            if (!operation.hasDefined(sourceParameter.getName())) continue;
            ModelNode value = sourceParameter.validateOperation(operation);
            ModelNode targetValue = translation.getWriteTranslator().translate(context, value);
            Attribute targetAttribute = translation.getTargetAttribute();
            PathAddress targetAddress = (PathAddress)translation.getPathAddressTransformation().apply(currentAddress);
            if (targetAddress == currentAddress) {
                String targetName = targetAttribute.getName();
                if (operation.hasDefined(targetName)) continue;
                operation.get(targetName).set(targetValue);
                continue;
            }
            ModelNode writeAttributeOperation = Util.getWriteAttributeOperation((PathAddress)targetAddress, (String)targetAttribute.getName(), (ModelNode)targetValue);
            ImmutableManagementResourceRegistration immutableManagementResourceRegistration = registration = currentAddress == targetAddress ? context.getResourceRegistration() : context.getRootResourceRegistration().getSubModel(targetAddress);
            if (registration == null) {
                throw new OperationFailedException(ControllerLogger.MGMT_OP_LOGGER.noSuchResourceType(targetAddress));
            }
            OperationStepHandler writeAttributeHandler = registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, targetAttribute.getName()).getWriteHandler();
            context.addStep(writeAttributeOperation, writeAttributeHandler, OperationContext.Stage.MODEL);
        }
        ModelNode model = resource.getModel();
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        for (String attributeName : registration.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
            AttributeAccess attribute = registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            AttributeDefinition definition = attribute.getAttributeDefinition();
            if (attribute.getStorageType() != AttributeAccess.Storage.CONFIGURATION || translations.containsKey(definition)) continue;
            OperationStepHandler writeHandler = this.descriptor.getCustomAttributes().get(definition);
            if (writeHandler != null) {
                ModelNode writeAttributeOperation = Util.getWriteAttributeOperation((PathAddress)currentAddress, (String)definition.getName(), (ModelNode)definition.validateOperation(operation));
                context.addStep(writeAttributeOperation, writeHandler, OperationContext.Stage.MODEL);
                continue;
            }
            definition.validateAndSet(operation, model);
        }
        AddStepHandler.addRequiredChildren(context, this.descriptor.getRequiredChildren(), (parent, path) -> parent.hasChild(path));
        AddStepHandler.addRequiredChildren(context, this.descriptor.getRequiredSingletonChildren(), (parent, path) -> parent.hasChildren(path.getKey()));
        if (!model.isDefined()) {
            model.setEmptyObject();
        }
    }

    private static void addRequiredChildren(OperationContext context, Collection<PathElement> paths, BiPredicate<Resource, PathElement> present) {
        for (PathElement path : paths) {
            context.addStep(Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{path})), (OperationStepHandler)new AddIfAbsentStepHandler(present), OperationContext.Stage.MODEL);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.handler.installServices(context, model);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        try {
            this.handler.removeServices(context, resource.getModel());
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ModelNode model = resource.getModel();
        for (Map.Entry<Capability, Predicate<ModelNode>> entry : this.descriptor.getCapabilities().entrySet()) {
            if (!entry.getValue().test(model)) continue;
            context.registerCapability(entry.getKey().resolve(address));
        }
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        for (String attributeName : registration.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
            AttributeDefinition attribute = registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName).getAttributeDefinition();
            if (!attribute.hasCapabilityRequirements()) continue;
            attribute.addCapabilityRequirements(context, resource, model.get(attributeName));
        }
        for (CapabilityReferenceRecorder recorder : registration.getRequirements()) {
            recorder.addCapabilityRequirements(context, resource, null, new String[0]);
        }
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder("add", this.descriptor.getDescriptionResolver()).setDescriptionProvider((DescriptionProvider)new DefaultResourceAddDescriptionProvider((ImmutableManagementResourceRegistration)registration, this.descriptor.getDescriptionResolver(), registration.isOrderedChildResource())).withFlag(OperationEntry.Flag.RESTART_NONE);
        if (registration.isOrderedChildResource()) {
            builder.addParameter((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"add-index", (ModelType)ModelType.INT, (boolean)true).build());
        }
        for (AttributeDefinition attribute : this.descriptor.getAttributes()) {
            builder.addParameter(attribute);
        }
        for (AttributeDefinition attribute : this.descriptor.getCustomAttributes().keySet()) {
            builder.addParameter(attribute);
        }
        for (AttributeDefinition attribute : this.descriptor.getIgnoredAttributes()) {
            builder.addParameter(attribute);
        }
        for (AttributeDefinition parameter : this.descriptor.getExtraParameters()) {
            builder.addParameter(parameter);
        }
        for (AttributeDefinition attribute : this.descriptor.getAttributeTranslations().keySet()) {
            builder.addParameter(attribute);
        }
        registration.registerOperationHandler((OperationDefinition)builder.build(), (OperationStepHandler)this.descriptor.getAddOperationTransformation().apply(this));
    }
}

