/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactory;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalImpl;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCJournalStorageManager
extends JournalStorageManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public JDBCJournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ExecutorFactory executorFactory, ExecutorFactory ioExecutorFactory, ScheduledExecutorService scheduledExecutorService) {
        super(config, analyzer, executorFactory, scheduledExecutorService, ioExecutorFactory);
    }

    public JDBCJournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, ExecutorFactory ioExecutorFactory, IOCriticalErrorListener criticalErrorListener) {
        super(config, analyzer, executorFactory, scheduledExecutorService, ioExecutorFactory, criticalErrorListener);
    }

    @Override
    protected synchronized void init(Configuration config, IOCriticalErrorListener criticalErrorListener) {
        try {
            DatabaseStorageConfiguration dbConf = (DatabaseStorageConfiguration)config.getStoreConfiguration();
            JDBCConnectionProvider connectionProvider = dbConf.getConnectionProvider();
            SQLProvider.Factory sqlProviderFactory = dbConf.getSqlProviderFactory();
            if (sqlProviderFactory == null) {
                sqlProviderFactory = new PropertySQLProvider.Factory(connectionProvider);
            }
            JDBCJournalImpl bindingsJournal = new JDBCJournalImpl(connectionProvider, sqlProviderFactory.create(dbConf.getBindingsTableName(), SQLProvider.DatabaseStoreType.BINDINGS_JOURNAL), this.scheduledExecutorService, (Executor)this.executorFactory.getExecutor(), criticalErrorListener, dbConf.getJdbcJournalSyncPeriodMillis());
            JDBCJournalImpl messageJournal = new JDBCJournalImpl(connectionProvider, sqlProviderFactory.create(dbConf.getMessageTableName(), SQLProvider.DatabaseStoreType.MESSAGE_JOURNAL), this.scheduledExecutorService, (Executor)this.executorFactory.getExecutor(), criticalErrorListener, dbConf.getJdbcJournalSyncPeriodMillis());
            JDBCSequentialFileFactory largeMessagesFactory = new JDBCSequentialFileFactory(connectionProvider, sqlProviderFactory.create(dbConf.getLargeMessageTableName(), SQLProvider.DatabaseStoreType.LARGE_MESSAGE), (Executor)this.executorFactory.getExecutor(), this.scheduledExecutorService, dbConf.getJdbcJournalSyncPeriodMillis(), criticalErrorListener);
            this.bindingsJournal = bindingsJournal;
            this.messageJournal = messageJournal;
            this.largeMessagesFactory = largeMessagesFactory;
            largeMessagesFactory.start();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            if (criticalErrorListener != null) {
                criticalErrorListener.onIOException((Throwable)e, e.getMessage(), null);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public final void addBytesToLargeMessage(SequentialFile file, long messageId, byte[] bytes) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            OperationContext context = this.getContext(true);
            context.storeLineUp();
            file.writeDirect(ByteBuffer.wrap(bytes), false, (IOCallback)context);
        }
    }

    @Override
    public final void addBytesToLargeMessage(SequentialFile file, long messageId, ActiveMQBuffer bytes) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            byte[] copiedBytes = new byte[bytes.readableBytes()];
            bytes.readBytes(copiedBytes);
            this.addBytesToLargeMessage(file, messageId, copiedBytes);
        }
    }

    @Override
    public synchronized void stop(boolean ioCriticalError, boolean sendFailover) throws Exception {
        if (!this.started) {
            return;
        }
        if (!ioCriticalError) {
            this.performCachedLargeMessageDeletes();
            if (this.journalLoaded && this.idGenerator != null) {
                this.idGenerator.persistCurrentID();
            }
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await(30L, TimeUnit.SECONDS);
        this.beforeStop();
        this.bindingsJournal.stop();
        this.messageJournal.stop();
        this.largeMessagesFactory.stop();
        this.journalLoaded = false;
        this.started = false;
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return NIOSequentialFileFactory.allocateDirectByteBuffer((int)size);
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
    }
}

