/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AmqpFlowControlFailDispositionTests
extends JMSClientTestSupport {
    private static final int MIN_LARGE_MESSAGE_SIZE = 16384;
    @Parameter(index=0)
    public boolean useModified;
    @Parameter(index=1)
    public Symbol[] outcomes;
    @Parameter(index=2)
    public String expectedMessage;

    @Parameters(name="useModified={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true, new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL}, "failure at remote"}, {true, new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL}, "[condition = amqp:resource-limit-exceeded]"}, {false, new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL}, "[condition = amqp:resource-limit-exceeded]"}, {false, new Symbol[0], "[condition = amqp:resource-limit-exceeded]"});
    }

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        AddressSettings addressSettings = (AddressSettings)server.getAddressSettingsRepository().getMatch("#");
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        addressSettings.setMaxSizeBytes(1000L);
        server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("amqpUseModifiedForTransientDeliveryErrors", this.useModified);
        params.put("amqpMinLargeMessageSize", 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=10L)
    public void testAddressFullDisposition() throws Exception {
        AmqpClient client = this.createAmqpClient(this.getBrokerAmqpConnectionURI());
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName(), null, null, this.outcomes);
            boolean rejected = false;
            for (int i = 0; i < 1000; ++i) {
                AmqpMessage message = new AmqpMessage();
                byte[] payload = new byte[10];
                message.setBytes(payload);
                try {
                    sender.send(message);
                    continue;
                }
                catch (IOException e) {
                    rejected = true;
                    Assertions.assertTrue((boolean)e.getMessage().contains(this.expectedMessage), (String)String.format("Unexpected message expected %s to contain %s", e.getMessage(), this.expectedMessage));
                    break;
                }
            }
            Assertions.assertTrue((boolean)rejected, (String)"Expected messages to be refused by broker");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=60L)
    public void testFailedLargeMessageSendWhenNoSpaceCleansUpLargeFile() throws Exception {
        AmqpClient client = this.createAmqpClient(this.getBrokerAmqpConnectionURI());
        int expectedRemainingLargeMessageFiles = 0;
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName(), null, null, this.outcomes);
            AmqpMessage message = this.createAmqpLargeMessage();
            boolean rejected = false;
            for (int i = 0; i < 1000; ++i) {
                try {
                    sender.send(message);
                    ++expectedRemainingLargeMessageFiles;
                    continue;
                }
                catch (IOException e) {
                    rejected = true;
                    Assertions.assertTrue((boolean)e.getMessage().contains(this.expectedMessage), (String)String.format("Unexpected message expected %s to contain %s", e.getMessage(), this.expectedMessage));
                    break;
                }
            }
            Assertions.assertTrue((boolean)rejected, (String)"Expected messages to be refused by broker");
        }
        this.validateNoFilesOnLargeDir(this.getLargeMessagesDir(), expectedRemainingLargeMessageFiles);
    }

    private AmqpMessage createAmqpLargeMessage() {
        AmqpMessage message = new AmqpMessage();
        byte[] payload = new byte[32768];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 65;
        }
        message.setMessageAnnotation("x-opt-big-blob", new String(payload, StandardCharsets.UTF_8));
        message.setText("test");
        return message;
    }
}

