/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.server.impl.QueueManagerImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AutoDeleteClusteredDestinationTest
extends ClusterTestBase {
    @Parameter(index=0)
    public MessageLoadBalancingType loadBalancingType = MessageLoadBalancingType.OFF;

    @Parameters(name="loadBalancingType = {0}")
    public static Iterable<? extends Object> loadBalancingType() {
        return Arrays.asList({MessageLoadBalancingType.OFF}, {MessageLoadBalancingType.STRICT}, {MessageLoadBalancingType.ON_DEMAND}, {MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
    }

    @TestTemplate
    public void testConnectionLoadBalancingAnonRun() throws Exception {
        String queueName = "queue";
        String url0 = "tcp://localhost:61616?useTopologyForLoadBalancing=false";
        String url1 = "tcp://localhost:61617?useTopologyForLoadBalancing=false";
        SimpleString simpleName = SimpleString.of((String)"queue");
        int messageCount = 10;
        int TIMEOUT = 5000;
        CountDownLatch latch = new CountDownLatch(10);
        MessageListener listener0 = message -> latch.countDown();
        MessageListener listener1 = message -> latch.countDown();
        this.setupClusterConnection("cluster0", "queue", this.loadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queue", this.loadBalancingType, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.waitForServerToStart(this.servers[0]);
        this.waitForServerToStart(this.servers[1]);
        AddressSettings settings = new AddressSettings().setRedistributionDelay(0L).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true)).setAutoDeleteQueues(Boolean.valueOf(true));
        this.servers[0].getAddressSettingsRepository().addMatch("queue", (Object)settings);
        this.servers[1].getAddressSettingsRepository().addMatch("queue", (Object)settings);
        try (ActiveMQConnectionFactory connectionFactory0 = new ActiveMQConnectionFactory("tcp://localhost:61616?useTopologyForLoadBalancing=false");
             ActiveMQConnectionFactory connectionFactory1 = new ActiveMQConnectionFactory("tcp://localhost:61617?useTopologyForLoadBalancing=false");
             Connection connection0 = connectionFactory0.createConnection();
             Connection connection1 = connectionFactory1.createConnection();
             Session consumerSession0 = connection0.createSession(false, 1);
             Session consumerSession1 = connection1.createSession(false, 1);
             Session producerSession0 = connection0.createSession(false, 1);){
            jakarta.jms.Queue queue = consumerSession0.createQueue("queue");
            MessageProducer producer0 = producerSession0.createProducer((Destination)queue);
            MessageConsumer consumer0 = consumerSession0.createConsumer((Destination)queue);
            MessageConsumer consumer1 = consumerSession1.createConsumer((Destination)queue);
            consumer0.setMessageListener(listener0);
            consumer1.setMessageListener(listener1);
            connection0.start();
            connection1.start();
            for (int i = 0; i < 10; ++i) {
                QueueImpl serverQueue;
                producer0.send((Message)producerSession0.createTextMessage("Message"));
                if (i == 2) {
                    serverQueue = (QueueImpl)this.servers[0].locateQueue(simpleName);
                    Wait.assertTrue(() -> serverQueue.getMessageCount() == 0L, (long)5000L, (long)100L);
                    consumer0.close();
                    QueueManagerImpl.performAutoDeleteQueue((ActiveMQServer)this.servers[0], (Queue)serverQueue);
                    Wait.assertTrue(() -> this.servers[0].getPostOffice().getAddressInfo(simpleName).getBindingRemovedTimestamp() != -1L, (long)5000L, (long)100L);
                }
                if (i != 6) continue;
                consumer0 = consumerSession0.createConsumer((Destination)queue);
                consumer0.setMessageListener(listener0);
                serverQueue = (QueueImpl)this.servers[0].locateQueue(simpleName);
                Wait.assertTrue(() -> serverQueue.getConsumerCount() == 1, (long)5000L, (long)100L);
            }
            Assertions.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
        }
    }

    protected boolean isNetty() {
        return true;
    }

    @Override
    protected boolean isFileStorage() {
        return false;
    }
}

