/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.federation;

import java.util.concurrent.ScheduledFuture;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.federation.FederatedQueueConsumerImpl;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FederatedQueueConsumerTest
extends ActiveMQTestBase {
    @Test
    public void testClose() throws Exception {
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig());
        server.start();
        Federation federation = new Federation(server, new FederationConfiguration().setName(RandomUtil.randomString()));
        federation.start();
        FederatedQueueConsumerImpl consumer = new FederatedQueueConsumerImpl(federation, server, null, null, null, null);
        Assertions.assertNull((Object)consumer.getCurrentConnectTask());
        consumer.start();
        Assertions.assertNotNull((Object)consumer.getCurrentConnectTask());
        consumer.close();
        Wait.assertTrue(() -> {
            ScheduledFuture task = consumer.getCurrentConnectTask();
            return (task.isDone() || task.isCancelled()) && task == consumer.getCurrentConnectTask();
        }, (long)2000L, (long)50L);
    }
}

