/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import jakarta.jms.XAConnection;
import jakarta.jms.XASession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Connection conn2;

    @Test
    public void testThroughNewConnectionFactory() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://0");
        this.testThroughNewConnectionFactory(connectionFactory);
        connectionFactory = (ActiveMQConnectionFactory)this.serialClone(connectionFactory);
        this.testThroughNewConnectionFactory(connectionFactory);
        connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616?&blockOnNonDurableSend=true&retryIntervalMultiplier=1.0&maxRetryInterval=2000&producerMaxRate=-1&blockOnDurableSend=true&connectionTTL=60000&compressLargeMessage=false&reconnectAttempts=0&cacheLargeMessagesClient=false&scheduledThreadPoolMaxSize=5&useGlobalPools=true&callFailoverTimeout=-1&initialConnectAttempts=1&clientFailureCheckPeriod=30000&blockOnAcknowledge=true&consumerWindowSize=1048576&minLargeMessageSize=102400&autoGroup=false&threadPoolMaxSize=-1&confirmationWindowSize=-1&transactionBatchSize=1048576&callTimeout=30000&preAcknowledge=false&connectionLoadBalancingPolicyClassName=org.apache.activemq.artemis.api.core.client.loadbalance.RoundRobinConnectionLoadBalancingPolicy&dupsOKBatchSize=1048576&initialMessagePacketSize=1500&consumerMaxRate=-1&retryInterval=2000&producerWindowSize=65536&port=61616&host=localhost#");
        this.testThroughNewConnectionFactory(connectionFactory);
        connectionFactory = (ActiveMQConnectionFactory)this.serialClone(connectionFactory);
        this.testThroughNewConnectionFactory(connectionFactory);
    }

    private void testThroughNewConnectionFactory(ActiveMQConnectionFactory factory) throws Exception {
        Connection conn = factory.createConnection();
        conn.close();
        try (JMSContext ctx = factory.createContext();){
            ctx.createProducer().send((Destination)ctx.createQueue("queue"), "Test");
        }
        ctx = factory.createContext();
        try {
            Assertions.assertNotNull((Object)ctx.createConsumer((Destination)ctx.createQueue("queue")).receiveNoWait());
            Assertions.assertNull((Object)ctx.createConsumer((Destination)ctx.createQueue("queue")).receiveNoWait());
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        factory.close();
    }

    @Test
    public void testSetSameIdToDifferentConnections() throws Exception {
        String id = "somethingElse" + this.name;
        this.conn = this.cf.createConnection();
        this.conn2 = this.cf.createConnection();
        this.conn.getClientID();
        this.conn.setClientID(id);
        try {
            this.conn2.setClientID(id);
            Assertions.fail((String)"should not happen.");
        }
        catch (InvalidClientIDException invalidClientIDException) {
            // empty catch block
        }
        Session session1 = this.conn.createSession();
        Session session2 = this.conn.createSession();
        session1.close();
        session2.close();
    }

    @Test
    public void testTwoConnectionsSameIDThroughCF() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616?clientID=myid");
        this.conn = connectionFactory.createConnection();
        try {
            this.conn2 = connectionFactory.createConnection();
            Assertions.fail((String)"Exception expected");
        }
        catch (InvalidClientIDException invalidClientIDException) {
            // empty catch block
        }
        Session session1 = this.conn.createSession();
        Session session2 = this.conn.createSession();
        session1.close();
        session2.close();
    }

    @Test
    public void testTwoConnectionsSameIDThroughCFWithShareClientIDEnabeld() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616?clientID=myid;enableSharedClientID=true");
        this.conn = connectionFactory.createConnection();
        try {
            this.conn2 = connectionFactory.createConnection();
        }
        catch (InvalidClientIDException expected) {
            Assertions.fail((String)"Should allow sharing of client IDs among the same CF");
        }
        Session session1 = this.conn.createSession();
        Session session2 = this.conn.createSession();
        Session session3 = this.conn2.createSession();
        Session session4 = this.conn2.createSession();
        session1.close();
        session2.close();
        session3.close();
        session4.close();
    }

    @Test
    public void testGetSetConnectionFactory() throws Exception {
        this.conn = this.cf.createConnection();
        this.conn.getClientID();
        this.conn.setClientID("somethingElse");
    }

    @Test
    public void testTXTypeInvalid() throws Exception {
        this.conn = this.cf.createConnection();
        Session sess = this.conn.createSession(false, 0);
        Assertions.assertEquals((int)1, (int)sess.getAcknowledgeMode());
        sess.close();
        TopicSession tpSess = ((TopicConnection)this.conn).createTopicSession(false, 0);
        Assertions.assertEquals((int)1, (int)tpSess.getAcknowledgeMode());
        tpSess.close();
        QueueSession qSess = ((QueueConnection)this.conn).createQueueSession(false, 0);
        Assertions.assertEquals((int)1, (int)qSess.getAcknowledgeMode());
        qSess.close();
    }

    @Test
    public void testXAInstanceof() throws Exception {
        this.conn = this.cf.createConnection();
        Assertions.assertFalse((boolean)(this.conn instanceof XAConnection));
        Session sess = this.conn.createSession(false, 1);
        Assertions.assertFalse((boolean)(sess instanceof XASession));
    }

    @Test
    public void testConnectionFactorySerialization() throws Exception {
        ConnectionFactory newCF = this.getCFThruSerialization(this.cf);
        this.testCreateConnection(newCF);
        try (Connection aConn = null;){
            aConn = this.cf.createConnection();
            newCF = this.getCFThruSerialization(this.cf);
            this.testCreateConnection(newCF);
        }
    }

    private ConnectionFactory getCFThruSerialization(ConnectionFactory fact) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this.cf);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        ConnectionFactory newCF = (ConnectionFactory)ois.readObject();
        oos.close();
        ois.close();
        return newCF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCreateConnection(ConnectionFactory fact) throws Exception {
        try (Connection newConn = null;){
            newConn = fact.createConnection();
            newConn.start();
            newConn.stop();
            Session session1 = newConn.createSession(false, 2);
            session1.close();
            Session session2 = newConn.createSession(true, 0);
            session2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSessionAndCloseConnectionConcurrently() throws Exception {
        int ATTEMPTS = 10;
        int THREAD_COUNT = 50;
        int SESSION_COUNT = 10;
        ExecutorService executor = Executors.newFixedThreadPool(50);
        try {
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://127.0.0.1:61616");
            for (int i = 0; i < 10; ++i) {
                CountDownLatch lineUp = new CountDownLatch(50);
                AtomicBoolean error = new AtomicBoolean(false);
                Connection connection = cf.createConnection();
                for (int j = 0; j < 50; ++j) {
                    executor.execute(() -> {
                        for (int k = 0; k < 10; ++k) {
                            try {
                                connection.createSession().close();
                                if (k != 0) continue;
                                lineUp.countDown();
                                continue;
                            }
                            catch (IllegalStateException e) {
                                break;
                            }
                            catch (JMSException e) {
                                break;
                            }
                            catch (Throwable t) {
                                logger.warn(t.getMessage(), t);
                                error.set(true);
                                break;
                            }
                        }
                    });
                }
                Assertions.assertTrue((boolean)lineUp.await(10L, TimeUnit.SECONDS));
                connection.close();
                if (!error.get()) continue;
                Assertions.assertFalse((boolean)error.get());
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.conn2 != null) {
            this.conn2.close();
        }
        super.tearDown();
    }
}

