/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.management.MBeanServer;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiprotocolJMSClientTestSupport
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static LinkedList<Connection> jmsConnections = new LinkedList();
    protected static final int PORT = 5672;
    protected static final String BROKER_NAME = "localhost";
    protected static final String NETTY_ACCEPTOR = "netty-acceptor";
    protected String noprivUser = "noprivs";
    protected String noprivPass = "noprivs";
    protected String browseUser = "browser";
    protected String browsePass = "browser";
    protected String guestUser = "guest";
    protected String guestPass = "guest";
    protected String fullUser = "user";
    protected String fullPass = "pass";
    protected ActiveMQServer server;
    protected MBeanServer mBeanServer = this.createMBeanServer();
    protected ConnectionSupplier AMQPConnection = () -> this.createConnection();
    protected ConnectionSupplier CoreConnection = () -> this.createCoreConnection();
    protected ConnectionSupplier OpenWireConnection = () -> this.createOpenWireConnection();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AfterEach
    public void tearDown() throws Exception {
        try {
            for (Connection connection : jmsConnections) {
                try {
                    connection.close();
                }
                catch (Throwable ignored) {
                    ignored.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.warn("Exception during tearDown", (Throwable)e);
        }
        jmsConnections.clear();
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected boolean isAutoCreateQueues() {
        return true;
    }

    protected boolean isAutoCreateAddresses() {
        return true;
    }

    protected boolean isSecurityEnabled() {
        return false;
    }

    protected String getDeadLetterAddress() {
        return "ActiveMQ.DLQ";
    }

    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672);
    }

    protected ActiveMQServer createServer(int port) throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        server.getConfiguration().getAcceptorConfigurations().clear();
        server.getConfiguration().getAcceptorConfigurations().add(this.addAcceptorConfiguration(server, port));
        server.getConfiguration().setName(BROKER_NAME);
        server.getConfiguration().setJournalDirectory(server.getConfiguration().getJournalDirectory() + port);
        server.getConfiguration().setBindingsDirectory(server.getConfiguration().getBindingsDirectory() + port);
        server.getConfiguration().setPagingDirectory(server.getConfiguration().getPagingDirectory() + port);
        if (port == 5672) {
            server.getConfiguration().setLargeMessagesDirectory(server.getConfiguration().getLargeMessagesDirectory());
        } else {
            server.getConfiguration().setLargeMessagesDirectory(server.getConfiguration().getLargeMessagesDirectory() + port);
        }
        server.getConfiguration().setJMXManagementEnabled(true);
        server.getConfiguration().setMessageExpiryScanPeriod(100L);
        server.setMBeanServer(this.mBeanServer);
        this.addAdditionalAcceptors(server);
        this.configureAddressPolicy(server);
        this.configureBrokerSecurity(server);
        this.addConfiguration(server);
        server.start();
        this.createAddressAndQueues(server);
        return server;
    }

    protected void addConfiguration(ActiveMQServer server) throws Exception {
    }

    protected TransportConfiguration addAcceptorConfiguration(ActiveMQServer server, int port) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("port", String.valueOf(port));
        params.put("protocols", this.getConfiguredProtocols());
        HashMap amqpParams = new HashMap();
        TransportConfiguration tc = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, NETTY_ACCEPTOR, amqpParams);
        return tc;
    }

    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    protected void configureAddressPolicy(ActiveMQServer server) {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(this.isAutoCreateQueues()));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(this.isAutoCreateAddresses()));
        addressSettings.setDeadLetterAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        server.getConfiguration().getAddressSettings().put("#", addressSettings);
        Set acceptors = server.getConfiguration().getAcceptorConfigurations();
        for (TransportConfiguration tc : acceptors) {
            if (!tc.getName().equals(NETTY_ACCEPTOR)) continue;
            tc.getExtraParams().put("anycastPrefix", "anycast://");
            tc.getExtraParams().put("multicastPrefix", "multicast://");
        }
    }

    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
    }

    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
    }

    protected void configureBrokerSecurity(ActiveMQServer server) {
        if (this.isSecurityEnabled()) {
            this.enableSecurity(server, new String[0]);
        } else {
            server.getConfiguration().setSecurityEnabled(false);
        }
    }

    protected void enableSecurity(ActiveMQServer server, String ... securityMatches) {
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser(this.noprivUser, this.noprivPass);
        securityManager.getConfiguration().addRole(this.noprivUser, "nothing");
        securityManager.getConfiguration().addUser(this.browseUser, this.browsePass);
        securityManager.getConfiguration().addRole(this.browseUser, "browser");
        securityManager.getConfiguration().addUser(this.guestUser, this.guestPass);
        securityManager.getConfiguration().addRole(this.guestUser, "guest");
        securityManager.getConfiguration().addUser(this.fullUser, this.fullPass);
        securityManager.getConfiguration().addRole(this.fullUser, "full");
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        HashSet<Role> value = new HashSet<Role>();
        value.add(new Role("nothing", false, false, false, false, false, false, false, false, false, false, false, false));
        value.add(new Role("browser", false, false, false, false, false, false, false, true, false, false, false, false));
        value.add(new Role("guest", false, true, false, false, false, false, false, true, false, false, false, false));
        value.add(new Role("full", true, true, true, true, true, true, true, true, true, true, false, false));
        securityRepository.addMatch("#", value);
        for (String match : securityMatches) {
            securityRepository.addMatch(match, value);
        }
        server.getConfiguration().setSecurityEnabled(true);
    }

    public String getTopicName() {
        return this.getName() + "-Topic";
    }

    public String getQueueName() {
        return this.getName();
    }

    public Queue getProxyToQueue(String queueName) {
        return this.server.locateQueue(SimpleString.of((String)queueName));
    }

    private Connection trackJMSConnection(Connection connection) {
        jmsConnections.add(connection);
        return connection;
    }

    protected String getJmsConnectionURIOptions() {
        return "";
    }

    protected String getBrokerQpidJMSConnectionString() {
        try {
            Object uri = "amqp://127.0.0.1:5672";
            if (!this.getJmsConnectionURIOptions().isEmpty()) {
                uri = (String)uri + "?" + this.getJmsConnectionURIOptions();
            }
            return uri;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected URI getBrokerQpidJMSConnectionURI() {
        try {
            return new URI(this.getBrokerQpidJMSConnectionString());
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected URI getBrokerQpidJMSFailoverConnectionURI() {
        try {
            return new URI("failover:(" + this.getBrokerQpidJMSConnectionString() + ")");
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected Connection createConnection() throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), null, null, null, true);
    }

    protected Connection createFailoverConnection() throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSFailoverConnectionURI(), null, null, null, true);
    }

    protected Connection createConnection(boolean start) throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), null, null, null, start);
    }

    protected Connection createConnection(String clientId) throws JMSException {
        return this.createConnection(this.getBrokerQpidJMSConnectionURI(), null, null, clientId, true);
    }

    protected Connection createConnection(URI remoteURI, String username, String password, String clientId, boolean start) throws JMSException {
        JmsConnectionFactory factory = new JmsConnectionFactory(remoteURI);
        Connection connection = this.trackJMSConnection(factory.createConnection(username, password));
        connection.setExceptionListener(exception -> exception.printStackTrace());
        if (clientId != null && !clientId.isEmpty()) {
            connection.setClientID(clientId);
        }
        if (start) {
            connection.start();
        }
        return connection;
    }

    protected String getBrokerCoreJMSConnectionString() {
        try {
            Object uri = "tcp://127.0.0.1:5672";
            if (!this.getJmsConnectionURIOptions().isEmpty()) {
                uri = (String)uri + "?" + this.getJmsConnectionURIOptions();
            }
            return uri;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected Connection createCoreConnection() throws JMSException {
        return this.createCoreConnection(this.getBrokerCoreJMSConnectionString(), null, null, null, true);
    }

    protected Connection createCoreConnection(boolean start) throws JMSException {
        return this.createCoreConnection(this.getBrokerCoreJMSConnectionString(), null, null, null, start);
    }

    protected Connection createCoreConnection(String clientId) throws JMSException {
        return this.createCoreConnection(this.getBrokerCoreJMSConnectionString(), null, null, clientId, true);
    }

    protected Connection createCoreConnection(String connectionString, String username, String password, String clientId, boolean start) throws JMSException {
        ActiveMQJMSConnectionFactory factory = new ActiveMQJMSConnectionFactory(connectionString);
        Connection connection = this.trackJMSConnection(factory.createConnection(username, password));
        connection.setExceptionListener(exception -> exception.printStackTrace());
        if (clientId != null && !clientId.isEmpty()) {
            connection.setClientID(clientId);
        }
        if (start) {
            connection.start();
        }
        return connection;
    }

    protected String getBrokerOpenWireJMSConnectionString() {
        try {
            Object uri = "tcp://127.0.0.1:5672";
            uri = !this.getJmsConnectionURIOptions().isEmpty() ? (String)uri + "?" + this.getJmsConnectionURIOptions() : (String)uri + "?wireFormat.cacheEnabled=true";
            return uri;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected Connection createOpenWireConnection() throws JMSException {
        return this.createOpenWireConnection(this.getBrokerOpenWireJMSConnectionString(), null, null, null, true);
    }

    protected Connection createOpenWireConnection(boolean start) throws JMSException {
        return this.createOpenWireConnection(this.getBrokerOpenWireJMSConnectionString(), null, null, null, start);
    }

    protected Connection createOpenWireConnection(String clientId) throws JMSException {
        return this.createOpenWireConnection(this.getBrokerOpenWireJMSConnectionString(), null, null, clientId, true);
    }

    protected Connection createOpenWireConnection(String connectionString, String username, String password, String clientId, boolean start) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(connectionString);
        Connection connection = this.trackJMSConnection(factory.createConnection(username, password));
        connection.setExceptionListener(exception -> exception.printStackTrace());
        if (clientId != null && !clientId.isEmpty()) {
            connection.setClientID(clientId);
        }
        if (start) {
            connection.start();
        }
        return connection;
    }

    static interface ConnectionSupplier {
        public Connection createConnection() throws JMSException;
    }
}

