/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XASession;
import java.lang.invoke.MethodHandles;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImplTestAccessor;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTXCounterTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ADDRESS = "PendingTXCounterTest";
    ActiveMQServer server;
    protected static final int PAGE_MAX = 10240;
    protected static final int PAGE_SIZE = 1024;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultConfig(0, true).setJournalSyncNonTransactional(false);
        config.setMessageExpiryScanPeriod(-1L);
        this.server = this.createServer(true, config, 1024, 10240L);
        this.server.getAddressSettingsRepository().clear();
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(1024).setMaxSizeBytes(10240L).setMaxReadPageBytes(-1).setMaxSizeMessages(0L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(ADDRESS).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)ADDRESS).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testPendingSendCoreCommit() throws Exception {
        this.pendingSend("CORE", false, true);
    }

    @Test
    public void testPendingSendCoreCommitNoRestart() throws Exception {
        this.pendingSend("CORE", false, false);
    }

    @Test
    public void testPendingSendCoreRollback() throws Exception {
        this.pendingSend("CORE", true, true);
    }

    @Test
    public void testPendingSendCoreRollbackNoRestart() throws Exception {
        this.pendingSend("CORE", false, false);
    }

    private void pendingSend(String protocol, boolean rollback, boolean restart) throws Exception {
        TextMessage message;
        int i;
        jakarta.jms.Queue queue;
        XASession session;
        AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();
        this.runAfter(() -> loggerHandler.close());
        Queue serverQueue = this.server.locateQueue(ADDRESS);
        int INITIAL_NUMBER_OF_MESSAGES = 10;
        int EXTRA_SEND = 20;
        int TOTAL_MESSAGES = rollback ? 10 : 30;
        ConnectionFactory cf = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();
             Session session2 = connection.createSession(false, 1);){
            jakarta.jms.Queue queue2 = session2.createQueue(ADDRESS);
            MessageProducer producer = session2.createProducer((Destination)queue2);
            for (int i2 = 0; i2 < 10; ++i2) {
                TextMessage message2 = session2.createTextMessage("hello " + i2);
                message2.setIntProperty("i", i2);
                producer.send((Message)message2);
            }
        }
        Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ222038"}), (long)2000L);
        Wait.assertEquals((long)10L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        XidImpl xid = this.newXID();
        try (XAConnection connection = ((XAConnectionFactory)cf).createXAConnection();){
            session = connection.createXASession();
            try {
                queue = session.createQueue(ADDRESS);
                MessageProducer producer = session.createProducer((Destination)queue);
                session.getXAResource().start((Xid)xid, 0);
                for (i = 10; i < 30; ++i) {
                    message = session.createTextMessage("hello " + i);
                    message.setIntProperty("i", i);
                    producer.send((Message)message);
                }
                session.getXAResource().end((Xid)xid, 0x4000000);
                session.getXAResource().prepare((Xid)xid);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        Wait.assertEquals((long)10L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        if (restart) {
            this.server.stop();
            this.server.start();
        }
        serverQueue = this.server.locateQueue(ADDRESS);
        Wait.assertEquals((long)10L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        connection = ((XAConnectionFactory)cf).createXAConnection();
        try {
            session = connection.createXASession();
            try {
                if (rollback) {
                    session.getXAResource().rollback((Xid)xid);
                } else {
                    session.getXAResource().commit((Xid)xid, false);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Wait.assertEquals((long)TOTAL_MESSAGES, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        connection = cf.createConnection();
        try {
            session = connection.createSession(false, 1);
            try {
                queue = session.createQueue(ADDRESS);
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                connection.start();
                for (i = 0; i < TOTAL_MESSAGES; ++i) {
                    message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((Object)("hello " + i), (Object)message.getText());
                    Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                }
                Assertions.assertTrue((serverQueue.getMessageCount() >= 0L ? (byte)1 : 0) != 0);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Wait.assertEquals((long)0L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        Queue localRefQueue = serverQueue;
        Wait.assertEquals((long)0L, () -> QueueImplTestAccessor.getQueueMemorySize(localRefQueue));
    }

    @Test
    public void testPendingACKTXRollbackCore() throws Exception {
        this.pendingACKTXRollback("CORE", true, true);
    }

    @Test
    public void testPendingACKTXCommitCore() throws Exception {
        this.pendingACKTXRollback("CORE", false, true);
    }

    @Test
    public void testPendingACKTXRollbackCoreNoRestart() throws Exception {
        this.pendingACKTXRollback("CORE", true, false);
    }

    @Test
    public void testPendingACKTXCommitCoreNoRestart() throws Exception {
        this.pendingACKTXRollback("CORE", false, false);
    }

    private void pendingACKTXRollback(String protocol, boolean rollback, boolean restart) throws Exception {
        MessageConsumer consumer;
        jakarta.jms.Queue queue;
        Session session;
        AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();
        this.runAfter(() -> loggerHandler.close());
        Queue serverQueue = this.server.locateQueue(ADDRESS);
        int NUMBER_OF_MESSAGES = 15;
        ConnectionFactory cf = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();
             Session session2 = connection.createSession(false, 1);){
            jakarta.jms.Queue queue2 = session2.createQueue(ADDRESS);
            MessageProducer producer = session2.createProducer((Destination)queue2);
            for (int i = 0; i < 15; ++i) {
                TextMessage message = session2.createTextMessage("hello " + i);
                message.setIntProperty("i", i);
                message.setStringProperty("text", "hello " + i);
                producer.send((Message)message);
            }
        }
        Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ222038"}), (long)2000L);
        Wait.assertEquals((long)15L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        XidImpl xid1 = this.newXID();
        XidImpl xid2 = this.newXID();
        for (int repeat = 0; repeat < 2; ++repeat) {
            XidImpl xid = repeat == 0 ? xid1 : xid2;
            int startPosition = 5 * repeat;
            int endPosition = startPosition + 5;
            try (XAConnection connection = ((XAConnectionFactory)cf).createXAConnection();
                 XASession session3 = connection.createXASession();){
                jakarta.jms.Queue queue3 = session3.createQueue(ADDRESS);
                MessageConsumer consumer2 = session3.createConsumer((Destination)queue3);
                connection.start();
                session3.getXAResource().start((Xid)xid, 0);
                for (int i = startPosition; i < endPosition; ++i) {
                    TextMessage message = (TextMessage)consumer2.receive(1000L);
                    Assertions.assertEquals((Object)("hello " + i), (Object)message.getText());
                    Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                }
                session3.getXAResource().end((Xid)xid, 0x4000000);
                session3.getXAResource().prepare((Xid)xid);
                if (repeat != 0) continue;
                session3.getXAResource().commit((Xid)xid, false);
                continue;
            }
        }
        Wait.assertEquals((long)10L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        try (Connection connection = cf.createConnection();){
            session = connection.createSession(true, 0);
            try {
                queue = session.createQueue(ADDRESS);
                connection.start();
                consumer = session.createConsumer((Destination)queue);
                for (int i = 10; i < 15; ++i) {
                    TextMessage message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    logger.info("Received {}", (Object)message.getText());
                    Assertions.assertEquals((Object)("hello " + i), (Object)message.getText());
                    Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
                session.rollback();
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        Wait.assertEquals((long)10L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        if (restart) {
            this.server.stop();
            this.server.start();
        }
        serverQueue = this.server.locateQueue(ADDRESS);
        Wait.assertEquals((long)10L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        logger.info("Before tx = {}", (Object)serverQueue.getMessageCount());
        connection = ((XAConnectionFactory)cf).createXAConnection();
        try {
            session = connection.createXASession();
            try {
                if (rollback) {
                    session.getXAResource().rollback((Xid)xid2);
                } else {
                    session.getXAResource().commit((Xid)xid2, false);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        if (rollback) {
            Wait.assertEquals((long)10L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        } else {
            Wait.assertEquals((long)5L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        }
        connection = cf.createConnection();
        try {
            session = connection.createSession(false, 1);
            try {
                queue = session.createQueue(ADDRESS);
                consumer = session.createConsumer((Destination)queue);
                connection.start();
                int start = rollback ? 5 : 10;
                logger.debug("start is at {}, since rollback={}", (Object)start, (Object)rollback);
                for (int i = start; i < 15; ++i) {
                    TextMessage message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    logger.debug("Received message {}", (Object)message.getText());
                    Assertions.assertEquals((Object)("hello " + i), (Object)message.getText());
                    Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
                Assertions.assertTrue((serverQueue.getMessageCount() >= 0L ? (byte)1 : 0) != 0);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Wait.assertEquals((long)0L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L);
        Queue localRefQueue = serverQueue;
        Wait.assertEquals((long)0L, () -> QueueImplTestAccessor.getQueueMemorySize(localRefQueue), (long)2000L);
    }
}

