/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleDownDeterminism
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupPrimaryServer(0, this.isFileStorage(), ClusterTestBase.HAType.SharedNothingReplication, this.isNetty(), true);
        this.servers[0].getConfiguration().setSecurityEnabled(true);
        this.setupPrimaryServer(1, this.isFileStorage(), ClusterTestBase.HAType.SharedNothingReplication, this.isNetty(), true);
        this.servers[1].getConfiguration().setSecurityEnabled(true);
        this.setupPrimaryServer(2, this.isFileStorage(), ClusterTestBase.HAType.SharedNothingReplication, this.isNetty(), true);
        this.servers[2].getConfiguration().setSecurityEnabled(true);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty(), false, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        this.setupSessionFactory(1, this.isNetty(), false, this.servers[1].getConfiguration().getClusterUser(), this.servers[1].getConfiguration().getClusterPassword());
        this.setupSessionFactory(2, this.isNetty(), false, this.servers[2].getConfiguration().getClusterUser(), this.servers[2].getConfiguration().getClusterPassword());
        logger.debug("===============================");
        logger.debug("Node 0: {}", (Object)this.servers[0].getClusterManager().getNodeId());
        logger.debug("Node 1: {}", (Object)this.servers[1].getClusterManager().getNodeId());
        logger.debug("Node 2: {}", (Object)this.servers[2].getClusterManager().getNodeId());
        logger.debug("===============================");
        this.servers[0].setIdentity("Node0");
        this.servers[1].setIdentity("Node1");
        this.servers[2].setIdentity("Node2");
    }

    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testScaleDownDeterministically() throws Exception {
        String queueName = "testQueue";
        int messageCount = 10;
        ClientSession session = this.sfs[0].createSession(this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword(), false, true, false, false, 0);
        this.createQueue(0, "testQueue", "testQueue", null, false, this.servers[0].getConfiguration().getClusterUser(), this.servers[0].getConfiguration().getClusterPassword());
        ClientProducer producer = session.createProducer("testQueue");
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        session.close();
        this.sfs[0].close();
        this.servers[0].getActiveMQServerControl().addConnector("scaleDown", "tcp://localhost:61617");
        ((TransportConfiguration)this.servers[0].getConfiguration().getConnectorConfigurations().get("scaleDown")).getParams().remove("host");
        String server0connector2 = (String)((ClusterConnectionConfiguration)this.servers[0].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors().get(1);
        String server1connector1 = (String)((ClusterConnectionConfiguration)this.servers[1].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors().get(0);
        this.servers[0].getActiveMQServerControl().scaleDown("scaleDown");
        Assertions.assertEquals((long)10L, (long)this.servers[1].getTotalMessageCount());
        this.servers[0].start();
        this.waitForServerToStart(this.servers[0]);
        Assertions.assertEquals((long)0L, (long)this.servers[0].getTotalMessageCount());
        this.servers[1].getActiveMQServerControl().scaleDown(server1connector1);
        Assertions.assertEquals((long)10L, (long)this.servers[0].getTotalMessageCount());
        this.servers[1].start();
        this.waitForServerToStart(this.servers[1]);
        this.servers[0].getActiveMQServerControl().scaleDown(server0connector2);
        Assertions.assertEquals((long)10L, (long)this.servers[2].getTotalMessageCount());
    }
}

