/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class SequentialFileFactoryTestBase
extends ActiveMQTestBase {
    protected SequentialFileFactory factory;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.factory = this.createFactory(this.getTestDir());
        this.factory.start();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.factory.stop();
        this.factory = null;
        ActiveMQTestBase.forceGC();
        Assertions.assertEquals((long)0L, (long)LibaioContext.getTotalMaxIO());
        super.tearDown();
    }

    protected abstract SequentialFileFactory createFactory(String var1);

    @Test
    public void listFilesOnNonExistentFolder() throws Exception {
        SequentialFileFactory fileFactory = this.createFactory("./target/dontexist");
        List list = fileFactory.listFiles("tmp");
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testCreateAndListFiles() throws Exception {
        ArrayList<CallSite> expectedFiles = new ArrayList<CallSite>();
        int numFiles = 10;
        for (int i = 0; i < 10; ++i) {
            String fileName = UUID.randomUUID().toString() + ".amq";
            expectedFiles.add((CallSite)((Object)fileName));
            SequentialFile sf = this.factory.createSequentialFile(fileName);
            sf.open();
            Assertions.assertEquals((Object)fileName, (Object)sf.getFileName());
            sf.close();
        }
        SequentialFile sf1 = this.factory.createSequentialFile("different.file");
        sf1.open();
        SequentialFile sf2 = this.factory.createSequentialFile("different.cheese");
        sf2.open();
        List fileNames = this.factory.listFiles("amq");
        Assertions.assertEquals((int)expectedFiles.size(), (int)fileNames.size());
        for (String string : expectedFiles) {
            Assertions.assertTrue((boolean)fileNames.contains(string));
        }
        fileNames = this.factory.listFiles("file");
        Assertions.assertEquals((int)1, (int)fileNames.size());
        Assertions.assertTrue((boolean)fileNames.contains("different.file"));
        fileNames = this.factory.listFiles("cheese");
        Assertions.assertEquals((int)1, (int)fileNames.size());
        Assertions.assertTrue((boolean)fileNames.contains("different.cheese"));
        sf1.close();
        sf2.close();
    }

    @Test
    public void testFill() throws Exception {
        sf.open();
        try (SequentialFile sf = this.factory.createSequentialFile("fill.amq");){
            this.checkFill(this.factory, sf, 2048);
            this.checkFill(this.factory, sf, 512);
            this.checkFill(this.factory, sf, 2048);
        }
    }

    @Test
    public void testDelete() throws Exception {
        SequentialFile sf = this.factory.createSequentialFile("delete-me.amq");
        sf.open();
        SequentialFile sf2 = this.factory.createSequentialFile("delete-me2.amq");
        sf2.open();
        List fileNames = this.factory.listFiles("amq");
        Assertions.assertEquals((int)2, (int)fileNames.size());
        Assertions.assertTrue((boolean)fileNames.contains("delete-me.amq"));
        Assertions.assertTrue((boolean)fileNames.contains("delete-me2.amq"));
        sf.delete();
        fileNames = this.factory.listFiles("amq");
        Assertions.assertEquals((int)1, (int)fileNames.size());
        Assertions.assertTrue((boolean)fileNames.contains("delete-me2.amq"));
        sf2.close();
    }

    @Test
    public void testRename() throws Exception {
        SequentialFile sf = this.factory.createSequentialFile("test1.amq");
        sf.open();
        List fileNames = this.factory.listFiles("amq");
        Assertions.assertEquals((int)1, (int)fileNames.size());
        Assertions.assertTrue((boolean)fileNames.contains("test1.amq"));
        sf.renameTo("test1.cmp");
        fileNames = this.factory.listFiles("cmp");
        Assertions.assertEquals((int)1, (int)fileNames.size());
        Assertions.assertTrue((boolean)fileNames.contains("test1.cmp"));
        sf.delete();
        fileNames = this.factory.listFiles("amq");
        Assertions.assertEquals((int)0, (int)fileNames.size());
        fileNames = this.factory.listFiles("cmp");
        Assertions.assertEquals((int)0, (int)fileNames.size());
    }

    @Test
    public void testWriteandRead() throws Exception {
        int i;
        SequentialFile sf = this.factory.createSequentialFile("write.amq");
        sf.open();
        String s1 = "aardvark";
        byte[] bytes1 = s1.getBytes(StandardCharsets.UTF_8);
        ActiveMQBuffer bb1 = this.wrapBuffer(bytes1);
        String s2 = "hippopotamus";
        byte[] bytes2 = s2.getBytes(StandardCharsets.UTF_8);
        ActiveMQBuffer bb2 = this.wrapBuffer(bytes2);
        String s3 = "echidna";
        byte[] bytes3 = s3.getBytes(StandardCharsets.UTF_8);
        ActiveMQBuffer bb3 = this.wrapBuffer(bytes3);
        long initialPos = sf.position();
        sf.write(bb1, true);
        long bytesWritten = sf.position() - initialPos;
        Assertions.assertEquals((long)this.calculateRecordSize(bytes1.length, this.factory.getAlignment()), (long)bytesWritten);
        initialPos = sf.position();
        sf.write(bb2, true);
        bytesWritten = sf.position() - initialPos;
        Assertions.assertEquals((long)this.calculateRecordSize(bytes2.length, this.factory.getAlignment()), (long)bytesWritten);
        initialPos = sf.position();
        sf.write(bb3, true);
        bytesWritten = sf.position() - initialPos;
        Assertions.assertEquals((long)this.calculateRecordSize(bytes3.length, this.factory.getAlignment()), (long)bytesWritten);
        sf.position(0L);
        ByteBuffer rb1 = this.factory.newBuffer(bytes1.length);
        ByteBuffer rb2 = this.factory.newBuffer(bytes2.length);
        ByteBuffer rb3 = this.factory.newBuffer(bytes3.length);
        int bytesRead = sf.read(rb1);
        Assertions.assertEquals((int)this.calculateRecordSize(bytes1.length, this.factory.getAlignment()), (int)bytesRead);
        for (i = 0; i < bytes1.length; ++i) {
            Assertions.assertEquals((byte)bytes1[i], (byte)rb1.get(i));
        }
        bytesRead = sf.read(rb2);
        Assertions.assertEquals((int)this.calculateRecordSize(bytes2.length, this.factory.getAlignment()), (int)bytesRead);
        for (i = 0; i < bytes2.length; ++i) {
            Assertions.assertEquals((byte)bytes2[i], (byte)rb2.get(i));
        }
        bytesRead = sf.read(rb3);
        Assertions.assertEquals((int)this.calculateRecordSize(bytes3.length, this.factory.getAlignment()), (int)bytesRead);
        for (i = 0; i < bytes3.length; ++i) {
            Assertions.assertEquals((byte)bytes3[i], (byte)rb3.get(i));
        }
        sf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPosition() throws Exception {
        SequentialFile sf = this.factory.createSequentialFile("position.amq");
        sf.open();
        try {
            sf.fill(1536);
            String s1 = "orange";
            byte[] bytes1 = s1.getBytes(StandardCharsets.UTF_8);
            byte[] bytes2 = s1.getBytes(StandardCharsets.UTF_8);
            String s3 = "lemon";
            byte[] bytes3 = s3.getBytes(StandardCharsets.UTF_8);
            long initialPos = sf.position();
            sf.write(this.wrapBuffer(bytes1), true);
            long bytesWritten = sf.position() - initialPos;
            Assertions.assertEquals((long)this.calculateRecordSize(bytes1.length, this.factory.getAlignment()), (long)bytesWritten);
            initialPos = sf.position();
            sf.write(this.wrapBuffer(bytes2), true);
            bytesWritten = sf.position() - initialPos;
            Assertions.assertEquals((long)this.calculateRecordSize(bytes2.length, this.factory.getAlignment()), (long)bytesWritten);
            initialPos = sf.position();
            sf.write(this.wrapBuffer(bytes3), true);
            bytesWritten = sf.position() - initialPos;
            Assertions.assertEquals((long)this.calculateRecordSize(bytes3.length, this.factory.getAlignment()), (long)bytesWritten);
            byte[] rbytes1 = new byte[bytes1.length];
            byte[] rbytes2 = new byte[bytes2.length];
            byte[] rbytes3 = new byte[bytes3.length];
            ByteBuffer rb1 = this.factory.newBuffer(rbytes1.length);
            ByteBuffer rb2 = this.factory.newBuffer(rbytes2.length);
            ByteBuffer rb3 = this.factory.newBuffer(rbytes3.length);
            sf.position((long)(this.calculateRecordSize(bytes1.length, this.factory.getAlignment()) + this.calculateRecordSize(bytes2.length, this.factory.getAlignment())));
            int bytesRead = sf.read(rb3);
            Assertions.assertEquals((int)rb3.limit(), (int)bytesRead);
            rb3.rewind();
            rb3.get(rbytes3);
            ActiveMQTestBase.assertEqualsByteArrays(bytes3, rbytes3);
            sf.position((long)rb1.limit());
            bytesRead = sf.read(rb2);
            Assertions.assertEquals((int)rb2.limit(), (int)bytesRead);
            rb2.get(rbytes2);
            ActiveMQTestBase.assertEqualsByteArrays(bytes2, rbytes2);
            sf.position(0L);
            bytesRead = sf.read(rb1);
            Assertions.assertEquals((int)rb1.limit(), (int)bytesRead);
            rb1.get(rbytes1);
            ActiveMQTestBase.assertEqualsByteArrays(bytes1, rbytes1);
        }
        finally {
            try {
                sf.close();
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testOpenClose() throws Exception {
        SequentialFile sf = this.factory.createSequentialFile("openclose.amq");
        sf.open();
        sf.fill(512);
        String s1 = "cheesecake";
        byte[] bytes1 = s1.getBytes(StandardCharsets.UTF_8);
        long initialPos = sf.position();
        sf.write(this.wrapBuffer(bytes1), true);
        long bytesWritten = sf.position() - initialPos;
        Assertions.assertEquals((long)this.calculateRecordSize(bytes1.length, this.factory.getAlignment()), (long)bytesWritten);
        sf.close();
        try {
            sf.write(this.wrapBuffer(bytes1), true);
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sf.open();
        sf.write(this.wrapBuffer(bytes1), true);
        sf.close();
    }

    private ActiveMQBuffer wrapBuffer(byte[] bytes) {
        return ActiveMQBuffers.wrappedBuffer((byte[])bytes);
    }

    protected void checkFill(SequentialFileFactory factory, SequentialFile file, int size) throws Exception {
        file.fill(size);
        file.close();
        file.open();
        file.position(0L);
        ByteBuffer bb = factory.newBuffer(size);
        int bytesRead = file.read(bb);
        Assertions.assertEquals((int)this.calculateRecordSize(size, factory.getAlignment()), (int)bytesRead);
        for (int i = 0; i < size; ++i) {
            Assertions.assertEquals((int)0, (int)bb.get(i));
        }
    }
}

