/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.cluster.impl;

import java.util.ArrayList;
import java.util.function.IntFunction;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.cluster.impl.RemoteQueueBindingImpl;
import org.apache.activemq.artemis.tests.unit.core.postoffice.impl.fakes.FakeQueue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoteQueueBindImplTest
extends ActiveMQTestBase {
    private void testAddRemoveConsumerWithFilter(IntFunction<SimpleString> filterFactory, int size, int expectedSize) throws Exception {
        int i;
        long id = RandomUtil.randomLong();
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString uniqueName = RandomUtil.randomSimpleString();
        SimpleString routingName = RandomUtil.randomSimpleString();
        Long remoteQueueID = RandomUtil.randomLong();
        SimpleString filterString = SimpleString.of((String)"A>B");
        FakeQueue storeAndForwardQueue = new FakeQueue(null);
        SimpleString bridgeName = RandomUtil.randomSimpleString();
        boolean distance = false;
        RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(id, address, uniqueName, routingName, remoteQueueID, filterString, (Queue)storeAndForwardQueue, bridgeName, 0, MessageLoadBalancingType.ON_DEMAND);
        ArrayList<SimpleString> filters = new ArrayList<SimpleString>(size);
        for (i = 0; i < size; ++i) {
            SimpleString filter = filterFactory.apply(i);
            filters.add(filter);
            binding.addConsumer(filter);
        }
        Assertions.assertEquals((int)expectedSize, (int)binding.getFilters().size());
        for (i = 0; i < size; ++i) {
            binding.removeConsumer((SimpleString)filters.get(i));
        }
        Assertions.assertEquals((int)0, (int)binding.getFilters().size());
    }

    @Test
    public void testAddRemoveConsumer() throws Exception {
        this.testAddRemoveConsumerWithFilter(i -> SimpleString.of((String)("B" + i + "<A")), 100, 100);
    }

    @Test
    public void testAddRemoveConsumerUsingSameFilter() throws Exception {
        this.testAddRemoveConsumerWithFilter(i -> SimpleString.of((String)"B0<A"), 100, 1);
    }

    @Test
    public void testAddRemoveConsumerUsingEmptyFilters() throws Exception {
        this.testAddRemoveConsumerWithFilter(i -> SimpleString.of((String)""), 1, 0);
    }

    @Test
    public void testAddRemoveConsumerUsingNullFilters() throws Exception {
        this.testAddRemoveConsumerWithFilter(i -> null, 1, 0);
    }

    @Test
    public void testIsHighAcceptPriority() throws Exception {
        long id = RandomUtil.randomLong();
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString uniqueName = RandomUtil.randomSimpleString();
        SimpleString routingName = RandomUtil.randomSimpleString();
        Long remoteQueueID = RandomUtil.randomLong();
        SimpleString filterString = SimpleString.of((String)"A>B");
        FakeQueue storeAndForwardQueue = new FakeQueue(null);
        SimpleString bridgeName = RandomUtil.randomSimpleString();
        boolean distance = false;
        RemoteQueueBindingImpl bindingOff = new RemoteQueueBindingImpl(id, address, uniqueName, routingName, remoteQueueID, filterString, (Queue)storeAndForwardQueue, bridgeName, 0, MessageLoadBalancingType.OFF);
        bindingOff.addConsumer(null);
        Assertions.assertFalse((boolean)bindingOff.isHighAcceptPriority(null));
        RemoteQueueBindingImpl bindingOffWithRedistribution = new RemoteQueueBindingImpl(id, address, uniqueName, routingName, remoteQueueID, filterString, (Queue)storeAndForwardQueue, bridgeName, 0, MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION);
        bindingOffWithRedistribution.addConsumer(null);
        Assertions.assertTrue((boolean)bindingOffWithRedistribution.isHighAcceptPriority(null));
    }
}

