/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;

public final class ReplicatedBackupUtils {
    public static final String PRIMARY_NODE_NAME = "amqPrimary";
    public static final String BACKUP_NODE_NAME = "amqBackup";

    private ReplicatedBackupUtils() {
    }

    public static void configureReplicationPair(Configuration backupConfig, TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, Configuration primaryConfig, TransportConfiguration primaryConnector, TransportConfiguration primaryAcceptor) {
        if (backupAcceptor != null) {
            backupConfig.clearAcceptorConfigurations().addAcceptorConfiguration(backupAcceptor);
        }
        if (primaryAcceptor != null) {
            primaryConfig.clearAcceptorConfigurations().addAcceptorConfiguration(primaryAcceptor);
        }
        backupConfig.addConnectorConfiguration(BACKUP_NODE_NAME, backupConnector).addConnectorConfiguration(PRIMARY_NODE_NAME, primaryConnector).addClusterConfiguration(ActiveMQTestBase.basicClusterConnectionConfig(BACKUP_NODE_NAME, PRIMARY_NODE_NAME)).setHAPolicyConfiguration((HAPolicyConfiguration)new ReplicaPolicyConfiguration());
        primaryConfig.setName(PRIMARY_NODE_NAME).addConnectorConfiguration(PRIMARY_NODE_NAME, primaryConnector).addConnectorConfiguration(BACKUP_NODE_NAME, backupConnector).setSecurityEnabled(false).addClusterConfiguration(ActiveMQTestBase.basicClusterConnectionConfig(PRIMARY_NODE_NAME, BACKUP_NODE_NAME)).setHAPolicyConfiguration((HAPolicyConfiguration)new ReplicatedPolicyConfiguration());
    }

    public static void configurePluggableQuorumReplicationPair(Configuration backupConfig, TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, Configuration primaryConfig, TransportConfiguration primaryConnector, TransportConfiguration primaryAcceptor, DistributedLockManagerConfiguration primaryManagerConfiguration, DistributedLockManagerConfiguration backupManagerConfiguration) {
        if (backupAcceptor != null) {
            backupConfig.clearAcceptorConfigurations().addAcceptorConfiguration(backupAcceptor);
        }
        if (primaryAcceptor != null) {
            primaryConfig.clearAcceptorConfigurations().addAcceptorConfiguration(primaryAcceptor);
        }
        backupConfig.addConnectorConfiguration(BACKUP_NODE_NAME, backupConnector).addConnectorConfiguration(PRIMARY_NODE_NAME, primaryConnector).addClusterConfiguration(ActiveMQTestBase.basicClusterConnectionConfig(BACKUP_NODE_NAME, PRIMARY_NODE_NAME)).setHAPolicyConfiguration((HAPolicyConfiguration)ReplicationBackupPolicyConfiguration.withDefault().setDistributedManagerConfiguration(backupManagerConfiguration));
        primaryConfig.setName(PRIMARY_NODE_NAME).addConnectorConfiguration(PRIMARY_NODE_NAME, primaryConnector).addConnectorConfiguration(BACKUP_NODE_NAME, backupConnector).setSecurityEnabled(false).addClusterConfiguration(ActiveMQTestBase.basicClusterConnectionConfig(PRIMARY_NODE_NAME, BACKUP_NODE_NAME)).setHAPolicyConfiguration((HAPolicyConfiguration)ReplicationPrimaryPolicyConfiguration.withDefault().setDistributedManagerConfiguration(primaryManagerConfiguration));
    }
}

