/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.activemq.transport.netty.NettyTransport;
import org.apache.activemq.transport.netty.NettyTransportFactory;
import org.apache.qpid.proton.amqp.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpClient {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String username;
    private final String password;
    private final URI remoteURI;
    private String authzid;
    private String mechanismRestriction;
    private AmqpValidator stateInspector = new AmqpValidator();
    private List<Symbol> offeredCapabilities = Collections.emptyList();
    private Map<Symbol, Object> offeredProperties = Collections.emptyMap();

    public AmqpClient(URI remoteURI, String username, String password) {
        this.remoteURI = remoteURI;
        this.password = password;
        this.username = username;
    }

    public AmqpConnection connect() throws Exception {
        AmqpConnection connection = this.createConnection();
        logger.debug("Attempting to create new connection to peer: {}", (Object)this.remoteURI);
        connection.connect();
        return connection;
    }

    public AmqpConnection connect(boolean noContainerId) throws Exception {
        AmqpConnection connection = this.createConnection();
        connection.setNoContainerID();
        logger.debug("Attempting to create new connection to peer: {}", (Object)this.remoteURI);
        connection.connect();
        return connection;
    }

    public AmqpConnection connect(String containerId) throws Exception {
        AmqpConnection connection = this.createConnection();
        connection.setContainerId(containerId);
        logger.debug("Attempting to create new connection to peer: {}", (Object)this.remoteURI);
        connection.connect();
        return connection;
    }

    public AmqpConnection createConnection() throws Exception {
        if (this.username == null && this.password != null) {
            throw new IllegalArgumentException("Password must be null if user name value is null");
        }
        NettyTransport transport = NettyTransportFactory.createTransport(this.remoteURI);
        AmqpConnection connection = new AmqpConnection(transport, this.username, this.password);
        connection.setMechanismRestriction(this.mechanismRestriction);
        connection.setAuthzid(this.authzid);
        connection.setOfferedCapabilities(this.getOfferedCapabilities());
        connection.setOfferedProperties(this.getOfferedProperties());
        connection.setStateInspector(this.getStateInspector());
        return connection;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setAuthzid(String authzid) {
        this.authzid = authzid;
    }

    public String getAuthzid() {
        return this.authzid;
    }

    public void setMechanismRestriction(String mechanismRestriction) {
        this.mechanismRestriction = mechanismRestriction;
    }

    public String getMechanismRestriction() {
        return this.mechanismRestriction;
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public void setOfferedCapabilities(List<Symbol> offeredCapabilities) {
        if (offeredCapabilities != null) {
            offeredCapabilities = Collections.emptyList();
        }
        this.offeredCapabilities = offeredCapabilities;
    }

    public List<Symbol> getOfferedCapabilities() {
        return Collections.unmodifiableList(this.offeredCapabilities);
    }

    public void setOfferedProperties(Map<Symbol, Object> offeredProperties) {
        if (offeredProperties != null) {
            offeredProperties = Collections.emptyMap();
        }
        this.offeredProperties = offeredProperties;
    }

    public Map<Symbol, Object> getOfferedProperties() {
        return Collections.unmodifiableMap(this.offeredProperties);
    }

    public AmqpValidator getStateInspector() {
        return this.stateInspector;
    }

    public void setValidator(AmqpValidator stateInspector) {
        if (stateInspector == null) {
            stateInspector = new AmqpValidator();
        }
        this.stateInspector = stateInspector;
    }

    public String toString() {
        return "AmqpClient: " + this.getRemoteURI().getHost() + ":" + this.getRemoteURI().getPort();
    }

    public static AmqpConnection connect(URI broker) throws Exception {
        return AmqpClient.connect(broker, null, null);
    }

    public static AmqpConnection connect(URI broker, String username, String password) throws Exception {
        if (username == null && password != null) {
            throw new IllegalArgumentException("Password must be null if user name value is null");
        }
        AmqpClient client = new AmqpClient(broker, username, password);
        return client.connect();
    }
}

