/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.immutable;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.clustering.server.immutable.Immutability;

class UnmodifiableImmutability
implements Immutability {
    private final Set<Class<?>> unmodifiableCollectionClasses = UnmodifiableImmutability.identitySet(List.of(Collections.singleton(null).getClass(), Collections.singletonList(null).getClass(), Collections.unmodifiableCollection(Collections.emptyList()).getClass(), Collections.unmodifiableList(Collections.emptyList()).getClass(), Collections.unmodifiableNavigableSet(Collections.emptyNavigableSet()).getClass(), Collections.unmodifiableSet(Collections.emptySet()).getClass(), Collections.unmodifiableSortedSet(Collections.emptySortedSet()).getClass(), List.of().getClass(), List.of(Boolean.TRUE).getClass(), Set.of().getClass(), Set.of(Boolean.TRUE).getClass()));
    private final Set<Class<?>> unmodifiableMapClasses = UnmodifiableImmutability.identitySet(List.of(Collections.singletonMap(null, null).getClass(), Collections.unmodifiableMap(Collections.emptyMap()).getClass(), Collections.unmodifiableNavigableMap(Collections.emptyNavigableMap()).getClass(), Collections.unmodifiableSortedMap(Collections.emptySortedMap()).getClass(), Map.of().getClass(), Map.of(Boolean.TRUE, Boolean.TRUE).getClass()));
    private final Set<Class<?>> unmodifiableMapEntryClasses = UnmodifiableImmutability.identitySet(List.of(AbstractMap.SimpleImmutableEntry.class));
    private final Immutability elementImmutability;

    static <T> Set<T> identitySet(Collection<T> collection) {
        Set<T> set = !collection.isEmpty() ? Collections.newSetFromMap(new IdentityHashMap(collection.size())) : Set.of();
        for (T element : collection) {
            set.add(element);
        }
        return set;
    }

    UnmodifiableImmutability(Immutability elementImmutability) {
        this.elementImmutability = elementImmutability;
    }

    @Override
    public boolean test(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> objectClass = object.getClass();
        if (this.unmodifiableCollectionClasses.contains(objectClass)) {
            for (Object element : (Collection)object) {
                if (this.elementImmutability.test(element)) continue;
                return false;
            }
            return true;
        }
        if (this.unmodifiableMapClasses.contains(objectClass)) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (this.test(entry)) continue;
                return false;
            }
            return true;
        }
        if (this.unmodifiableMapEntryClasses.contains(objectClass)) {
            return this.test((Map.Entry)object);
        }
        return false;
    }

    @Override
    private boolean test(Map.Entry<?, ?> entry) {
        return this.elementImmutability.test(entry.getKey()) && this.elementImmutability.test(entry.getValue());
    }
}

