/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public class PropertyValueExpr
implements ValueExpr {
    protected final PropertyPath<?> propertyPath;
    protected final boolean isRepeated;
    protected final Class<?> primitiveType;

    public PropertyValueExpr(PropertyPath<?> propertyPath, boolean isRepeated, Class<?> primitiveType) {
        this.propertyPath = propertyPath;
        this.isRepeated = isRepeated;
        this.primitiveType = primitiveType;
    }

    public PropertyValueExpr(String propertyPath, boolean isRepeated, Class<?> primitiveType) {
        this(PropertyPath.make(propertyPath), isRepeated, primitiveType);
    }

    public PropertyPath<?> getPropertyPath() {
        return this.propertyPath;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    public Class<?> getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyValueExpr other = (PropertyValueExpr)o;
        return this.propertyPath.equals(other.propertyPath);
    }

    public int hashCode() {
        return this.propertyPath.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PROP(").append(this.propertyPath);
        if (this.isRepeated) {
            sb.append('*');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void appendQueryString(StringBuilder sb) {
        sb.append(this.propertyPath);
    }
}

