/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.internal.models.SmallRyeOASModels;
import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.BaseModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.runtime.io.ComponentsIO;
import io.smallrye.openapi.runtime.io.ExternalDocumentationIO;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.OpenAPIDefinitionIO;
import io.smallrye.openapi.runtime.io.OperationIO;
import io.smallrye.openapi.runtime.io.PathItemIO;
import io.smallrye.openapi.runtime.io.PathItemOperationIO;
import io.smallrye.openapi.runtime.io.PathsIO;
import io.smallrye.openapi.runtime.io.callbacks.CallbackIO;
import io.smallrye.openapi.runtime.io.callbacks.CallbackOperationIO;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.headers.HeaderIO;
import io.smallrye.openapi.runtime.io.info.ContactIO;
import io.smallrye.openapi.runtime.io.info.InfoIO;
import io.smallrye.openapi.runtime.io.info.LicenseIO;
import io.smallrye.openapi.runtime.io.links.LinkIO;
import io.smallrye.openapi.runtime.io.links.LinkParameterIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.media.DiscriminatorIO;
import io.smallrye.openapi.runtime.io.media.EncodingIO;
import io.smallrye.openapi.runtime.io.media.ExampleObjectIO;
import io.smallrye.openapi.runtime.io.media.MediaTypeIO;
import io.smallrye.openapi.runtime.io.media.SchemaIO;
import io.smallrye.openapi.runtime.io.parameters.ParameterIO;
import io.smallrye.openapi.runtime.io.parameters.RequestBodyIO;
import io.smallrye.openapi.runtime.io.responses.APIResponseIO;
import io.smallrye.openapi.runtime.io.responses.APIResponsesIO;
import io.smallrye.openapi.runtime.io.security.OAuthFlowIO;
import io.smallrye.openapi.runtime.io.security.OAuthFlowsIO;
import io.smallrye.openapi.runtime.io.security.OAuthScopeIO;
import io.smallrye.openapi.runtime.io.security.SecurityIO;
import io.smallrye.openapi.runtime.io.security.SecurityRequirementIO;
import io.smallrye.openapi.runtime.io.security.SecurityRequirementsSetIO;
import io.smallrye.openapi.runtime.io.security.SecuritySchemeIO;
import io.smallrye.openapi.runtime.io.servers.ServerIO;
import io.smallrye.openapi.runtime.io.servers.ServerVariableIO;
import io.smallrye.openapi.runtime.io.tags.TagIO;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public abstract class ModelIO<T, V, A extends V, O extends V, AB, OB>
implements JsonIO.PropertyMapper<V, OB> {
    private final IOContext<V, A, O, AB, OB> context;
    protected final DotName annotationName;
    protected final DotName modelName;
    private SmallRyeOASModels modelTypes = new SmallRyeOASModels();
    Set<String> REF_PROPERTIES = Set.of("$ref", "summary", "description");

    protected ModelIO(IOContext<V, A, O, AB, OB> context, DotName annotationName, DotName modelName) {
        this.context = context;
        this.annotationName = annotationName;
        this.modelName = modelName;
    }

    public IOContext<V, A, O, AB, OB> ioContext() {
        return this.context;
    }

    public JsonIO<V, A, O, AB, OB> jsonIO() {
        return this.context.jsonIO();
    }

    public AnnotationScannerContext scannerContext() {
        return this.context.scannerContext();
    }

    protected void setIfPresent(OB object, String key, Optional<? extends V> valueSource) {
        valueSource.ifPresent(value -> this.jsonIO().set(object, key, value));
    }

    protected void setAllIfPresent(OB object, Optional<? extends O> valueSource) {
        valueSource.ifPresent(value -> this.jsonIO().setAll(object, value));
    }

    protected Optional<OB> optionalJsonObject(Object source) {
        if (source == null) {
            return Optional.empty();
        }
        return Optional.of(this.jsonIO().createObject());
    }

    protected Optional<AB> optionalJsonArray(Object source) {
        if (source == null) {
            return Optional.empty();
        }
        return Optional.of(this.jsonIO().createArray());
    }

    protected static <T> Map.Entry<String, T> entry(String key, T value) {
        return new AbstractMap.SimpleEntry<String, T>(key, value);
    }

    protected <P> P value(AnnotationInstance annotation, String propertyName) {
        return (P)this.scannerContext().annotations().value(annotation, propertyName);
    }

    protected <P> P value(AnnotationInstance annotation, String propertyName, P defaultValue) {
        return this.scannerContext().annotations().value(annotation, propertyName, defaultValue);
    }

    protected <P extends Enum<P>> P enumValue(AnnotationInstance annotation, String propertyName, Class<P> type) {
        return this.scannerContext().annotations().enumValue(annotation, propertyName, type);
    }

    protected <P extends Enum<P>> P enumValue(V value, Class<P> type) {
        String strValue = this.jsonIO().asString(value);
        if (strValue != null) {
            try {
                return Enum.valueOf(type, strValue.toUpperCase(Locale.ROOT));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Optional<String> getName(AnnotationInstance annotation, String nameProperty) {
        String name = (String)this.value(annotation, nameProperty);
        if (name == null && JandexUtil.isRef(annotation)) {
            name = JandexUtil.nameFromRef(annotation);
        }
        return Optional.ofNullable(name);
    }

    protected Optional<String> getName(AnnotationInstance annotation) {
        return this.getName(annotation, "name");
    }

    protected static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return predicate.negate();
    }

    protected static <T> Collector<Map.Entry<String, T>, ?, Map<String, T>> toLinkedMap() {
        BiConsumer<Map, Map.Entry> accumulator = (map, entry) -> {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (map.containsKey(k)) {
                throw new IllegalStateException(String.format("Duplicate key %s (attempted merging values %s and %s)", k, map.get(k), v));
            }
            map.put(k, v);
        };
        BinaryOperator combiner = (m1, m2) -> {
            m2.entrySet().forEach(entry -> accumulator.accept((Map)m1, (Map.Entry)entry));
            return m1;
        };
        return Collector.of(LinkedHashMap::new, accumulator, combiner, new Collector.Characteristics[0]);
    }

    public AnnotationInstance getAnnotation(AnnotationTarget target) {
        return this.scannerContext().annotations().getAnnotation(target, this.annotationName);
    }

    public List<AnnotationInstance> getRepeatableAnnotations(AnnotationTarget target) {
        return this.scannerContext().annotations().getRepeatableAnnotation(target, this.annotationName, Names.containerOf(this.annotationName));
    }

    public boolean hasRepeatableAnnotation(AnnotationTarget target) {
        return this.scannerContext().annotations().hasAnnotation(target, this.annotationName, Names.containerOf(this.annotationName));
    }

    public T read(AnnotationTarget target) {
        return Optional.ofNullable(this.getAnnotation(target)).map(this::read).orElse(null);
    }

    public T read(AnnotationValue annotation) {
        return Optional.ofNullable(annotation).map(AnnotationValue::asNested).map(this::read).orElse(null);
    }

    public <C extends Constructible> T read(Class<C> type, AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation(annotation.name().toString());
        BaseModel model = (BaseModel)OASFactory.createObject(type);
        for (AnnotationValue annotationValue : annotation.values()) {
            Object value = this.scannerContext().annotations().value(annotation, annotationValue);
            if (value == null || this.setProperty(model, annotationValue)) continue;
            String name = annotationValue.name();
            if ("ref".equals(name) && Reference.class.isAssignableFrom(type)) {
                model.setRef(annotationValue.asString());
                continue;
            }
            if ("extensions".equals(name) && Extensible.class.isAssignableFrom(type)) {
                ((BaseExtensibleModel)model).setExtensions(this.extensionIO().readExtensible(annotation));
                continue;
            }
            model.setProperty(name, value);
        }
        return (T)model;
    }

    protected boolean setProperty(T model, AnnotationValue value) {
        return false;
    }

    public abstract T read(AnnotationInstance var1);

    public <C extends Constructible> T readObject(Class<C> type, O node) {
        JsonIO<V, A, O, AB, OB> jsonIO = this.jsonIO();
        BaseModel model = (BaseModel)OASFactory.createObject(type);
        SmallRyeOASModels.Properties modelType = this.modelTypes.getModel(type);
        for (Map.Entry<String, V> property : jsonIO.properties(node)) {
            String name = property.getKey();
            V value = property.getValue();
            if (value == null || this.setProperty(model, name, value)) continue;
            if ("$ref".equals(name) && Reference.class.isAssignableFrom(type)) {
                model.setRef(jsonIO.asString(value));
                continue;
            }
            if (ExtensionIO.isExtension(name) && Extensible.class.isAssignableFrom(type)) {
                ((BaseExtensibleModel)model).addExtension(name, jsonIO.fromJson(value));
                continue;
            }
            model.setProperty(name, this.readJson(value, modelType.getPropertyType(name)));
        }
        return (T)model;
    }

    protected Object readJson(V node, DataType desiredType) {
        if (this.jsonIO().isObject(node)) {
            if (desiredType.type == DataType.Type.MAP) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                O object = this.jsonIO().asObject(node);
                for (Map.Entry<String, V> entry : this.jsonIO().properties(object)) {
                    result.put(entry.getKey(), this.readJson(entry.getValue(), desiredType.content));
                }
                return result;
            }
            if (desiredType.type == DataType.Type.OBJECT) {
                if (desiredType.clazz == Object.class) {
                    return this.jsonIO().fromJson(node);
                }
                return this.readValue(node, desiredType.clazz);
            }
            IoLogging.logger.invalidJsonType(desiredType.toString(), String.valueOf(node));
            return null;
        }
        if (this.jsonIO().isArray(node)) {
            if (desiredType.type == DataType.Type.LIST) {
                ArrayList<Object> result = new ArrayList<Object>();
                A array = this.jsonIO().asArray(node);
                for (V element : this.jsonIO().entries(array)) {
                    result.add(this.readJson(element, desiredType.content));
                }
                return result;
            }
            if (desiredType.clazz == Object.class) {
                return this.jsonIO().fromJson(node);
            }
            IoLogging.logger.invalidJsonType(desiredType.toString(), String.valueOf(node));
            return null;
        }
        if (desiredType.type == DataType.Type.OBJECT) {
            if (desiredType.clazz == Object.class) {
                return this.jsonIO().fromJson(node);
            }
            return this.readValue(node, desiredType.clazz);
        }
        return this.jsonIO().fromJson(node);
    }

    protected Object readValue(V node, Class<?> desiredType) {
        if (desiredType == Schema.class) {
            return this.schemaIO().readValue(node);
        }
        Object result = this.jsonIO().fromJson(node, desiredType);
        if (result != null) {
            return result;
        }
        if (Enum.class.isAssignableFrom(desiredType) && (result = this.enumValue(node, desiredType.asSubclass(Enum.class))) != null) {
            return result;
        }
        if (Constructible.class.isAssignableFrom(desiredType)) {
            if (this.jsonIO().isObject(node)) {
                return this.readObject(desiredType, node);
            }
            if (this.jsonIO().isNull(node)) {
                return null;
            }
            IoLogging.logger.invalidJsonType(desiredType.getName(), String.valueOf(node));
            return null;
        }
        return this.jsonIO().fromJson(node);
    }

    protected boolean setProperty(T model, String name, V value) {
        return false;
    }

    public T readValue(V node) {
        return Optional.ofNullable(node).filter(this.jsonIO()::isObject).map(this.jsonIO()::asObject).map(this::readObject).orElse(null);
    }

    public T readObject(O node) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass()) + "#readObject(O)");
    }

    public Optional<? extends V> write(T model) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass()) + "#write(T)");
    }

    @Override
    public Optional<V> mapObject(Object object) {
        if (object instanceof Schema) {
            return this.schemaIO().write((Schema)object);
        }
        return Optional.empty();
    }

    @Override
    public Optional<V> mapProperty(Object object, String propertyName, Object propertyValue) {
        if (object instanceof Reference) {
            if (object instanceof PathItem) {
                return Optional.empty();
            }
            String ref = ((Reference)object).getRef();
            if (ref != null && !ref.isBlank() && !this.REF_PROPERTIES.contains(propertyName)) {
                return Optional.of(this.jsonIO().nullValue());
            }
        }
        return Optional.empty();
    }

    @Override
    public void mapObject(Object object, OB nodeBuilder) {
        if (object instanceof RequestBody && ((Reference)object).getRef() == null) {
            Boolean required = ((RequestBody)object).getRequired();
            this.setIfPresent(nodeBuilder, "required", this.jsonIO().toJson(required));
        }
    }

    public IOContext.OpenApiVersion openApiVersion() {
        return this.context.openApiVersion();
    }

    public void setOpenApiVersion(IOContext.OpenApiVersion version) {
        this.context.setOpenApiVersion(version);
    }

    public ComponentsIO<V, A, O, AB, OB> componentsIO() {
        return this.context.componentsIO();
    }

    public ExternalDocumentationIO<V, A, O, AB, OB> extDocIO() {
        return this.context.extDocIO();
    }

    public OpenAPIDefinitionIO<V, A, O, AB, OB> openApiDefinitionIO() {
        return this.context.openApiDefinitionIO();
    }

    public OperationIO<V, A, O, AB, OB> operationIO() {
        return this.context.operationIO();
    }

    public PathItemOperationIO<V, A, O, AB, OB> pathItemOperationIO() {
        return this.context.pathItemOperationIO();
    }

    public PathItemIO<V, A, O, AB, OB> pathItemIO() {
        return this.context.pathItemIO();
    }

    public PathsIO<V, A, O, AB, OB> pathsIO() {
        return this.context.pathsIO();
    }

    public CallbackIO<V, A, O, AB, OB> callbackIO() {
        return this.context.callbackIO();
    }

    public CallbackOperationIO<V, A, O, AB, OB> callbackOperationIO() {
        return this.context.callbackOperationIO();
    }

    public ExtensionIO<V, A, O, AB, OB> extensionIO() {
        return this.context.extensionIO();
    }

    public HeaderIO<V, A, O, AB, OB> headerIO() {
        return this.context.headerIO();
    }

    public ContactIO<V, A, O, AB, OB> contactIO() {
        return this.context.contactIO();
    }

    public InfoIO<V, A, O, AB, OB> infoIO() {
        return this.context.infoIO();
    }

    public LicenseIO<V, A, O, AB, OB> licenseIO() {
        return this.context.licenseIO();
    }

    public LinkIO<V, A, O, AB, OB> linkIO() {
        return this.context.linkIO();
    }

    public LinkParameterIO<V, A, O, AB, OB> linkParameterIO() {
        return this.context.linkParameterIO();
    }

    public ContentIO<V, A, O, AB, OB> contentIO() {
        return this.context.contentIO();
    }

    public DiscriminatorIO<V, A, O, AB, OB> discriminatorIO() {
        return this.context.discriminatorIO();
    }

    public EncodingIO<V, A, O, AB, OB> encodingIO() {
        return this.context.encodingIO();
    }

    public ExampleObjectIO<V, A, O, AB, OB> exampleObjectIO() {
        return this.context.exampleObjectIO();
    }

    public MediaTypeIO<V, A, O, AB, OB> mediaTypeIO() {
        return this.context.mediaTypeIO();
    }

    public SchemaIO<V, A, O, AB, OB> schemaIO() {
        return this.context.schemaIO();
    }

    public ParameterIO<V, A, O, AB, OB> parameterIO() {
        return this.context.parameterIO();
    }

    public RequestBodyIO<V, A, O, AB, OB> requestBodyIO() {
        return this.context.requestBodyIO();
    }

    public APIResponseIO<V, A, O, AB, OB> apiResponseIO() {
        return this.context.apiResponseIO();
    }

    public APIResponsesIO<V, A, O, AB, OB> apiResponsesIO() {
        return this.context.apiResponsesIO();
    }

    public OAuthFlowIO<V, A, O, AB, OB> oauthFlowIO() {
        return this.context.oauthFlowIO();
    }

    public OAuthFlowsIO<V, A, O, AB, OB> oauthFlowsIO() {
        return this.context.oauthFlowsIO();
    }

    public OAuthScopeIO<V, A, O, AB, OB> oauthScopeIO() {
        return this.context.oauthScopeIO();
    }

    public SecurityIO<V, A, O, AB, OB> securityIO() {
        return this.context.securityIO();
    }

    public SecurityRequirementIO<V, A, O, AB, OB> securityRequirementIO() {
        return this.context.securityRequirementIO();
    }

    public SecurityRequirementsSetIO<V, A, O, AB, OB> securityRequirementsSetIO() {
        return this.context.securityRequirementsSetIO();
    }

    public SecuritySchemeIO<V, A, O, AB, OB> securitySchemeIO() {
        return this.context.securitySchemeIO();
    }

    public ServerIO<V, A, O, AB, OB> serverIO() {
        return this.context.serverIO();
    }

    public ServerVariableIO<V, A, O, AB, OB> serverVariableIO() {
        return this.context.serverVariableIO();
    }

    public TagIO<V, A, O, AB, OB> tagIO() {
        return this.context.tagIO();
    }
}

