/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.util.ClassLoaderUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.CustomSchemaRegistry;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.ScannerLogging;
import io.smallrye.openapi.runtime.scanner.ScannerMessages;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

@Deprecated
public class OpenApiAnnotationScanner {
    private final AnnotationScannerContext annotationScannerContext;
    private final Supplier<Iterable<AnnotationScanner>> scannerSupplier;

    public OpenApiAnnotationScanner(OpenApiConfig config, IndexView index) {
        this(config, ClassLoaderUtil.getDefaultClassLoader(), index, Collections.emptyList());
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, IndexView index, List<AnnotationScannerExtension> extensions) {
        this(config, ClassLoaderUtil.getDefaultClassLoader(), index, extensions);
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, IndexView index, List<AnnotationScannerExtension> extensions, boolean addDefaultExtension) {
        this(config, ClassLoaderUtil.getDefaultClassLoader(), index, extensions, addDefaultExtension);
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index) {
        this(config, loader, index, Collections.emptyList());
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index, List<AnnotationScannerExtension> extensions) {
        this(config, loader, index, new AnnotationScannerFactory(loader), extensions);
    }

    private OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index, List<AnnotationScannerExtension> extensions, boolean addDefaultExtension) {
        this(config, loader, index, new AnnotationScannerFactory(loader), extensions, addDefaultExtension);
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index, Supplier<Iterable<AnnotationScanner>> scannerSupplier) {
        this(config, loader, index, scannerSupplier, Collections.emptyList());
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index, Supplier<Iterable<AnnotationScanner>> scannerSupplier, List<AnnotationScannerExtension> extensions) {
        this(config, loader, index, scannerSupplier, extensions, false);
    }

    private OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index, Supplier<Iterable<AnnotationScanner>> scannerSupplier, List<AnnotationScannerExtension> extensions, boolean addDefaultExtension) {
        FilteredIndexView filteredIndexView = index instanceof FilteredIndexView ? (FilteredIndexView)FilteredIndexView.class.cast(index) : new FilteredIndexView(index, config);
        this.annotationScannerContext = new AnnotationScannerContext(filteredIndexView, loader, extensions, addDefaultExtension, config, null, OASFactory.createOpenAPI());
        this.scannerSupplier = scannerSupplier;
    }

    public OpenApiAnnotationScanner(AnnotationScannerContext context, Supplier<Iterable<AnnotationScanner>> scannerSupplier) {
        this.annotationScannerContext = context;
        this.scannerSupplier = scannerSupplier;
    }

    public OpenAPI scan(String ... filter) {
        Set included = Optional.ofNullable(filter).map(f -> Arrays.stream(f).distinct().collect(Collectors.toSet())).orElseGet(Collections::emptySet);
        return this.scan((String name) -> {
            if (included.isEmpty()) return true;
            if (!included.stream().anyMatch(name::equals)) return false;
            return true;
        });
    }

    public OpenAPI scan(Predicate<String> filter) {
        OpenAPI openApi = this.scanMicroProfileOpenApiAnnotations();
        for (AnnotationScanner annotationScanner : this.getScanners(filter)) {
            ScannerLogging.logger.scanning(annotationScanner.getName());
            this.annotationScannerContext.setCurrentScanner(annotationScanner);
            openApi = annotationScanner.scan(this.annotationScannerContext, openApi);
        }
        this.sortTags(this.annotationScannerContext, openApi);
        this.sortMaps(openApi);
        return openApi;
    }

    private Iterable<AnnotationScanner> getScanners(Predicate<String> filter) {
        return StreamSupport.stream(this.scannerSupplier.get().spliterator(), false).filter(scanner -> filter.test(scanner.getName())).collect(Collectors.toList());
    }

    private OpenAPI scanMicroProfileOpenApiAnnotations() {
        OpenAPI openApi = this.annotationScannerContext.getOpenApi();
        openApi.setOpenapi("3.1.0");
        this.getCustomSchemaRegistry(this.annotationScannerContext.getConfig()).registerCustomSchemas(this.annotationScannerContext.getSchemaRegistry());
        ScannerLogging.logger.scanning("OpenAPI");
        this.processPackageOpenAPIDefinitions(this.annotationScannerContext, openApi);
        this.processClassSchemas(this.annotationScannerContext);
        return openApi;
    }

    private OpenAPI processPackageOpenAPIDefinitions(AnnotationScannerContext context, OpenAPI oai) {
        List packageDefs = context.getIndex().getAnnotations(Names.OPENAPI_DEFINITION).stream().filter(this::annotatedClasses).filter(annotation -> annotation.target().asClass().name().withoutPackagePrefix().equals("package-info")).collect(Collectors.toList());
        for (AnnotationInstance packageDef : packageDefs) {
            OpenAPI packageOai = context.io().openApiDefinitionIO().read(packageDef);
            oai = MergeUtil.merge(oai, packageOai);
        }
        return oai;
    }

    private CustomSchemaRegistry getCustomSchemaRegistry(OpenApiConfig config) {
        if (config == null || config.customSchemaRegistryClass() == null) {
            return type -> {};
        }
        try {
            return (CustomSchemaRegistry)Class.forName(config.customSchemaRegistryClass(), true, this.annotationScannerContext.getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw ScannerMessages.msg.failedCreateInstance(config.customSchemaRegistryClass(), ex);
        }
    }

    private void processClassSchemas(AnnotationScannerContext context) {
        context.setCurrentScanner(null);
        context.getIndex().getAnnotations(SchemaConstant.DOTNAME_SCHEMA).stream().filter(this::annotatedClasses).map(annotation -> Type.create((DotName)annotation.target().asClass().name(), (Type.Kind)Type.Kind.CLASS)).sorted(Comparator.comparing(Type::name)).forEach(type -> SchemaFactory.typeToSchema(context, type, null, context.getExtensions()));
    }

    private boolean annotatedClasses(AnnotationInstance annotation) {
        return Objects.equals(annotation.target().kind(), AnnotationTarget.Kind.CLASS);
    }

    private void sortTags(AnnotationScannerContext context, OpenAPI oai) {
        List tags = oai.getTags();
        if (tags != null && !tags.isEmpty() && !this.tagsDefinedByOpenAPIDefinition(context)) {
            oai.setTags(tags.stream().sorted(Comparator.comparing(Tag::getName)).collect(Collectors.toList()));
        }
    }

    private boolean tagsDefinedByOpenAPIDefinition(AnnotationScannerContext context) {
        return context.getIndex().getAnnotations(Names.OPENAPI_DEFINITION).stream().map(definition -> definition.value("tags")).filter(Objects::nonNull).map(AnnotationValue::asNestedArray).anyMatch(definitionTags -> ((AnnotationInstance[])definitionTags).length > 0);
    }

    private void sortMaps(OpenAPI oai) {
        this.sort(oai.getPaths(), Paths::getPathItems, Paths::setPathItems);
        Components components = oai.getComponents();
        this.sort(components, Components::getCallbacks, Components::setCallbacks);
        this.sort(components, Components::getExamples, Components::setExamples);
        this.sort(components, Components::getHeaders, Components::setHeaders);
        this.sort(components, Components::getLinks, Components::setLinks);
        this.sort(components, Components::getParameters, Components::setParameters);
        this.sort(components, Components::getRequestBodies, Components::setRequestBodies);
        this.sort(components, Components::getResponses, Components::setResponses);
        this.sort(components, Components::getSchemas, Components::setSchemas);
        this.sort(components, Components::getSecuritySchemes, Components::setSecuritySchemes);
    }

    private <P, V> void sort(P parent, Function<P, Map<String, V>> source, BiConsumer<P, Map<String, V>> target) {
        if (parent == null) {
            return;
        }
        Map<String, V> unsorted = source.apply(parent);
        if (unsorted == null || unsorted.isEmpty()) {
            return;
        }
        Map sorted = unsorted.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        target.accept(parent, sorted);
    }
}

