/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.jgroups.spi;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.network.SocketBindingManager;
import org.jgroups.Message;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkStackConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;

public interface ForkChannelFactory
extends ChannelFactory {
    public ForkStackConfiguration getForkStackConfiguration();

    @Override
    default public ProtocolStackConfiguration getProtocolStackConfiguration() {
        ForkStackConfiguration configuration = this.getForkStackConfiguration();
        final ProtocolStackConfiguration parentStack = configuration.getChannelFactory().getProtocolStackConfiguration();
        final List protocols = Stream.concat(parentStack.getProtocols().stream(), configuration.getProtocols().stream()).collect(Collectors.toList());
        return new ProtocolStackConfiguration(){

            @Override
            public boolean isStatisticsEnabled() {
                return parentStack.isStatisticsEnabled();
            }

            @Override
            public TransportConfiguration<? extends TP> getTransport() {
                return parentStack.getTransport();
            }

            @Override
            public List<ProtocolConfiguration<? extends Protocol>> getProtocols() {
                return protocols;
            }

            @Override
            public String getMemberName() {
                return parentStack.getMemberName();
            }

            @Override
            public Optional<RelayConfiguration> getRelay() {
                return parentStack.getRelay();
            }

            @Override
            public SocketBindingManager getSocketBindingManager() {
                return parentStack.getSocketBindingManager();
            }
        };
    }

    @Override
    default public boolean isUnknownForkResponse(Message response) {
        return this.getForkStackConfiguration().getChannelFactory().isUnknownForkResponse(response);
    }
}

