/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.Arrays;
import org.apache.activemq.artemis.core.server.ActiveMQQueueLogger;
import org.slf4j.Logger;

public class ActiveMQQueueLogger_impl
implements ActiveMQQueueLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQQueueLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void warnPageFlowControl(String address, String queue, long messageCount, long messageBytes, long maxMessages, long maxMessagesBytes) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224127: Message dispatch from paging is blocked. Address {}/Queue {} will not read any more messages from paging until pending messages are acknowledged. There are currently {} messages pending ({} bytes) with max reads at maxPageReadMessages({}) and maxPageReadBytes({}). Either increase reading attributes at the address-settings or change your consumers to acknowledge more often.", new Object[]{address, queue, messageCount, messageBytes, maxMessages, maxMessagesBytes});
        }
    }
}

