/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.wildfly.clustering.marshalling.protostream.AbstractProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamSizeOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamSizeOperation;

public class SizeComputingProtoStreamWriter
extends AbstractProtoStreamWriter
implements Supplier<OptionalInt>,
Function<Object, OptionalInt> {
    private final TagWriterImpl writer;
    private final AbstractProtoStreamWriter.ProtoStreamWriterContext context;
    private boolean present = true;

    SizeComputingProtoStreamWriter(ProtoStreamSizeOperation operation, AbstractProtoStreamWriter.ProtoStreamWriterContext context) {
        this(TagWriterImpl.newInstance((ImmutableSerializationContext)operation.getSerializationContext()), context);
    }

    private SizeComputingProtoStreamWriter(TagWriterImpl writer, AbstractProtoStreamWriter.ProtoStreamWriterContext writerContext) {
        super((ProtobufTagMarshaller.WriteContext)writer, writerContext);
        this.writer = writer;
        this.context = writerContext;
    }

    @Override
    public ProtoStreamOperation.Context getContext() {
        return this.context;
    }

    @Override
    public OptionalInt get() {
        return this.present ? OptionalInt.of(this.writer.getWrittenBytes()) : OptionalInt.empty();
    }

    @Override
    public void writeObjectNoTag(Object value) throws IOException {
        OptionalInt size = this.context.computeSize(value, this);
        if (this.present && size.isPresent()) {
            int length = size.getAsInt();
            this.writeVarint32(length);
            if (length > 0) {
                this.writeRawBytes(null, 0, length);
            }
        } else {
            this.present = false;
        }
    }

    @Override
    public OptionalInt apply(Object value) {
        ProtoStreamMarshaller marshaller = this.findMarshaller(value.getClass());
        return marshaller.size(new DefaultProtoStreamSizeOperation(this.getSerializationContext(), this.context), value);
    }
}

