/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.opentelemetry.OpenTelemetryConfigurationConstants;
import org.wildfly.extension.opentelemetry.OpenTelemetryDependencyProcessor;
import org.wildfly.extension.opentelemetry.OpenTelemetryDeploymentProcessor;
import org.wildfly.extension.opentelemetry.OpenTelemetryExtensionLogger;
import org.wildfly.extension.opentelemetry.api.WildFlyOpenTelemetryConfig;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

class OpenTelemetrySubsystemRegistrar
implements SubsystemResourceDefinitionRegistrar,
ResourceServiceConfigurator {
    static final RuntimeCapability<Void> OPENTELEMETRY_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.opentelemetry").addRequirements(new String[]{"org.wildfly.weld"}).build();
    public static final RuntimeCapability<Void> OPENTELEMETRY_CONFIG_CAPABILITY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)WildFlyOpenTelemetryConfig.SERVICE_DESCRIPTOR).build();
    public static final SimpleAttributeDefinition SERVICE_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"service-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition EXPORTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"exporter-type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setAttributeGroup("exporter")).setXmlName("type")).setDefaultValue(new ModelNode("otlp"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(OpenTelemetryConfigurationConstants.ALLOWED_EXPORTERS))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ENDPOINT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"endpoint", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setAttributeGroup("exporter")).setRestartAllServices()).setDefaultValue(new ModelNode("http://localhost:4317"))).build();
    @Deprecated
    public static final SimpleAttributeDefinition SPAN_PROCESSOR_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"span-processor-type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("type")).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode("batch"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(OpenTelemetryConfigurationConstants.ALLOWED_SPAN_PROCESSORS))).build();
    public static final SimpleAttributeDefinition BATCH_DELAY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"batch-delay", (ModelType)ModelType.LONG, (boolean)true).setAllowExpression(true)).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode(5000))).build();
    public static final SimpleAttributeDefinition MAX_QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-queue-size", (ModelType)ModelType.LONG, (boolean)true).setAllowExpression(true)).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode(2048))).build();
    public static final SimpleAttributeDefinition MAX_EXPORT_BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-export-batch-size", (ModelType)ModelType.LONG, (boolean)true).setAllowExpression(true)).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode(512))).build();
    public static final SimpleAttributeDefinition EXPORT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"export-timeout", (ModelType)ModelType.LONG, (boolean)true).setAllowExpression(true)).setAttributeGroup("span-processor")).setRestartAllServices()).setDefaultValue(new ModelNode(30000))).build();
    public static final SimpleAttributeDefinition SAMPLER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"sampler-type", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setXmlName("type")).setAttributeGroup("sampler")).setValidator((ParameterValidator)new StringAllowedValuesValidator(OpenTelemetryConfigurationConstants.ALLOWED_SAMPLERS))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RATIO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ratio", (ModelType)ModelType.DOUBLE, (boolean)true).setAllowExpression(true)).setAttributeGroup("sampler")).setValidator((parameterName, value) -> {
        double val;
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION && ((val = value.asDouble()) < 0.0 || val > 1.0)) {
            throw new OperationFailedException((Throwable)OpenTelemetryExtensionLogger.OTEL_LOGGER.invalidRatio());
        }
    })).setRestartAllServices()).build();
    public static final List<AttributeDefinition> ATTRIBUTES = List.of(SERVICE_NAME, EXPORTER, ENDPOINT, SPAN_PROCESSOR_TYPE, BATCH_DELAY, MAX_QUEUE_SIZE, MAX_EXPORT_BATCH_SIZE, EXPORT_TIMEOUT, SAMPLER, RATIO);
    private final AtomicReference<WildFlyOpenTelemetryConfig> openTelemetryConfig = new AtomicReference();

    OpenTelemetrySubsystemRegistrar() {
    }

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)ResourceRegistration.of((PathElement)OpenTelemetryConfigurationConstants.SUBSYSTEM_PATH), (ResourceDescriptionResolver)OpenTelemetryConfigurationConstants.SUBSYSTEM_RESOLVER).build());
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)OpenTelemetryConfigurationConstants.SUBSYSTEM_RESOLVER).addCapability(OPENTELEMETRY_CAPABILITY)).addCapability(OPENTELEMETRY_CONFIG_CAPABILITY)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).addAttributes(ATTRIBUTES)).withAddOperationRestartFlag(OperationEntry.Flag.RESTART_ALL_SERVICES)).withRemoveOperationRestartFlag(OperationEntry.Flag.RESTART_ALL_SERVICES)).withDeploymentChainContributor(target -> {
            target.addDeploymentProcessor("opentelemetry", Phase.DEPENDENCIES, 6341, (DeploymentUnitProcessor)new OpenTelemetryDependencyProcessor());
            target.addDeploymentProcessor("opentelemetry", Phase.POST_MODULE, 14352, (DeploymentUnitProcessor)new OpenTelemetryDeploymentProcessor(this.openTelemetryConfig::get));
        })).build();
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String exporter = EXPORTER.resolveModelAttribute(context, model).asString();
        this.validateExporter(context, exporter);
        WildFlyOpenTelemetryConfig config = new WildFlyOpenTelemetryConfig(SERVICE_NAME.resolveModelAttribute(context, model).asStringOrNull(), exporter, ENDPOINT.resolveModelAttribute(context, model).asStringOrNull(), BATCH_DELAY.resolveModelAttribute(context, model).asLongOrNull(), MAX_QUEUE_SIZE.resolveModelAttribute(context, model).asLongOrNull(), MAX_EXPORT_BATCH_SIZE.resolveModelAttribute(context, model).asLongOrNull(), EXPORT_TIMEOUT.resolveModelAttribute(context, model).asLongOrNull(), SPAN_PROCESSOR_TYPE.resolveModelAttribute(context, model).asStringOrNull(), SAMPLER.resolveModelAttribute(context, model).asStringOrNull(), RATIO.resolveModelAttribute(context, model).asDoubleOrNull(), context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.microprofile.telemetry"));
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(OPENTELEMETRY_CONFIG_CAPABILITY, (Object)config).withCaptor(this.openTelemetryConfig::set)).build();
    }

    private void validateExporter(OperationContext context, String exporter) throws OperationFailedException {
        if ("jaeger".equals(exporter)) {
            if (context.isNormalServer()) {
                context.setRollbackOnly();
                throw new OperationFailedException(OpenTelemetryExtensionLogger.OTEL_LOGGER.jaegerIsNoLongerSupported());
            }
            OpenTelemetryExtensionLogger.OTEL_LOGGER.warn(OpenTelemetryExtensionLogger.OTEL_LOGGER.jaegerIsNoLongerSupported());
        }
    }

    static {
        if (System.getProperty("vertx.disableDnsResolver") == null) {
            System.setProperty("vertx.disableDnsResolver", "true");
        }
    }
}

