/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.Cache;
import org.wildfly.clustering.cache.CacheEntryCreator;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.cache.function.Functions;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheEntryMutatorFactory;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupKey;
import org.wildfly.clustering.marshalling.MarshalledValue;

public class InfinispanBeanGroupManager<K, V extends BeanInstance<K>, C>
implements CacheEntryCreator<K, MarshalledValue<Map<K, V>, C>, MarshalledValue<Map<K, V>, C>>,
CacheEntryRemover<K>,
CacheEntryMutatorFactory<K, MarshalledValue<Map<K, V>, C>> {
    private final Cache<BeanGroupKey<K>, MarshalledValue<Map<K, V>, C>> cache;
    private final Cache<BeanGroupKey<K>, MarshalledValue<Map<K, V>, C>> removeCache;
    private final CacheEntryMutatorFactory<BeanGroupKey<K>, MarshalledValue<Map<K, V>, C>> mutatorFactory;

    public InfinispanBeanGroupManager(EmbeddedCacheConfiguration configuration) {
        this.cache = configuration.getCache();
        this.removeCache = configuration.getWriteOnlyCache();
        this.mutatorFactory = new EmbeddedCacheEntryMutatorFactory(configuration.getCache());
    }

    public CompletionStage<MarshalledValue<Map<K, V>, C>> createValueAsync(K id, MarshalledValue<Map<K, V>, C> defaultValue) {
        return this.cache.putIfAbsentAsync(new InfinispanBeanGroupKey<K>(id), defaultValue).thenApply((Function)Functions.whenNullFunction(defaultValue));
    }

    public CompletionStage<Void> removeAsync(K id) {
        return this.removeCache.removeAsync(new InfinispanBeanGroupKey<K>(id)).thenAccept(org.wildfly.common.function.Functions.discardingConsumer());
    }

    public CacheEntryMutator createMutator(K id, MarshalledValue<Map<K, V>, C> value) {
        return this.mutatorFactory.createMutator(new InfinispanBeanGroupKey<K>(id), value);
    }
}

