/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.sshd.client.config.hosts.KnownHostDigest;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.transport.sshd.JGitUserInteraction;
import org.eclipse.jgit.internal.transport.sshd.KnownHostEntryReader;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSshServerKeyDatabase
implements ServerKeyDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSshServerKeyDatabase.class);
    private static final String MARKER_REVOKED = "revoked";
    private final boolean askAboutNewFile;
    private final Map<Path, HostKeyFile> knownHostsFiles = new ConcurrentHashMap<Path, HostKeyFile>();
    private final List<HostKeyFile> defaultFiles = new ArrayList<HostKeyFile>();
    private Random prng;

    public OpenSshServerKeyDatabase(boolean askAboutNewFile, List<Path> defaultFiles) {
        if (defaultFiles != null) {
            for (Path file : defaultFiles) {
                HostKeyFile newFile = new HostKeyFile(file);
                this.knownHostsFiles.put(file, newFile);
                this.defaultFiles.add(newFile);
            }
        }
        this.askAboutNewFile = askAboutNewFile;
    }

    private List<HostKeyFile> getFilesToUse(@NonNull ServerKeyDatabase.Configuration config) {
        List<HostKeyFile> filesToUse = this.defaultFiles;
        List<HostKeyFile> userFiles = this.addUserHostKeyFiles(config.getUserKnownHostsFiles());
        if (!userFiles.isEmpty()) {
            filesToUse = userFiles;
        }
        return filesToUse;
    }

    @Override
    public List<PublicKey> lookup(@NonNull String connectAddress, @NonNull InetSocketAddress remoteAddress, @NonNull ServerKeyDatabase.Configuration config) {
        List<HostKeyFile> filesToUse = this.getFilesToUse(config);
        ArrayList<PublicKey> result = new ArrayList<PublicKey>();
        Collection<SshdSocketAddress> candidates = this.getCandidates(connectAddress, remoteAddress);
        for (HostKeyFile file : filesToUse) {
            Iterator iterator = file.get().iterator();
            block1: while (iterator.hasNext()) {
                KnownHostsServerKeyVerifier.HostEntryPair current = (KnownHostsServerKeyVerifier.HostEntryPair)iterator.next();
                KnownHostEntry entry = current.getHostEntry();
                if (this.isRevoked(entry)) continue;
                for (SshdSocketAddress host : candidates) {
                    if (!entry.isHostMatch(host.getHostName(), host.getPort())) continue;
                    result.add(current.getServerKey());
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public boolean accept(@NonNull String connectAddress, @NonNull InetSocketAddress remoteAddress, @NonNull PublicKey serverKey, @NonNull ServerKeyDatabase.Configuration config, CredentialsProvider provider) {
        List<HostKeyFile> filesToUse = this.getFilesToUse(config);
        AskUser ask = new AskUser(config, provider);
        KnownHostsServerKeyVerifier.HostEntryPair[] modified = new KnownHostsServerKeyVerifier.HostEntryPair[1];
        Path path = null;
        Collection<SshdSocketAddress> candidates = this.getCandidates(connectAddress, remoteAddress);
        for (HostKeyFile file : filesToUse) {
            try {
                if (this.find(candidates, serverKey, (List<KnownHostsServerKeyVerifier.HostEntryPair>)file.get(), modified)) {
                    return true;
                }
            }
            catch (RevokedKeyException e) {
                ask.revokedKey(remoteAddress, serverKey, file.getPath());
                return false;
            }
            if (path != null || modified[0] == null) continue;
            path = file.getPath();
        }
        if (modified[0] != null) {
            AskUser.ModifiedKeyHandling toDo = ask.acceptModifiedServerKey(remoteAddress, modified[0].getServerKey(), serverKey, path);
            if (toDo == AskUser.ModifiedKeyHandling.ALLOW_AND_STORE) {
                try {
                    this.updateModifiedServerKey(serverKey, modified[0], path);
                    this.knownHostsFiles.get(path).resetReloadAttributes();
                }
                catch (IOException e) {
                    LOG.warn(MessageFormat.format(SshdText.get().knownHostsCouldNotUpdate, path));
                }
            }
            return toDo != AskUser.ModifiedKeyHandling.DENY;
        }
        if (ask.acceptUnknownKey(remoteAddress, serverKey)) {
            if (!filesToUse.isEmpty()) {
                HostKeyFile toUpdate = filesToUse.get(0);
                path = toUpdate.getPath();
                try {
                    if (Files.exists(path, new LinkOption[0]) || !this.askAboutNewFile || ask.createNewFile(path)) {
                        this.updateKnownHostsFile(candidates, serverKey, path, config);
                        toUpdate.resetReloadAttributes();
                    }
                }
                catch (Exception e) {
                    LOG.warn(MessageFormat.format(SshdText.get().knownHostsCouldNotUpdate, path), (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isRevoked(KnownHostEntry entry) {
        return MARKER_REVOKED.equals(entry.getMarker());
    }

    private boolean find(Collection<SshdSocketAddress> candidates, PublicKey serverKey, List<KnownHostsServerKeyVerifier.HostEntryPair> entries, KnownHostsServerKeyVerifier.HostEntryPair[] modified) throws RevokedKeyException {
        block0: for (KnownHostsServerKeyVerifier.HostEntryPair current : entries) {
            KnownHostEntry entry = current.getHostEntry();
            for (SshdSocketAddress host : candidates) {
                if (!entry.isHostMatch(host.getHostName(), host.getPort())) continue;
                boolean revoked = this.isRevoked(entry);
                if (KeyUtils.compareKeys((PublicKey)serverKey, (PublicKey)current.getServerKey())) {
                    if (revoked) {
                        throw new RevokedKeyException();
                    }
                    modified[0] = null;
                    return true;
                }
                if (revoked) continue block0;
                modified[0] = current;
                continue block0;
            }
        }
        return false;
    }

    private List<HostKeyFile> addUserHostKeyFiles(List<String> fileNames) {
        if (fileNames == null || fileNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HostKeyFile> userFiles = new ArrayList<HostKeyFile>();
        for (String name : fileNames) {
            try {
                Path path = Paths.get(name, new String[0]);
                HostKeyFile file = this.knownHostsFiles.computeIfAbsent(path, p -> new HostKeyFile(path));
                userFiles.add(file);
            }
            catch (InvalidPathException e) {
                LOG.warn(MessageFormat.format(SshdText.get().knownHostsInvalidPath, name));
            }
        }
        return userFiles;
    }

    private void updateKnownHostsFile(Collection<SshdSocketAddress> candidates, PublicKey serverKey, Path path, ServerKeyDatabase.Configuration config) throws Exception {
        String newEntry = this.createHostKeyLine(candidates, serverKey, config);
        if (newEntry == null) {
            return;
        }
        LockFile lock = new LockFile(path.toFile());
        if (lock.lockForAppend()) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(lock.getOutputStream(), StandardCharsets.UTF_8));){
                    writer.newLine();
                    writer.write(newEntry);
                    writer.newLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                lock.commit();
            }
            catch (IOException e) {
                lock.unlock();
                throw e;
            }
        }
        LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileLockedUpdate, path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateModifiedServerKey(PublicKey serverKey, KnownHostsServerKeyVerifier.HostEntryPair entry, Path path) throws IOException {
        KnownHostEntry hostEntry = entry.getHostEntry();
        String oldLine = hostEntry.getConfigLine();
        if (oldLine == null) {
            return;
        }
        String newLine = this.updateHostKeyLine(oldLine, serverKey);
        if (newLine == null) return;
        if (newLine.isEmpty()) {
            return;
        }
        if (oldLine.isEmpty()) return;
        if (newLine.equals(oldLine)) {
            return;
        }
        LockFile lock = new LockFile(path.toFile());
        if (!lock.lock()) {
            LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileLockedUpdate, path));
            return;
        }
        try {
            block22: {
                Throwable throwable = null;
                Object var9_11 = null;
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(lock.getOutputStream(), StandardCharsets.UTF_8));
                    try {
                        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                            String line;
                            boolean done = false;
                            while ((line = reader.readLine()) != null) {
                                String toWrite = line;
                                if (!done) {
                                    String toTest;
                                    int pos = line.indexOf(35);
                                    String string = toTest = pos < 0 ? line : line.substring(0, pos);
                                    if (toTest.trim().equals(oldLine)) {
                                        toWrite = newLine;
                                        done = true;
                                    }
                                }
                                writer.write(toWrite);
                                writer.newLine();
                            }
                        }
                        if (writer == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (writer == null) throw throwable;
                        writer.close();
                        throw throwable;
                    }
                    writer.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            lock.commit();
            return;
        }
        catch (IOException e) {
            lock.unlock();
            throw e;
        }
    }

    private int parsePort(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private SshdSocketAddress toSshdSocketAddress(@NonNull String address) {
        String host = null;
        int port = 0;
        if ('[' == address.charAt(0)) {
            int end = address.indexOf(93);
            if (end <= 1) {
                return null;
            }
            host = address.substring(1, end);
            if (end < address.length() - 1 && ':' == address.charAt(end + 1)) {
                port = this.parsePort(address.substring(end + 2));
            }
        } else {
            int i = address.lastIndexOf(58);
            if (i > 0) {
                port = this.parsePort(address.substring(i + 1));
                host = address.substring(0, i);
            } else {
                host = address;
            }
        }
        if (port < 0 || port > 65535) {
            return null;
        }
        return new SshdSocketAddress(host, port);
    }

    private Collection<SshdSocketAddress> getCandidates(@NonNull String connectAddress, @NonNull InetSocketAddress remoteAddress) {
        TreeSet<SshdSocketAddress> candidates = new TreeSet<SshdSocketAddress>(SshdSocketAddress.BY_HOST_AND_PORT);
        candidates.add(SshdSocketAddress.toSshdSocketAddress((SocketAddress)remoteAddress));
        SshdSocketAddress address = this.toSshdSocketAddress(connectAddress);
        if (address != null) {
            candidates.add(address);
        }
        return candidates;
    }

    private String createHostKeyLine(Collection<SshdSocketAddress> patterns, PublicKey key, ServerKeyDatabase.Configuration config) throws Exception {
        StringBuilder result = new StringBuilder();
        if (config.getHashKnownHosts()) {
            KnownHostDigest digester = KnownHostDigest.SHA1;
            Mac mac = (Mac)digester.create();
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            byte[] salt = new byte[mac.getDefaultBlockSize()];
            for (SshdSocketAddress address : patterns) {
                if (result.length() > 0) {
                    result.append(',');
                }
                this.prng.nextBytes(salt);
                KnownHostHashValue.append((Appendable)result, (NamedResource)digester, (byte[])salt, (byte[])KnownHostHashValue.calculateHashValue((String)address.getHostName(), (int)address.getPort(), (Mac)mac, (byte[])salt));
            }
        } else {
            for (SshdSocketAddress address : patterns) {
                if (result.length() > 0) {
                    result.append(',');
                }
                KnownHostHashValue.appendHostPattern((Appendable)result, (String)address.getHostName(), (int)address.getPort());
            }
        }
        result.append(' ');
        PublicKeyEntry.appendPublicKeyEntry((Appendable)result, (PublicKey)key);
        return result.toString();
    }

    private String updateHostKeyLine(String line, PublicKey newKey) throws IOException {
        int pos = line.indexOf(32);
        if (pos > 0 && line.charAt(0) == '@') {
            pos = line.indexOf(32, pos + 1);
        }
        if (pos < 0) {
            return null;
        }
        StringBuilder result = new StringBuilder(line.substring(0, pos + 1));
        PublicKeyEntry.appendPublicKeyEntry((Appendable)result, (PublicKey)newKey);
        return result.toString();
    }

    private static class AskUser {
        @NonNull
        private final ServerKeyDatabase.Configuration config;
        private final CredentialsProvider provider;

        public AskUser(@NonNull ServerKeyDatabase.Configuration config, CredentialsProvider provider) {
            this.config = config;
            this.provider = provider;
        }

        private static boolean askUser(CredentialsProvider provider, URIish uri, String prompt, String ... messages) {
            ArrayList<Object> items = new ArrayList<Object>(messages.length + 1);
            String[] stringArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                String message = stringArray[n2];
                items.add(new CredentialItem.InformationalMessage(message));
                ++n2;
            }
            if (prompt != null) {
                CredentialItem.YesNoType answer = new CredentialItem.YesNoType(prompt);
                items.add(answer);
                return provider.get(uri, items) && answer.getValue();
            }
            return provider.get(uri, items);
        }

        private Check checkMode(SocketAddress remoteAddress, boolean changed) {
            if (!(remoteAddress instanceof InetSocketAddress)) {
                return Check.DENY;
            }
            switch (this.config.getStrictHostKeyChecking()) {
                case REQUIRE_MATCH: {
                    return Check.DENY;
                }
                case ACCEPT_ANY: {
                    return Check.ALLOW;
                }
                case ACCEPT_NEW: {
                    return changed ? Check.DENY : Check.ALLOW;
                }
            }
            return this.provider == null ? Check.DENY : Check.ASK;
        }

        public void revokedKey(SocketAddress remoteAddress, PublicKey serverKey, Path path) {
            if (this.provider == null) {
                return;
            }
            InetSocketAddress remote = (InetSocketAddress)remoteAddress;
            URIish uri = JGitUserInteraction.toURI(this.config.getUsername(), remote);
            String sha256 = KeyUtils.getFingerPrint((Factory)BuiltinDigests.sha256, (PublicKey)serverKey);
            String md5 = KeyUtils.getFingerPrint((Factory)BuiltinDigests.md5, (PublicKey)serverKey);
            String keyAlgorithm = serverKey.getAlgorithm();
            AskUser.askUser(this.provider, uri, null, MessageFormat.format(SshdText.get().knownHostsRevokedKeyMsg, remote.getHostString(), path), MessageFormat.format(SshdText.get().knownHostsKeyFingerprints, keyAlgorithm), md5, sha256);
        }

        public boolean acceptUnknownKey(SocketAddress remoteAddress, PublicKey serverKey) {
            Check check = this.checkMode(remoteAddress, false);
            if (check != Check.ASK) {
                return check == Check.ALLOW;
            }
            InetSocketAddress remote = (InetSocketAddress)remoteAddress;
            String sha256 = KeyUtils.getFingerPrint((Factory)BuiltinDigests.sha256, (PublicKey)serverKey);
            String md5 = KeyUtils.getFingerPrint((Factory)BuiltinDigests.md5, (PublicKey)serverKey);
            String keyAlgorithm = serverKey.getAlgorithm();
            String remoteHost = remote.getHostString();
            URIish uri = JGitUserInteraction.toURI(this.config.getUsername(), remote);
            String prompt = SshdText.get().knownHostsUnknownKeyPrompt;
            return AskUser.askUser(this.provider, uri, prompt, MessageFormat.format(SshdText.get().knownHostsUnknownKeyMsg, remoteHost), MessageFormat.format(SshdText.get().knownHostsKeyFingerprints, keyAlgorithm), md5, sha256);
        }

        public ModifiedKeyHandling acceptModifiedServerKey(InetSocketAddress remoteAddress, PublicKey expected, PublicKey actual, Path path) {
            Check check = this.checkMode(remoteAddress, true);
            if (check == Check.ALLOW) {
                return ModifiedKeyHandling.ALLOW;
            }
            String keyAlgorithm = actual.getAlgorithm();
            String remoteHost = remoteAddress.getHostString();
            URIish uri = JGitUserInteraction.toURI(this.config.getUsername(), remoteAddress);
            ArrayList<String> messages = new ArrayList<String>();
            String warning = MessageFormat.format(SshdText.get().knownHostsModifiedKeyWarning, keyAlgorithm, expected.getAlgorithm(), remoteHost, KeyUtils.getFingerPrint((Factory)BuiltinDigests.md5, (PublicKey)expected), KeyUtils.getFingerPrint((Factory)BuiltinDigests.sha256, (PublicKey)expected), KeyUtils.getFingerPrint((Factory)BuiltinDigests.md5, (PublicKey)actual), KeyUtils.getFingerPrint((Factory)BuiltinDigests.sha256, (PublicKey)actual));
            messages.addAll(Arrays.asList(warning.split("\n")));
            if (check == Check.DENY) {
                if (this.provider != null) {
                    messages.add(MessageFormat.format(SshdText.get().knownHostsModifiedKeyDenyMsg, path));
                    AskUser.askUser(this.provider, uri, null, messages.toArray(new String[0]));
                }
                return ModifiedKeyHandling.DENY;
            }
            ArrayList<Object> items = new ArrayList<Object>(messages.size() + 2);
            for (String message : messages) {
                items.add(new CredentialItem.InformationalMessage(message));
            }
            CredentialItem.YesNoType proceed = new CredentialItem.YesNoType(SshdText.get().knownHostsModifiedKeyAcceptPrompt);
            CredentialItem.YesNoType store = new CredentialItem.YesNoType(SshdText.get().knownHostsModifiedKeyStorePrompt);
            items.add(proceed);
            items.add(store);
            if (this.provider.get(uri, items) && proceed.getValue()) {
                return store.getValue() ? ModifiedKeyHandling.ALLOW_AND_STORE : ModifiedKeyHandling.ALLOW;
            }
            return ModifiedKeyHandling.DENY;
        }

        public boolean createNewFile(Path path) {
            if (this.provider == null) {
                return false;
            }
            URIish uri = new URIish().setPath(path.toString());
            return AskUser.askUser(this.provider, uri, MessageFormat.format(SshdText.get().knownHostsUserAskCreationPrompt, path), MessageFormat.format(SshdText.get().knownHostsUserAskCreationMsg, path));
        }

        private static enum Check {
            ASK,
            DENY,
            ALLOW;

        }

        public static enum ModifiedKeyHandling {
            DENY,
            ALLOW,
            ALLOW_AND_STORE;

        }
    }

    private static class HostKeyFile
    extends ModifiableFileWatcher
    implements Supplier<List<KnownHostsServerKeyVerifier.HostEntryPair>> {
        private List<KnownHostsServerKeyVerifier.HostEntryPair> entries = Collections.emptyList();

        public HostKeyFile(Path path) {
            super(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<KnownHostsServerKeyVerifier.HostEntryPair> get() {
            Path path = this.getPath();
            HostKeyFile hostKeyFile = this;
            synchronized (hostKeyFile) {
                try {
                    if (this.checkReloadRequired()) {
                        this.entries = this.reload(this.getPath());
                    }
                }
                catch (IOException e) {
                    LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileReadFailed, path));
                }
                return Collections.unmodifiableList(this.entries);
            }
        }

        private List<KnownHostsServerKeyVerifier.HostEntryPair> reload(Path path) throws IOException {
            try {
                List<KnownHostEntry> rawEntries = KnownHostEntryReader.readFromFile(path);
                this.updateReloadAttributes();
                if (rawEntries == null || rawEntries.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<KnownHostsServerKeyVerifier.HostEntryPair> newEntries = new ArrayList<KnownHostsServerKeyVerifier.HostEntryPair>();
                for (KnownHostEntry entry : rawEntries) {
                    AuthorizedKeyEntry keyPart = entry.getKeyEntry();
                    if (keyPart == null) continue;
                    try {
                        PublicKey serverKey = keyPart.resolvePublicKey(null, PublicKeyEntryResolver.IGNORING);
                        if (serverKey == null) {
                            LOG.warn(MessageFormat.format(SshdText.get().knownHostsUnknownKeyType, path, entry.getConfigLine()));
                            continue;
                        }
                        newEntries.add(new KnownHostsServerKeyVerifier.HostEntryPair(entry, serverKey));
                    }
                    catch (GeneralSecurityException e) {
                        LOG.warn(MessageFormat.format(SshdText.get().knownHostsInvalidLine, path, entry.getConfigLine()));
                    }
                }
                return newEntries;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                this.resetReloadAttributes();
                return Collections.emptyList();
            }
        }
    }

    private static class RevokedKeyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private RevokedKeyException() {
        }
    }
}

