/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationGenericConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationAddressPolicyManager
extends FederationAddressPolicyManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final AMQPFederation federation;
    protected final String remoteQueueFilter;
    protected volatile AMQPFederationConsumerConfiguration configuration;
    protected volatile AMQPSessionContext session;

    public AMQPFederationAddressPolicyManager(AMQPFederation federation, FederationReceiveFromAddressPolicy addressPolicy) throws ActiveMQException {
        super(federation, addressPolicy);
        this.federation = federation;
        this.remoteQueueFilter = AMQPFederationPolicySupport.generateAddressFilter(this.policy.getMaxHops());
    }

    @Override
    protected void handlePolicyManagerStarted(FederationReceiveFromAddressPolicy policy) {
        this.configuration = new AMQPFederationConsumerConfiguration(this.federation.getConfiguration(), policy.getProperties());
        this.session = this.federation.getSessionContext();
    }

    @Override
    protected FederationGenericConsumerInfo createConsumerInfo(AddressInfo address) {
        String addressName = address.getName().toString();
        String generatedQueueName = this.generateQueueName(address);
        return new FederationGenericConsumerInfo(FederationConsumerInfo.Role.ADDRESS_CONSUMER, addressName, generatedQueueName, address.getRoutingType(), this.remoteQueueFilter, CompositeAddress.toFullyQualified((String)addressName, (String)generatedQueueName), ActiveMQDefaultConfiguration.getDefaultConsumerPriority());
    }

    protected String generateQueueName(AddressInfo address) {
        return "federation." + this.federation.getName() + ".address." + address.getName() + ".node." + this.server.getNodeID();
    }

    @Override
    protected FederationConsumerInternal createFederationConsumer(FederationConsumerInfo consumerInfo) {
        Objects.requireNonNull(consumerInfo, "Federation Address consumer information object was null");
        if (logger.isTraceEnabled()) {
            logger.trace("AMQP Federation {} creating address consumer: {} for policy: {}", new Object[]{this.federation.getName(), consumerInfo, this.policy.getPolicyName()});
        }
        return new AMQPFederationAddressConsumer(this.federation, this.configuration, this.session, consumerInfo, this.policy);
    }

    @Override
    protected boolean testIfAddressMatchesPolicy(AddressInfo addressInfo) {
        if (!this.policy.test(addressInfo)) {
            return false;
        }
        if (this.configuration.getReceiverCredits() <= 0) {
            logger.debug("Federation address policy rejecting match on {} because credit is set to zero:", (Object)addressInfo.getName());
            return false;
        }
        return true;
    }

    @Override
    protected void signalBeforeCreateFederationConsumer(FederationConsumerInfo info) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).beforeCreateFederationConsumer(info);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("beforeCreateFederationConsumer", (Throwable)t);
        }
    }

    @Override
    protected void signalAfterCreateFederationConsumer(FederationConsumer consumer) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).afterCreateFederationConsumer(consumer);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("afterCreateFederationConsumer", (Throwable)t);
        }
    }

    @Override
    protected void signalBeforeCloseFederationConsumer(FederationConsumer consumer) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).beforeCloseFederationConsumer(consumer);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("beforeCloseFederationConsumer", (Throwable)t);
        }
    }

    @Override
    protected void signalAfterCloseFederationConsumer(FederationConsumer consumer) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).afterCloseFederationConsumer(consumer);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("afterCloseFederationConsumer", (Throwable)t);
        }
    }

    @Override
    protected final boolean isPluginBlockingFederationConsumerCreate(AddressInfo address) {
        AtomicBoolean canCreate = new AtomicBoolean(true);
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin && canCreate.get()) {
                    canCreate.set(((ActiveMQServerAMQPFederationPlugin)plugin).shouldCreateFederationConsumerForAddress(address));
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("shouldCreateFederationConsumerForAddress", (Throwable)t);
        }
        return !canCreate.get();
    }

    @Override
    protected final boolean isPluginBlockingFederationConsumerCreate(Divert divert, Queue queue) {
        AtomicBoolean canCreate = new AtomicBoolean(true);
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin && canCreate.get()) {
                    canCreate.set(((ActiveMQServerAMQPFederationPlugin)plugin).shouldCreateFederationConsumerForDivert(divert, queue));
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("shouldCreateFederationConsumerForDivert", (Throwable)t);
        }
        return !canCreate.get();
    }

    @Override
    protected final boolean isPluginBlockingFederationConsumerCreate(Queue queue) {
        AtomicBoolean canCreate = new AtomicBoolean(true);
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin && canCreate.get()) {
                    canCreate.set(((ActiveMQServerAMQPFederationPlugin)plugin).shouldCreateFederationConsumerForQueue(queue));
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("shouldCreateFederationConsumerForQueue", (Throwable)t);
        }
        return !canCreate.get();
    }
}

