/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.TreeMap;
import java.util.function.Consumer;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceTransformer;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceTransformer;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceTransformer;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceTransformer;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceTransformer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class CacheContainerResourceTransformer
implements Consumer<ModelVersion> {
    private final ResourceTransformationDescriptionBuilder builder;

    CacheContainerResourceTransformer(ResourceTransformationDescriptionBuilder parent) {
        this.builder = parent.addChildResource(CacheContainerResourceDefinition.WILDCARD_PATH);
    }

    @Override
    public void accept(ModelVersion version) {
        final TreeMap<String, String> legacyModules = new TreeMap<String, String>();
        if (InfinispanSubsystemModel.VERSION_18_0_0.requiresTransformation(version)) {
            legacyModules.put("org.wildfly.clustering.session.infinispan.embedded", "org.wildfly.clustering.web.infinispan");
        }
        if (InfinispanSubsystemModel.VERSION_16_0_0.requiresTransformation(version)) {
            String legacyServerModule = "org.wildfly.clustering.server";
            legacyModules.put("org.wildfly.clustering.server.infinispan", legacyServerModule);
            legacyModules.put("org.wildfly.clustering.singleton.server", legacyServerModule);
        }
        if (InfinispanSubsystemModel.VERSION_15_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{CacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition()})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleAcceptAttributeChecker(CacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition().getDefaultValue()), new AttributeDefinition[]{CacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition()})).end();
        }
        if (!legacyModules.isEmpty()) {
            ((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

                protected void convertAttribute(PathAddress address, String name, ModelNode modules, TransformationContext context) {
                    if (modules.isDefined()) {
                        for (ModelNode module : modules.asList()) {
                            String legacyModule = (String)legacyModules.get(module.asString());
                            if (legacyModule == null) continue;
                            module.set(legacyModule);
                        }
                    }
                }
            }, new AttributeDefinition[]{CacheContainerResourceDefinition.ListAttribute.MODULES.getDefinition()})).end();
        }
        new ScatteredCacheResourceTransformer(this.builder).accept(version);
        new DistributedCacheResourceTransformer(this.builder).accept(version);
        new ReplicatedCacheResourceTransformer(this.builder).accept(version);
        new InvalidationCacheResourceTransformer(this.builder).accept(version);
        new LocalCacheResourceTransformer(this.builder).accept(version);
    }
}

