/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.federation.Federation;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreLargeMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpJmsSelectorFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpNoLocalFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerReceiverContext;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationAddressConsumer
implements FederationConsumerInternal {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final SimpleString MESSAGE_HOPS_ANNOTATION = SimpleString.of((String)AMQPFederationPolicySupport.MESSAGE_HOPS_ANNOTATION.toString());
    private static final Symbol[] DEFAULT_OUTCOMES = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
    private final AMQPFederation federation;
    private final AMQPFederationConsumerConfiguration configuration;
    private final FederationConsumerInfo consumerInfo;
    private final FederationReceiveFromAddressPolicy policy;
    private final AMQPConnectionContext connection;
    private final AMQPSessionContext session;
    private final Predicate<Link> remoteCloseInterceptor = this::remoteLinkClosedInterceptor;
    private final Transformer transformer;
    private AMQPFederatedAddressDeliveryReceiver receiver;
    private Receiver protonReceiver;
    private boolean started;
    private volatile boolean closed;
    private Consumer<FederationConsumerInternal> remoteCloseHandler;

    public AMQPFederationAddressConsumer(AMQPFederation federation, AMQPFederationConsumerConfiguration configuration, AMQPSessionContext session, FederationConsumerInfo consumerInfo, FederationReceiveFromAddressPolicy policy) {
        this.federation = federation;
        this.consumerInfo = consumerInfo;
        this.policy = policy;
        this.connection = session.getAMQPConnectionContext();
        this.session = session;
        this.configuration = configuration;
        TransformerConfiguration transformerConfiguration = policy.getTransformerConfiguration();
        this.transformer = transformerConfiguration != null ? federation.getServer().getServiceRegistry().getFederationTransformer(policy.getPolicyName(), transformerConfiguration) : m -> m;
    }

    @Override
    public Federation getFederation() {
        return this.federation;
    }

    @Override
    public FederationConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public FederationReceiveFromAddressPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public synchronized void start() {
        if (!this.started && !this.closed) {
            this.started = true;
            this.asyncCreateReceiver();
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.started) {
                this.started = false;
                this.connection.runLater(() -> {
                    this.federation.removeLinkClosedInterceptor(this.consumerInfo.getId());
                    if (this.receiver != null) {
                        try {
                            this.receiver.close(false);
                        }
                        catch (ActiveMQAMQPException activeMQAMQPException) {
                        }
                        finally {
                            this.receiver = null;
                        }
                    }
                    if (this.protonReceiver != null) {
                        try {
                            this.protonReceiver.close();
                        }
                        finally {
                            this.protonReceiver = null;
                        }
                    }
                    this.connection.flush();
                });
            }
        }
    }

    @Override
    public synchronized AMQPFederationAddressConsumer setRemoteClosedHandler(Consumer<FederationConsumerInternal> handler) {
        if (this.started) {
            throw new IllegalStateException("Cannot set a remote close handler after the consumer is started");
        }
        this.remoteCloseHandler = handler;
        return this;
    }

    protected boolean remoteLinkClosedInterceptor(Link link) {
        if (link == this.protonReceiver && link.getRemoteCondition() != null && link.getRemoteCondition().getCondition() != null) {
            Symbol errorCondition = link.getRemoteCondition().getCondition();
            if (AmqpSupport.RESOURCE_DELETED.equals(errorCondition)) {
                return true;
            }
            if (AmqpSupport.NOT_FOUND.equals(errorCondition)) {
                return true;
            }
            if (AmqpSupport.DETACH_FORCED.equals(errorCondition)) {
                return true;
            }
        }
        return false;
    }

    private void signalBeforeFederationConsumerMessageHandled(Message message) throws ActiveMQException {
        try {
            this.federation.getServer().callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).beforeFederationConsumerMessageHandled(this, message);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("beforeFederationConsumerMessageHandled", (Throwable)t);
        }
    }

    private void signalAfterFederationConsumerMessageHandled(Message message) throws ActiveMQException {
        try {
            this.federation.getServer().callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).afterFederationConsumerMessageHandled(this, message);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("afterFederationConsumerMessageHandled", (Throwable)t);
        }
    }

    private String generateLinkName() {
        return "federation-" + this.federation.getName() + "-address-receiver-" + this.consumerInfo.getAddress() + "-" + this.federation.getServer().getNodeID();
    }

    private void asyncCreateReceiver() {
        this.connection.runLater(() -> {
            if (this.closed) {
                return;
            }
            try {
                Receiver protonReceiver = this.session.getSession().receiver(this.generateLinkName());
                Target target = new Target();
                Source source = new Source();
                String address = this.consumerInfo.getAddress();
                if (RoutingType.ANYCAST.equals((Object)this.consumerInfo.getRoutingType())) {
                    source.setCapabilities(new Symbol[]{AmqpSupport.QUEUE_CAPABILITY});
                } else {
                    source.setCapabilities(new Symbol[]{AmqpSupport.TOPIC_CAPABILITY});
                }
                HashMap<Symbol, Object> filtersMap = new HashMap<Symbol, Object>();
                filtersMap.put(AmqpSupport.NO_LOCAL_NAME, AmqpNoLocalFilter.NO_LOCAL);
                if (this.consumerInfo.getFilterString() != null && !this.consumerInfo.getFilterString().isEmpty()) {
                    AmqpJmsSelectorFilter jmsFilter = new AmqpJmsSelectorFilter(this.consumerInfo.getFilterString());
                    filtersMap.put(AmqpSupport.JMS_SELECTOR_KEY, jmsFilter);
                }
                source.setOutcomes(Arrays.copyOf(DEFAULT_OUTCOMES, DEFAULT_OUTCOMES.length));
                source.setDurable(TerminusDurability.NONE);
                source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
                source.setAddress(address);
                source.setFilter(filtersMap);
                target.setAddress(address);
                HashMap<String, Comparable<Boolean>> addressSourceProperties = new HashMap<String, Comparable<Boolean>>();
                addressSourceProperties.put("auto-delete", Boolean.valueOf(this.policy.isAutoDelete()));
                addressSourceProperties.put("auto-delete-delay", Long.valueOf(this.policy.getAutoDeleteDelay()));
                addressSourceProperties.put("auto-delete-msg-count", Long.valueOf(this.policy.getAutoDeleteMessageCount()));
                HashMap<Symbol, HashMap<String, Comparable<Boolean>>> receiverProperties = new HashMap<Symbol, HashMap<String, Comparable<Boolean>>>();
                receiverProperties.put(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES, addressSourceProperties);
                protonReceiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                protonReceiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                protonReceiver.setDesiredCapabilities(new Symbol[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER});
                if (this.configuration.isCoreMessageTunnelingEnabled()) {
                    protonReceiver.setOfferedCapabilities(new Symbol[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT});
                }
                protonReceiver.setProperties(receiverProperties);
                protonReceiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                protonReceiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                protonReceiver.open();
                AtomicBoolean openTimedOut = new AtomicBoolean(false);
                ScheduledFuture<?> openTimeoutTask = this.configuration.getLinkAttachTimeout() > 0 ? this.federation.getServer().getScheduledPool().schedule(() -> {
                    openTimedOut.set(true);
                    this.federation.signalResourceCreateError((Exception)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionTimeout()));
                }, (long)this.configuration.getLinkAttachTimeout(), TimeUnit.SECONDS) : null;
                this.protonReceiver = protonReceiver;
                protonReceiver.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, () -> {
                    try {
                        if (openTimeoutTask != null) {
                            openTimeoutTask.cancel(false);
                        }
                        if (openTimedOut.get()) {
                            return;
                        }
                        if (protonReceiver.getRemoteSource() != null && !AmqpSupport.verifyOfferedCapabilities((Link)protonReceiver, AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER)) {
                            this.federation.signalResourceCreateError((Exception)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.missingOfferedCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString())));
                            return;
                        }
                        this.federation.addLinkClosedInterceptor(this.consumerInfo.getId(), this.remoteCloseInterceptor);
                        this.receiver = new AMQPFederatedAddressDeliveryReceiver(this.session, this.consumerInfo, protonReceiver);
                        if (protonReceiver.getRemoteSource() != null) {
                            logger.debug("AMQP Federation {} address consumer {} completed open", (Object)this.federation.getName(), (Object)this.consumerInfo);
                        } else {
                            logger.debug("AMQP Federation {} address consumer {} rejected by remote", (Object)this.federation.getName(), (Object)this.consumerInfo);
                        }
                        this.session.addReceiver(protonReceiver, (session, protonRcvr) -> this.receiver);
                    }
                    catch (Exception e) {
                        this.federation.signalError(e);
                    }
                });
            }
            catch (Exception e) {
                this.federation.signalError(e);
            }
            this.connection.flush();
        });
    }

    private static AMQPMessage incrementAMQPMessageHops(AMQPMessage message) {
        Object hops = message.getAnnotation(MESSAGE_HOPS_ANNOTATION);
        if (hops == null) {
            message.setAnnotation(MESSAGE_HOPS_ANNOTATION, 1);
        } else {
            Number numHops = (Number)hops;
            message.setAnnotation(MESSAGE_HOPS_ANNOTATION, numHops.intValue() + 1);
        }
        message.reencode();
        return message;
    }

    private static ICoreMessage incrementCoreMessageHops(ICoreMessage message) {
        Object hops = message.getObjectProperty("_AMQ_Fed_Hops");
        if (hops == null) {
            message.putObjectProperty("_AMQ_Fed_Hops", (Object)1);
        } else {
            Number numHops = (Number)hops;
            message.putObjectProperty("_AMQ_Fed_Hops", (Object)(numHops.intValue() + 1));
        }
        return message;
    }

    private class AMQPFederatedAddressDeliveryReceiver
    extends ProtonServerReceiverContext {
        private final SimpleString cachedAddress;
        private MessageReader coreMessageReader;
        private MessageReader coreLargeMessageReader;

        AMQPFederatedAddressDeliveryReceiver(AMQPSessionContext session, FederationConsumerInfo consumerInfo, Receiver receiver) {
            super(session.getSessionSPI(), session.getAMQPConnectionContext(), session, receiver);
            this.cachedAddress = SimpleString.of((String)consumerInfo.getAddress());
        }

        @Override
        public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
            super.close(remoteLinkClose);
            if (remoteLinkClose && AMQPFederationAddressConsumer.this.remoteCloseHandler != null) {
                try {
                    AMQPFederationAddressConsumer.this.remoteCloseHandler.accept(AMQPFederationAddressConsumer.this);
                }
                catch (Exception e) {
                    logger.debug("User remote closed handler threw error: ", (Throwable)e);
                }
                finally {
                    AMQPFederationAddressConsumer.this.remoteCloseHandler = null;
                }
            }
        }

        @Override
        protected Runnable createCreditRunnable(AMQPConnectionContext connection) {
            return AMQPFederatedAddressDeliveryReceiver.createCreditRunnable(AMQPFederationAddressConsumer.this.configuration.getReceiverCredits(), AMQPFederationAddressConsumer.this.configuration.getReceiverCreditsLow(), this.receiver, connection, this);
        }

        @Override
        protected int getConfiguredMinLargeMessageSize(AMQPConnectionContext connection) {
            return AMQPFederationAddressConsumer.this.configuration.getLargeMessageThreshold();
        }

        @Override
        public void initialize() throws Exception {
            this.initialized = true;
            Target target = (Target)this.receiver.getRemoteTarget();
            this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
            this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            if (target == null || target.getAddress() == null || target.getAddress().isEmpty()) {
                throw new ActiveMQAMQPInternalErrorException("Remote should have sent an valid Target but we got: " + target);
            }
            this.address = SimpleString.of((String)target.getAddress());
            this.defRoutingType = this.getRoutingType(target.getCapabilities(), this.address);
            try {
                AddressQueryResult result = this.sessionSPI.addressQuery(this.address, this.defRoutingType, false);
                if (!result.isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist(this.address.toString());
                }
            }
            catch (ActiveMQAMQPNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
            }
            this.flow();
        }

        @Override
        protected MessageReader trySelectMessageReader(Receiver receiver, Delivery delivery) {
            if (delivery.getMessageFormat() == 1183580416) {
                return this.coreMessageReader != null ? this.coreMessageReader : (this.coreMessageReader = new AMQPTunneledCoreMessageReader(this));
            }
            if (delivery.getMessageFormat() == 1183580672) {
                return this.coreLargeMessageReader != null ? this.coreLargeMessageReader : (this.coreLargeMessageReader = new AMQPTunneledCoreLargeMessageReader(this));
            }
            return super.trySelectMessageReader(receiver, delivery);
        }

        @Override
        protected void actualDelivery(Message message, Delivery delivery, DeliveryAnnotations deliveryAnnotations, Receiver receiver, Transaction tx) {
            try {
                Object baseMessage;
                if (logger.isTraceEnabled()) {
                    logger.trace("AMQP Federation {} address consumer {} dispatching incoming message: {}", new Object[]{AMQPFederationAddressConsumer.this.federation.getName(), AMQPFederationAddressConsumer.this.consumerInfo, message});
                }
                if (message instanceof ICoreMessage) {
                    baseMessage = AMQPFederationAddressConsumer.incrementCoreMessageHops((ICoreMessage)message);
                    baseMessage.putStringProperty("__AMQ_CID", this.getConnection().getRemoteContainer());
                } else {
                    baseMessage = AMQPFederationAddressConsumer.incrementAMQPMessageHops((AMQPMessage)message);
                }
                Message theMessage = AMQPFederationAddressConsumer.this.transformer.transform((Message)baseMessage);
                if (theMessage != baseMessage && logger.isTraceEnabled()) {
                    logger.trace("The transformer {} replaced the original message {} with a new instance {}", new Object[]{AMQPFederationAddressConsumer.this.transformer, baseMessage, theMessage});
                }
                AMQPFederationAddressConsumer.this.signalBeforeFederationConsumerMessageHandled(theMessage);
                this.sessionSPI.serverSend(this, tx, receiver, delivery, this.cachedAddress, this.routingContext, theMessage);
                AMQPFederationAddressConsumer.this.signalAfterFederationConsumerMessageHandled(theMessage);
            }
            catch (Exception e) {
                logger.warn("Inbound delivery for {} encountered an error: {}", new Object[]{AMQPFederationAddressConsumer.this.consumerInfo, e.getMessage(), e});
                this.deliveryFailed(delivery, receiver, e);
            }
        }
    }
}

