/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.Federation;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.LinkError;
import org.apache.qpid.protonj2.test.driver.ProtonTestClient;
import org.apache.qpid.protonj2.test.driver.ProtonTestPeer;
import org.apache.qpid.protonj2.test.driver.ProtonTestServer;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.ApplicationPropertiesMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.HeaderMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.MessageAnnotationsMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.PropertiesMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.TransferPayloadCompositeMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedAmqpValueMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jgroups.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationQueuePolicyTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final WildcardConfiguration DEFAULT_WILDCARD_CONFIGURATION = new WildcardConfiguration();

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesQueueReceiverLinkForQueueMatchAnycast() throws Exception {
        this.doTestFederationCreatesQueueReceiverLinkForQueueMatch(RoutingType.ANYCAST);
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesQueueReceiverLinkForQueueMatchMulticast() throws Exception {
        this.doTestFederationCreatesQueueReceiverLinkForQueueMatch(RoutingType.MULTICAST);
    }

    private void doTestFederationCreatesQueueReceiverLinkForQueueMatch(RoutingType routingType) throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSenderSettleModeSettled().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(routingType).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                if (RoutingType.MULTICAST.equals((Object)routingType)) {
                    session.createConsumer((Destination)session.createTopic("test::test"));
                } else {
                    session.createConsumer((Destination)session.createQueue("test"));
                }
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationQueueReceiverCarriesConfiguredQueueFilter() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setFilterString("color='red'").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSource().withJMSSelector("color='red'").and().respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationQueueReceiverCarriesConsumerQueueFilter() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setFilterString("color='red' OR color = 'blue'").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSource().withJMSSelector("color='red'").and().respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                jakarta.jms.Queue queue = session.createQueue("test");
                session.createConsumer((Destination)queue, "color='red'");
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSource().withJMSSelector("color='blue'").and().respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
                peer.expectFlow().withLinkCredit(1000);
                session.createConsumer((Destination)queue, "color='blue'");
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSource().withJMSSelector("color='red' OR color = 'blue'").and().respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
                peer.expectFlow().withLinkCredit(1000);
                session.createConsumer((Destination)queue);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                session.createConsumer((Destination)queue, "color='blue'");
                session.createConsumer((Destination)queue, "color='red'");
                session.createConsumer((Destination)queue);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationQueueReceiverCanIgnoreConsumerQueueFilter() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            receiveFromQueue.addProperty("ignoreQueueConsumerFilters", "true");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setFilterString("color='red' OR color = 'blue'").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSource().withJMSSelector("color='red' OR color = 'blue'").and().respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                jakarta.jms.Queue queue = session.createQueue("test");
                session.createConsumer((Destination)queue, "color='red'");
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                session.createConsumer((Destination)queue, "color='blue'");
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesQueueReceiverLinkForQueueMatchUsingPolicyCredit() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            receiveFromQueue.addProperty("amqpCredits", "30");
            receiveFromQueue.addProperty("amqpLowCredits", "3");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSource().and().withTarget().and().respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(30);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationClosesQueueReceiverWhenDemandIsRemovedFromQueue() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000).optional();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationHandlesQueueDeletedAndConsumerRecreates() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            Session session;
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000).optional();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                this.server.destroyQueue(SimpleString.of((String)"test"), null, false, true);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000).optional();
            connection = factory.createConnection();
            try {
                session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                peer.expectDetach().respond();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testSecondQueueConsumerDoesNotGenerateAdditionalFederationReceiver() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000).optional();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test"));
                session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testLinkCreatedForEachDistinctQueueMatchInSameConfiguredPolicy() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("addr1", "test.1");
            receiveFromQueue.addToIncludes("addr2", "test.2");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test.1").setRoutingType(RoutingType.ANYCAST).setAddress("addr1").setAutoCreated(Boolean.valueOf(false)));
            this.server.createQueue(QueueConfiguration.of((String)"test.2").setRoutingType(RoutingType.ANYCAST).setAddress("addr2").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"addr1::test.1"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000).optional();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test.1"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"addr2::test.2"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
                peer.expectFlow().withLinkCredit(1000).optional();
                session.createConsumer((Destination)session.createQueue("test.2"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                peer.expectDetach().respond();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationReceiverCreatedWhenWildcardPolicyMatchesConsumerQueue() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("", "test.#");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test.queue").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test.queue"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteCloseOfQueueReceiverRespondsToDetach() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("", "test.#");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test.queue").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test.queue"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
                peer.remoteDetach().withErrorCondition("amqp:resource-deleted", "the resource was deleted").afterDelay(10).now();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRejectedQueueReceiverAttachWhenLocalMatchingQueueNotFoundIsHandled() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("", "test.#");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test.queue").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind().withNullSource();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteDetach().withErrorCondition("amqp:not-found", "the requested queue was not found").queue().afterDelay(10);
            peer.expectDetach();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test.queue"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test.queue"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
                peer.expectFlow().withLinkCredit(1000);
                session.createConsumer((Destination)session.createQueue("test.queue"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteCloseQueueReceiverWhenRemoteResourceIsDeletedIsHandled() throws Exception {
        this.doTestRemoteCloseQueueReceiverForExpectedConditionsIsHandled("amqp:resource-deleted");
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteCloseQueueReceiverWhenRemoteReceiverIsForcedToDetachIsHandled() throws Exception {
        this.doTestRemoteCloseQueueReceiverForExpectedConditionsIsHandled("amqp:link:detach-forced");
    }

    private void doTestRemoteCloseQueueReceiverForExpectedConditionsIsHandled(String condition) throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("", "test.#");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test.queue").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test.queue"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteDetach().withErrorCondition(condition, "error message from remote....").queue().afterDelay(20);
            peer.expectDetach();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test.queue"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test.queue"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
                peer.expectFlow().withLinkCredit(1000);
                session.createConsumer((Destination)session.createQueue("test.queue"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testUnhandledRemoteReceiverCloseConditionCausesConnectionRebuild() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("", "test.#");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(1);
            amqpConnection.setRetryInterval(100);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test.queue").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test.queue"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test.queue"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().optional();
                peer.expectClose().optional();
                peer.expectConnectionToDrop();
                peer.expectSASLAnonymousConnect();
                peer.expectOpen().respond();
                peer.expectBegin().respond();
                peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
                peer.expectFlow().withLinkCredit(10);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test.queue"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
                peer.expectFlow().withLinkCredit(1000);
                peer.remoteDetach().withErrorCondition("amqp:internal-error", "the resource suffered an internal error").afterDelay(15).now();
                peer.waitForScriptToComplete(50L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testInboundMessageRoutedToReceiverOnLocalQueue() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("", "test.#");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test.queue").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test.queue"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withSource().withAddress("test::test.queue").and().respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(0).queue();
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("test.queue"));
                connection.start();
                Message message = consumer.receive(200000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesQueueReceiverLinkWithDefaultPrioirty() throws Exception {
        this.doTestFederationCreatesQueueReceiverLinkWithAdjustedPriority(0);
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesQueueReceiverLinkWithIncreasedPriority() throws Exception {
        this.doTestFederationCreatesQueueReceiverLinkWithAdjustedPriority(5);
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesQueueReceiverLinkWithDecreasedPriority() throws Exception {
        this.doTestFederationCreatesQueueReceiverLinkWithAdjustedPriority(-5);
    }

    private void doTestFederationCreatesQueueReceiverLinkWithAdjustedPriority(int adjustment) throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.setPriorityAdjustment(Integer.valueOf(adjustment));
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)(ActiveMQDefaultConfiguration.getDefaultConsumerPriority() + adjustment)).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesQueueReceiverLinkConsumerPriorityOffset() throws Exception {
        this.doTestFederationCreatesQueueReceiverWithCorrectPriorityOffset(false);
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesQueueReceiverLinkIngoringConsumerPriorityOffset() throws Exception {
        this.doTestFederationCreatesQueueReceiverWithCorrectPriorityOffset(true);
    }

    private void doTestFederationCreatesQueueReceiverWithCorrectPriorityOffset(boolean ignoreConsumerPriority) throws Exception {
        int TEST_BASE_PRIORITY_ADJUSTMENT = -2;
        int TEST_CONSUMER_PRIORITY = 2;
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.setPriorityAdjustment(Integer.valueOf(-2));
            receiveFromQueue.addToIncludes("test", "test");
            if (ignoreConsumerPriority) {
                receiveFromQueue.addProperty("ignoreQueueConsumerPriorities", Boolean.valueOf(ignoreConsumerPriority).toString());
            }
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            int expectedPriority = ignoreConsumerPriority ? ActiveMQDefaultConfiguration.getDefaultConsumerPriority() + -2 : 0;
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)expectedPriority).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test?consumer-priority=2"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testLinkCreatedForEachDistinctQueueMatchInSameConfiguredPolicyWithSameAddressMatch() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("addr", "test.1");
            receiveFromQueue.addToIncludes("addr", "test.2");
            receiveFromQueue.addToIncludes("addr", "test.3");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test.1").setRoutingType(RoutingType.ANYCAST).setAddress("addr").setAutoCreated(Boolean.valueOf(false)));
            this.server.createQueue(QueueConfiguration.of((String)"test.2").setRoutingType(RoutingType.ANYCAST).setAddress("addr").setAutoCreated(Boolean.valueOf(false)));
            this.server.createQueue(QueueConfiguration.of((String)"test.3").setRoutingType(RoutingType.ANYCAST).setAddress("addr").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"addr::test.1"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000).optional();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test.1"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"addr::test.2"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
                peer.expectFlow().withLinkCredit(1000).optional();
                session.createConsumer((Destination)session.createQueue("test.2"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"addr::test.3"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
                peer.expectFlow().withLinkCredit(1000).optional();
                session.createConsumer((Destination)session.createQueue("test.3"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                peer.expectDetach().respond();
                peer.expectDetach().respond();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerAcceptsQueuePolicyFromControlLink() throws Exception {
        this.server.start();
        ArrayList<AbstractMap.SimpleEntry<String, String>> includes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        includes.add(new AbstractMap.SimpleEntry<String, String>("#", "testQueue"));
        ArrayList<AbstractMap.SimpleEntry<String, String>> excludes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        excludes.add(new AbstractMap.SimpleEntry<String, String>("address1", "test.#"));
        FederationReceiveFromQueuePolicy policy = new FederationReceiveFromQueuePolicy("test-queue-policy", true, -2, includes, excludes, null, null, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            this.sendQueuePolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerAcceptsQueuePolicyFromControlLinkWithTransformerConfiguration() throws Exception {
        this.server.start();
        ArrayList<AbstractMap.SimpleEntry<String, String>> includes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        includes.add(new AbstractMap.SimpleEntry<String, String>("#", "testQueue"));
        ArrayList<AbstractMap.SimpleEntry<String, String>> excludes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        excludes.add(new AbstractMap.SimpleEntry<String, String>("address1", "test.#"));
        HashMap<String, String> transformerProperties = new HashMap<String, String>();
        transformerProperties.put("key1", "value1");
        transformerProperties.put("key2", "value2");
        TransformerConfiguration transformerConfiguration = new TransformerConfiguration();
        transformerConfiguration.setClassName(ApplicationPropertiesTransformer.class.getName());
        transformerConfiguration.setProperties(transformerProperties);
        FederationReceiveFromQueuePolicy policy = new FederationReceiveFromQueuePolicy("test-queue-policy", true, -2, includes, excludes, null, transformerConfiguration, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            this.sendQueuePolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteFederatesQueueWhenDemandIsApplied() throws Exception {
        this.server.start();
        ArrayList<AbstractMap.SimpleEntry<String, String>> includes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        includes.add(new AbstractMap.SimpleEntry<String, String>("#", "testQueue"));
        FederationReceiveFromQueuePolicy policy = new FederationReceiveFromQueuePolicy("test-queue-policy", true, -2, includes, null, null, null, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            this.sendQueuePolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withSource().withAddress("testQueue::testQueue").and().respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(1).queue();
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("testQueue"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteFederatesQueueWhenDemandIsAppliedUsingControllerDefinedLinkCredit() throws Exception {
        this.server.start();
        ArrayList<AbstractMap.SimpleEntry<String, String>> includes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        includes.add(new AbstractMap.SimpleEntry<String, String>("#", "testQueue"));
        FederationReceiveFromQueuePolicy policy = new FederationReceiveFromQueuePolicy("test-queue-policy", true, -2, includes, null, null, null, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test", 10, 9);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            this.sendQueuePolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withSource().withAddress("testQueue::testQueue").and().respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(1).queue();
            peer.expectFlow().withLinkCredit(10);
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("testQueue"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteFederatesQueueWhenDemandIsAppliedUsingPolicyDefinedLinkCredit() throws Exception {
        this.server.start();
        ArrayList<AbstractMap.SimpleEntry<String, String>> includes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        includes.add(new AbstractMap.SimpleEntry<String, String>("#", "testQueue"));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("amqpCredits", "40");
        properties.put("amqpLowCredits", 39);
        properties.put("minLargeMessageSize", 2048);
        FederationReceiveFromQueuePolicy policy = new FederationReceiveFromQueuePolicy("test-queue-policy", true, -2, includes, null, properties, null, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test", 10, 9);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            this.sendQueuePolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withSource().withAddress("testQueue::testQueue").and().respondInKind();
            peer.expectFlow().withLinkCredit(40);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(1).queue();
            peer.expectFlow().withLinkCredit(40);
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("testQueue"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteFederatesQueueAndAppliesTransformerWhenDemandIsApplied() throws Exception {
        this.server.start();
        ArrayList<AbstractMap.SimpleEntry<String, String>> includes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        includes.add(new AbstractMap.SimpleEntry<String, String>("#", "testQueue"));
        HashMap<String, String> transformerProperties = new HashMap<String, String>();
        transformerProperties.put("key1", "value1");
        transformerProperties.put("key2", "value2");
        TransformerConfiguration transformerConfiguration = new TransformerConfiguration();
        transformerConfiguration.setClassName(ApplicationPropertiesTransformer.class.getName());
        transformerConfiguration.setProperties(transformerProperties);
        FederationReceiveFromQueuePolicy policy = new FederationReceiveFromQueuePolicy("test-queue-policy", true, -2, includes, null, null, transformerConfiguration, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            this.sendQueuePolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withSource().withAddress("testQueue::testQueue").and().respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(1).queue();
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("testQueue"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                Assertions.assertEquals((Object)"value1", (Object)message.getStringProperty("key1"));
                Assertions.assertEquals((Object)"value2", (Object)message.getStringProperty("key2"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerAnswersAttachOfFederationReceiverProperly() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("test::test").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withSource().withAddress("test::test");
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("test::test").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerRoutesInboundMessageToFederatedReceiver() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("test::test").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withSource().withAddress("test::test");
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("test::test").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.remoteFlow().withLinkCredit(1L).now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            HeaderMatcher headerMatcher = new HeaderMatcher(true);
            MessageAnnotationsMatcher annotationsMatcher = new MessageAnnotationsMatcher(true);
            PropertiesMatcher properties = new PropertiesMatcher(true);
            EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher((Object)"Hello World");
            TransferPayloadCompositeMatcher matcher = new TransferPayloadCompositeMatcher();
            matcher.setHeadersMatcher(headerMatcher);
            matcher.setMessageAnnotationsMatcher(annotationsMatcher);
            matcher.setPropertiesMatcher(properties);
            matcher.addMessageContentMatcher((Matcher)bodyMatcher);
            peer.expectTransfer().withPayload((Matcher)matcher).accept();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageProducer producer = session.createProducer((Destination)session.createQueue("test"));
                producer.send((Message)session.createTextMessage("Hello World"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerCanFailLinkAttachIfQueueDoesNotExistWithoutClosingTheConnection() throws Exception {
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("test::test").withSource(CoreMatchers.nullValue());
            peer.expectDetach().withError("amqp:not-found", "Queue: 'test' does not exist").respond();
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("test::test").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("test::test").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withSource().withAddress("test::test");
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("test::test").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerCanFailLinkAttachIfQueueDoesNotMatchFullExpectationWithoutClosingTheConnection() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("test::test").withSource(CoreMatchers.nullValue());
            peer.expectDetach().withError("amqp:not-found", "Queue: 'test' is not mapped to specified address: address").respond();
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("test::test").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("address::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("test::test").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withSource().withAddress("test::test");
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("test::test").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteConnectionCannotAttachQueueFederationLinkWithoutControlLink() throws Exception {
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            peer.queueClientSaslAnonymousConnect();
            peer.remoteOpen().queue();
            peer.expectOpen();
            peer.remoteBegin().queue();
            peer.expectBegin();
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-queue-receiver").withSource(CoreMatchers.nullValue()).withTarget();
            peer.expectDetach().respond();
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("federation-queue-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerRoutesInboundMessageToFederatedReceiverWithFilterApplied() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("test::test").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withSource().withAddress("test::test");
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("test::test").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withJMSSelector("color = 'red'").withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.remoteFlow().withLinkCredit(10L).now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            HeaderMatcher headerMatcher = new HeaderMatcher(true);
            MessageAnnotationsMatcher annotationsMatcher = new MessageAnnotationsMatcher(true);
            ApplicationPropertiesMatcher appPropertiesMatcher = new ApplicationPropertiesMatcher(true);
            appPropertiesMatcher.withEntry("color", CoreMatchers.equalTo((Object)"red"));
            PropertiesMatcher properties = new PropertiesMatcher(true);
            EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher((Object)"red");
            TransferPayloadCompositeMatcher matcher = new TransferPayloadCompositeMatcher();
            matcher.setHeadersMatcher(headerMatcher);
            matcher.setMessageAnnotationsMatcher(annotationsMatcher);
            matcher.setPropertiesMatcher(properties);
            matcher.setApplicationPropertiesMatcher(appPropertiesMatcher);
            matcher.addMessageContentMatcher((Matcher)bodyMatcher);
            peer.expectTransfer().withPayload((Matcher)matcher).accept();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageProducer producer = session.createProducer((Destination)session.createQueue("test"));
                TextMessage blueMessage = session.createTextMessage("blue");
                blueMessage.setStringProperty("color", "blue");
                TextMessage redMessage = session.createTextMessage("red");
                redMessage.setStringProperty("color", "red");
                producer.send((Message)blueMessage);
                producer.send((Message)redMessage);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testBrokerDoesNotFederateQueueIfOnlyDemandIsFromAnotherBrokerFederationSubscription() throws Exception {
        try (ProtonTestServer target = new ProtonTestServer();){
            target.expectSASLAnonymousConnect();
            target.expectOpen().respond();
            target.expectBegin().respond();
            target.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            target.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            target.expectFlow().withLinkCredit(10);
            target.start();
            URI remoteURI = target.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            receiveFromQueue.setIncludeFederated(false);
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            target.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            try (ProtonTestClient client = new ProtonTestClient();){
                this.scriptFederationConnectToRemote(client, "incoming-federation");
                client.connect("localhost", 5672);
                client.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                client.expectAttach().ofSender().withName("fake-federation-incoming-receiver-link").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withSource().withAddress("test::test");
                client.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("fake-federation-incoming-receiver-link").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
                client.remoteFlow().withLinkCredit(10L).now();
                client.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                client.expectDetach();
                client.expectClose();
                client.remoteDetach().withErrorCondition("amqp:resource-deleted", "The resource was deleted").now();
                client.remoteClose().now();
                client.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            target.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            target.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            target.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                target.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                target.expectClose();
                target.remoteClose().now();
                target.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                target.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testBrokerCanFederateQueueIfOnlyDemandIsFromAnotherBrokerFederationSubscription() throws Exception {
        try (ProtonTestServer target = new ProtonTestServer();){
            target.expectSASLAnonymousConnect();
            target.expectOpen().respond();
            target.expectBegin().respond();
            target.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            target.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            target.expectFlow().withLinkCredit(10);
            target.start();
            URI remoteURI = target.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            receiveFromQueue.setIncludeFederated(true);
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            target.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            target.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-2).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            target.expectFlow().withLinkCredit(1000).optional();
            target.expectDetach().respond();
            try (ProtonTestClient client = new ProtonTestClient();){
                this.scriptFederationConnectToRemote(client, "incoming-federation");
                client.connect("localhost", 5672);
                client.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                client.expectAttach().ofSender().withName("fake-federation-incoming-receiver-link").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withSource().withAddress("test::test");
                client.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("fake-federation-incoming-receiver-link").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
                client.remoteFlow().withLinkCredit(10L).now();
                client.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                client.expectDetach();
                client.remoteDetach().withErrorCondition("amqp:resource-deleted", "Resource deleted").later(30);
                client.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            target.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            target.expectClose();
            target.remoteClose().now();
            target.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            target.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testTransformInboundFederatedMessageBeforeDispatch() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            HashMap<String, String> newApplicationProperties = new HashMap<String, String>();
            newApplicationProperties.put("appProperty1", "one");
            newApplicationProperties.put("appProperty2", "two");
            TransformerConfiguration transformerConfiguration = new TransformerConfiguration();
            transformerConfiguration.setClassName(ApplicationPropertiesTransformer.class.getName());
            transformerConfiguration.setProperties(newApplicationProperties);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.setTransformerConfiguration(transformerConfiguration);
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(0).queue();
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                Assertions.assertEquals((Object)"one", (Object)message.getStringProperty("appProperty1"));
                Assertions.assertEquals((Object)"two", (Object)message.getStringProperty("appProperty2"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testPullQueueConsumerGrantsDefaultCreditOnEmptyQueue() throws Exception {
        this.doTestPullConsumerGrantsConfiguredCreditOnEmptyQueue(0, false, 0, false, 100);
    }

    @Test
    @Timeout(value=20L)
    public void testPullQueueConsumerGrantsReceiverConfiguredCreditOnEmptyQueue() throws Exception {
        this.doTestPullConsumerGrantsConfiguredCreditOnEmptyQueue(0, false, 10, true, 10);
    }

    @Test
    @Timeout(value=20L)
    public void testPullQueueConsumerGrantsFederationConfiguredCreditOnEmptyQueue() throws Exception {
        this.doTestPullConsumerGrantsConfiguredCreditOnEmptyQueue(20, true, 0, false, 20);
    }

    @Test
    @Timeout(value=20L)
    public void testPullQueueConsumerGrantsReceiverConfiguredCreditOverFederationConfiguredOnEmptyQueue() throws Exception {
        this.doTestPullConsumerGrantsConfiguredCreditOnEmptyQueue(20, true, 10, true, 10);
    }

    private void doTestPullConsumerGrantsConfiguredCreditOnEmptyQueue(int globalBatch, boolean setGlobal, int receiverBatch, boolean setReceiver, int expected) throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            receiveFromQueue.addProperty("amqpCredits", (Number)0);
            if (setReceiver) {
                receiveFromQueue.addProperty("amqpPullConsumerCredits", (Number)receiverBatch);
            }
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            if (setGlobal) {
                element.addProperty("amqpPullConsumerCredits", (Number)globalBatch);
            }
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(expected);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createQueue("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testPullQueueConsumerGrantsCreditOnlyWhenPendingMessageIsConsumed() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort() + "?amqpCredits=0");
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672?jms.prefetchPolicy.all=0");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                jakarta.jms.Queue queue = session.createQueue("test");
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send(session.createMessage());
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                connection.start();
                producer.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectFlow().withLinkCredit(100);
                Assertions.assertNotNull((Object)consumer.receiveNoWait());
                peer.waitForScriptToComplete(20L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testPullQueueConsumerBatchCreditTopUpAfterEachBacklogDrain() throws Exception {
        this.doTestPullConsumerCreditTopUpAfterEachBacklogDrain(0, false, 0, false, 100);
    }

    @Test
    @Timeout(value=30L)
    public void testPullQueueConsumerBatchCreditTopUpAfterEachBacklogDrainFederationConfigured() throws Exception {
        this.doTestPullConsumerCreditTopUpAfterEachBacklogDrain(10, true, 0, false, 10);
    }

    @Test
    @Timeout(value=30L)
    public void testPullQueueConsumerBatchCreditTopUpAfterEachBacklogDrainPolicyConfigured() throws Exception {
        this.doTestPullConsumerCreditTopUpAfterEachBacklogDrain(0, false, 20, true, 20);
    }

    @Test
    @Timeout(value=30L)
    public void testPullQueueConsumerBatchCreditTopUpAfterEachBacklogDrainBothConfigured() throws Exception {
        this.doTestPullConsumerCreditTopUpAfterEachBacklogDrain(100, true, 20, true, 20);
    }

    private void doTestPullConsumerCreditTopUpAfterEachBacklogDrain(int globalBatch, boolean setGlobal, int receiverBatch, boolean setReceiver, int expected) throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            SimpleString queueName = SimpleString.of((String)"test");
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            if (setReceiver) {
                receiveFromQueue.addProperty("amqpPullConsumerCredits", (Number)receiverBatch);
            }
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            if (setGlobal) {
                element.addProperty("amqpPullConsumerCredits", (Number)globalBatch);
            }
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort() + "?amqpCredits=0");
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672?jms.prefetchPolicy.all=0");
            try (Connection connection = factory.createConnection();){
                int i;
                Session session = connection.createSession(1);
                jakarta.jms.Queue queue = session.createQueue("test");
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send(session.createMessage());
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectFlow().withLinkCredit(expected);
                Assertions.assertNotNull((Object)consumer.receiveNoWait());
                peer.waitForScriptToComplete(20L, TimeUnit.SECONDS);
                for (i = 0; i < expected; ++i) {
                    peer.expectDisposition().withState().accepted();
                    peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(i).now();
                }
                Wait.assertTrue(() -> this.server.queueQuery(queueName).getMessageCount() == (long)expected, (long)10000L);
                for (i = 0; i < expected - 1; ++i) {
                    Assertions.assertNotNull((Object)consumer.receiveNoWait());
                }
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectFlow().withLinkCredit(expected);
                Assertions.assertNotNull((Object)consumer.receiveNoWait());
                peer.waitForScriptToComplete(20L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer.close();
                peer.waitForScriptToComplete(20L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testCoreMessageConvertedToAMQPWhenTunnelingDisabled() throws Exception {
        this.doTestCoreMessageHandlingBasedOnTunnelingState(false);
    }

    @Test
    @Timeout(value=20L)
    public void testCoreMessageNotConvertedToAMQPWhenTunnelingEnabled() throws Exception {
        this.doTestCoreMessageHandlingBasedOnTunnelingState(true);
    }

    private void doTestCoreMessageHandlingBasedOnTunnelingState(boolean tunneling) throws Exception {
        int messageFormat;
        String[] receiverOfferedCapabilities;
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        if (tunneling) {
            receiverOfferedCapabilities = new String[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT.toString()};
            messageFormat = 1183580416;
        } else {
            receiverOfferedCapabilities = null;
            messageFormat = 0;
        }
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-queue-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withDesiredCapabilities(new String[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT.toString()}).withSource().withAddress("test::test");
            peer.remoteAttach().ofReceiver().withOfferedCapabilities(receiverOfferedCapabilities).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("federation-queue-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.remoteFlow().withLinkCredit(10L).now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectTransfer().withNonNullPayload().withMessageFormat(messageFormat).accept();
            ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageProducer producer = session.createProducer((Destination)session.createQueue("test"));
                producer.send((Message)session.createTextMessage("Hello World"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testCoreLargeMessageConvertedToAMQPWhenTunnelingDisabled() throws Exception {
        this.doTestCoreLargeMessageHandlingBasedOnTunnelingState(false);
    }

    @Test
    @Timeout(value=20L)
    public void testCoreLargeMessageNotConvertedToAMQPWhenTunnelingEnabled() throws Exception {
        this.doTestCoreLargeMessageHandlingBasedOnTunnelingState(true);
    }

    private void doTestCoreLargeMessageHandlingBasedOnTunnelingState(boolean tunneling) throws Exception {
        int messageFormat;
        String[] receiverOfferedCapabilities;
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        if (tunneling) {
            receiverOfferedCapabilities = new String[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT.toString()};
            messageFormat = 1183580416;
        } else {
            receiverOfferedCapabilities = null;
            messageFormat = 0;
        }
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-queue-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withDesiredCapabilities(new String[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT.toString()}).withSource().withAddress("test::test");
            peer.remoteAttach().ofReceiver().withOfferedCapabilities(receiverOfferedCapabilities).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("federation-queue-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.remoteFlow().withLinkCredit(10L).now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectTransfer().withNonNullPayload().withMessageFormat(messageFormat).accept();
            ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageProducer producer = session.createProducer((Destination)session.createQueue("test"));
                byte[] payload = new byte[1024];
                Arrays.fill(payload, (byte)65);
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(payload);
                producer.send((Message)message);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesQueueReceiverLinkForQueueAfterBrokerConnectionStarted() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.setAutostart(false);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(1);
            jakarta.jms.Queue queue = session.createQueue("test");
            session.createConsumer((Destination)queue);
            session.createConsumer((Destination)queue);
            session.createConsumer((Destination)queue);
            connection.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            this.server.getBrokerConnections().forEach(c -> {
                try {
                    c.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            session.createConsumer((Destination)queue);
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDetach().respond();
            session.createConsumer((Destination)queue);
            session.createConsumer((Destination)queue);
            connection.close();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesEventSenderAndReceiverWhenLocalAndRemotePoliciesAdded() throws Exception {
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.OPERATION_TYPE.toString(), Matchers.is((Object)"ADD_QUEUE_POLICY"));
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("*");
        includes.add("test");
        policyMap.put("policy-name", "test-policy");
        policyMap.put("include-federated", false);
        policyMap.put("priority-adjustment", 64);
        policyMap.put("queue-includes", includes);
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(policyMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withHandle(0).withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events-sender");
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectAttach().ofReceiver().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withSource().withAddress("test-dynamic-events-receiver");
            peer.expectFlow().withLinkCredit(10);
            peer.remoteFlow().withLinkCredit(10L).withHandle(0L).queue();
            peer.expectTransfer().withPayload((Matcher)payloadMatcher);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement localReceiveFromQueue = new AMQPFederationQueuePolicyElement();
            localReceiveFromQueue.setName("test-policy");
            localReceiveFromQueue.setIncludeFederated(true);
            localReceiveFromQueue.setPriorityAdjustment(Integer.valueOf(42));
            localReceiveFromQueue.addToIncludes("*", "test");
            AMQPFederationQueuePolicyElement remoteReceiveFromQueue = new AMQPFederationQueuePolicyElement();
            remoteReceiveFromQueue.setName("test-policy");
            remoteReceiveFromQueue.setIncludeFederated(false);
            remoteReceiveFromQueue.setPriorityAdjustment(Integer.valueOf(64));
            remoteReceiveFromQueue.addToIncludes("*", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(localReceiveFromQueue);
            element.addRemoteQueuePolicy(remoteReceiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test-address-federation", "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationSendsRemotePolicyIfEventsSenderLinkRejected() throws Exception {
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.OPERATION_TYPE.toString(), Matchers.is((Object)"ADD_QUEUE_POLICY"));
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("*");
        includes.add("test");
        policyMap.put("policy-name", "test-policy");
        policyMap.put("include-federated", false);
        policyMap.put("priority-adjustment", 64);
        policyMap.put("queue-includes", includes);
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(policyMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withHandle(0).withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).reject(true, LinkError.DETACH_FORCED.toString(), "Unknown error");
            peer.expectDetach();
            peer.remoteFlow().withLinkCredit(10L).withHandle(0L).queue();
            peer.expectTransfer().withPayload((Matcher)payloadMatcher);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement remoteReceiveFromQueue = new AMQPFederationQueuePolicyElement();
            remoteReceiveFromQueue.setName("test-policy");
            remoteReceiveFromQueue.setIncludeFederated(false);
            remoteReceiveFromQueue.setPriorityAdjustment(Integer.valueOf(64));
            remoteReceiveFromQueue.addToIncludes("*", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addRemoteQueuePolicy(remoteReceiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test-address-federation", "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerSendsQueueAddedEventForInterestedPeer() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAutoCreateQueues(Boolean.valueOf(false));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(false));
        this.server.getConfiguration().getAddressSettings().put("#", addressSettings);
        this.server.start();
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.EVENT_TYPE.toString(), Matchers.is((Object)"REQUESTED_QUEUE_ADDED_EVENT"));
        LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
        eventMap.put("REQUESTED_ADDRESS_NAME", "test");
        eventMap.put("REQUESTED_QUEUE_NAME", "test");
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(eventMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test", false, true);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-queue-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withTarget().also().withNullSource();
            peer.expectDetach().respond();
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("federation-queue-receiver").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectTransfer().withPayload((Matcher)payloadMatcher).accept();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.MULTICAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesAddressReceiverInResponseToAddressAddedEvent() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withHandle(0).withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.remoteFlow().withLinkCredit(10L);
            peer.expectAttach().ofReceiver().withHandle(1).withSenderSettleModeSettled().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("test-policy");
            receiveFromQueue.setIncludeFederated(false);
            receiveFromQueue.addToIncludes("*", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test-queue-federation", "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respond().withNullSource().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.remoteDetach().withClosed(true).withErrorCondition(AmqpError.NOT_FOUND.toString(), "Queue not found").queue();
            peer.expectFlow().optional();
            peer.expectDetach();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(1);
            session.createConsumer((Destination)session.createQueue("test"));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test::test"), CoreMatchers.containsString((String)"queue-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            AMQPFederationQueuePolicyTest.sendQueueAddedEvent((ProtonTestPeer)peer, "target", "target", 1, 0);
            AMQPFederationQueuePolicyTest.sendQueueAddedEvent((ProtonTestPeer)peer, "test", "test", 1, 1);
            AMQPFederationQueuePolicyTest.sendQueueAddedEvent((ProtonTestPeer)peer, "test", "test", 1, 2);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testAddressAddedEventIgnoredIfFederationConsumerAlreadyCreated() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withHandle(0).withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.remoteFlow().withLinkCredit(10L);
            peer.expectAttach().ofReceiver().withHandle(1).withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("test-policy");
            receiveFromQueue.setIncludeFederated(false);
            receiveFromQueue.addToIncludes("*", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test-queue-federation", "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).respond().withNullSource().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.remoteDetach().withClosed(true).withErrorCondition(AmqpError.NOT_FOUND.toString(), "Queue not found").queue();
            peer.expectFlow().optional();
            peer.expectDetach();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(1);
            session.createConsumer((Destination)session.createQueue("test"));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            session.createConsumer((Destination)session.createQueue("test"));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            AMQPFederationQueuePolicyTest.sendQueueAddedEvent((ProtonTestPeer)peer, "test", "test", 1, 0);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerClosesFederationReceiverAfterQueueRemoved() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, "test", true, true);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("test::test").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withSource().withAddress("test::test");
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()}).withName("test::test").withProperty(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY.toString(), (Object)-1).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test::test").withCapabilities(new String[]{"queue"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDetach().withError(AmqpError.RESOURCE_DELETED.toString());
            this.server.destroyQueue(SimpleString.of((String)"test"), null, false, true);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
            maMatcher.withEntry(AMQPFederationConstants.EVENT_TYPE.toString(), Matchers.is((Object)"REQUESTED_QUEUE_ADDED_EVENT"));
            LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
            eventMap.put("REQUESTED_ADDRESS_NAME", "test");
            eventMap.put("REQUESTED_QUEUE_NAME", "test");
            EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(eventMap);
            TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
            payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
            payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
            peer.expectTransfer().withPayload((Matcher)payloadMatcher).withSettled(true);
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            this.server.destroyQueue(SimpleString.of((String)"test"), null, false, true);
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationQueueDemandTrackedWhenRemoteRejectsInitialAttempts() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                jakarta.jms.Queue queue = session.createQueue("test");
                connection.start();
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).respondInKind().withNullSource();
                peer.expectFlow().withLinkCredit(1000);
                peer.remoteDetach().withErrorCondition("amqp:not-found", "the requested queue was not found").queue().afterDelay(10);
                peer.expectDetach();
                MessageConsumer consumer1 = session.createConsumer((Destination)queue);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).respondInKind().withNullSource();
                peer.expectFlow().withLinkCredit(1000);
                peer.remoteDetach().withErrorCondition("amqp:not-found", "the requested queue was not found").queue().afterDelay(10);
                peer.expectDetach();
                MessageConsumer consumer2 = session.createConsumer((Destination)queue);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()});
                peer.expectFlow().withLinkCredit(1000);
                MessageConsumer consumer3 = session.createConsumer((Destination)queue);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer3.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer2.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer1.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationQueueDemandTrackedWhenPluginBlocksInitialAttempts() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            AtomicInteger blockUntilZero = new AtomicInteger(2);
            AMQPTestFederationBrokerPlugin federationPlugin = new AMQPTestFederationBrokerPlugin();
            federationPlugin.shouldCreateConsumerForDivert = (d, q) -> true;
            federationPlugin.shouldCreateConsumerForQueue = q -> blockUntilZero.getAndDecrement() == 0;
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)federationPlugin);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                jakarta.jms.Queue queue = session.createQueue("test");
                connection.start();
                MessageConsumer consumer1 = session.createConsumer((Destination)queue);
                MessageConsumer consumer2 = session.createConsumer((Destination)queue);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString()).respondInKind();
                peer.expectFlow().withLinkCredit(1000);
                MessageConsumer consumer3 = session.createConsumer((Destination)queue);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer3.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer2.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer1.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    private static void sendQueueAddedEvent(ProtonTestPeer peer, String address, String queue, int handle, int deliveryId) {
        LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
        eventMap.put("REQUESTED_ADDRESS_NAME", address);
        eventMap.put("REQUESTED_QUEUE_NAME", queue);
        peer.remoteTransfer().withHandle((long)handle).withDeliveryId(deliveryId).withSettled(true).withMessageAnnotations().withAnnotation(AMQPFederationConstants.EVENT_TYPE.toString(), (Object)"REQUESTED_QUEUE_ADDED_EVENT").also().withBody().withValue(eventMap).also().now();
    }

    private void sendQueuePolicyToRemote(ProtonTestClient peer, FederationReceiveFromQueuePolicy policy) {
        TransformerConfiguration transformerConfig;
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        policyMap.put("policy-name", policy.getPolicyName());
        policyMap.put("include-federated", policy.isIncludeFederated());
        policyMap.put("priority-adjustment", policy.getPriorityAjustment());
        if (!policy.getIncludes().isEmpty()) {
            ArrayList flattenedIncludes = new ArrayList(policy.getIncludes().size() * 2);
            policy.getIncludes().forEach(entry -> {
                flattenedIncludes.add((String)entry.getKey());
                flattenedIncludes.add((String)entry.getValue());
            });
            policyMap.put("queue-includes", flattenedIncludes);
        }
        if (!policy.getExcludes().isEmpty()) {
            ArrayList flatteneExcludes = new ArrayList(policy.getExcludes().size() * 2);
            policy.getExcludes().forEach(entry -> {
                flatteneExcludes.add((String)entry.getKey());
                flatteneExcludes.add((String)entry.getValue());
            });
            policyMap.put("queue-excludes", flatteneExcludes);
        }
        if ((transformerConfig = policy.getTransformerConfiguration()) != null) {
            policyMap.put("transformer-class-name", transformerConfig.getClassName());
            if (transformerConfig.getProperties() != null && !transformerConfig.getProperties().isEmpty()) {
                policyMap.put("transformer-properties-map", transformerConfig.getProperties());
            }
        }
        if (!policy.getProperties().isEmpty()) {
            policyMap.put("policy-properties-map", policy.getProperties());
        }
        peer.remoteTransfer().withDeliveryId(0).withMessageAnnotations().withAnnotation(AMQPFederationConstants.OPERATION_TYPE.toString(), (Object)"ADD_QUEUE_POLICY").also().withBody().withValue(policyMap).also().now();
    }

    private void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName) {
        this.scriptFederationConnectToRemote(peer, federationName, 1000, 300);
    }

    private void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName, int amqpCredits, int amqpLowCredits) {
        this.scriptFederationConnectToRemote(peer, federationName, amqpCredits, amqpLowCredits, false, false);
    }

    private void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName, boolean eventsSender, boolean eventsReceiver) {
        this.scriptFederationConnectToRemote(peer, federationName, 1000, 300, eventsSender, eventsReceiver);
    }

    private void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName, int amqpCredits, int amqpLowCredits, boolean eventsSender, boolean eventsReceiver) {
        String federationEventsSenderLinkName;
        String federationControlLinkName = "Federation:control:" + UUID.randomUUID().toString();
        HashMap<String, Integer> federationConfiguration = new HashMap<String, Integer>();
        federationConfiguration.put("amqpCredits", amqpCredits);
        federationConfiguration.put("amqpLowCredits", amqpLowCredits);
        HashMap<String, HashMap<String, Integer>> senderProperties = new HashMap<String, HashMap<String, Integer>>();
        senderProperties.put(AMQPFederationConstants.FEDERATION_CONFIGURATION.toString(), federationConfiguration);
        peer.queueClientSaslAnonymousConnect();
        peer.remoteOpen().queue();
        peer.expectOpen();
        peer.remoteBegin().queue();
        peer.expectBegin();
        peer.remoteAttach().ofSender().withInitialDeliveryCount(0L).withName(federationControlLinkName).withPropertiesMap(senderProperties).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().also().withTarget().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
        peer.expectAttach().ofReceiver().withTarget().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString());
        peer.expectFlow();
        if (eventsSender) {
            federationEventsSenderLinkName = "Federation:events-sender:test:" + UUID.randomUUID().toString();
            peer.remoteAttach().ofSender().withName(federationEventsSenderLinkName).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withSenderSettleModeSettled().withReceivervSettlesFirst().withSource().also().withTarget().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.expectAttach().ofReceiver().withName(federationEventsSenderLinkName).withTarget().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString());
            peer.expectFlow();
        }
        if (eventsReceiver) {
            federationEventsSenderLinkName = "Federation:events-receiver:test:" + UUID.randomUUID().toString();
            peer.remoteAttach().ofReceiver().withName(federationEventsSenderLinkName).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withSenderSettleModeSettled().withReceivervSettlesFirst().withTarget().also().withSource().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectAttach().ofSender().withName(federationEventsSenderLinkName).withSource().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString());
        }
    }

    public static class ApplicationPropertiesTransformer
    implements Transformer {
        private final Map<String, String> properties = new HashMap<String, String>();

        public void init(Map<String, String> externalProperties) {
            this.properties.putAll(externalProperties);
        }

        public org.apache.activemq.artemis.api.core.Message transform(org.apache.activemq.artemis.api.core.Message message) {
            if (!(message instanceof AMQPMessage)) {
                return message;
            }
            this.properties.forEach((k, v) -> message.putStringProperty(k, v));
            message.reencode();
            return message;
        }
    }

    private class AMQPTestFederationBrokerPlugin
    implements ActiveMQServerAMQPFederationPlugin {
        public final AtomicBoolean started = new AtomicBoolean();
        public final AtomicBoolean stopped = new AtomicBoolean();
        public final AtomicReference<FederationConsumerInfo> beforeCreateConsumerCapture = new AtomicReference();
        public final AtomicReference<FederationConsumer> afterCreateConsumerCapture = new AtomicReference();
        public final AtomicReference<FederationConsumer> beforeCloseConsumerCapture = new AtomicReference();
        public final AtomicReference<FederationConsumer> afterCloseConsumerCapture = new AtomicReference();
        public Consumer<FederationConsumerInfo> beforeCreateConsumer = c -> this.beforeCreateConsumerCapture.set((FederationConsumerInfo)c);
        public Consumer<FederationConsumer> afterCreateConsumer = c -> this.afterCreateConsumerCapture.set((FederationConsumer)c);
        public Consumer<FederationConsumer> beforeCloseConsumer = c -> this.beforeCloseConsumerCapture.set((FederationConsumer)c);
        public Consumer<FederationConsumer> afterCloseConsumer = c -> this.afterCloseConsumerCapture.set((FederationConsumer)c);
        public BiConsumer<FederationConsumer, org.apache.activemq.artemis.api.core.Message> beforeMessageHandled = (c, m) -> {};
        public BiConsumer<FederationConsumer, org.apache.activemq.artemis.api.core.Message> afterMessageHandled = (c, m) -> {};
        public Function<AddressInfo, Boolean> shouldCreateConsumerForAddress = a -> true;
        public Function<Queue, Boolean> shouldCreateConsumerForQueue = q -> true;
        public BiFunction<Divert, Queue, Boolean> shouldCreateConsumerForDivert = (d, q) -> true;

        private AMQPTestFederationBrokerPlugin() {
        }

        public void federationStarted(Federation federation) throws ActiveMQException {
            this.started.set(true);
        }

        public void federationStopped(Federation federation) throws ActiveMQException {
            this.stopped.set(true);
        }

        public void beforeCreateFederationConsumer(FederationConsumerInfo consumerInfo) throws ActiveMQException {
            this.beforeCreateConsumer.accept(consumerInfo);
        }

        public void afterCreateFederationConsumer(FederationConsumer consumer) throws ActiveMQException {
            this.afterCreateConsumer.accept(consumer);
        }

        public void beforeCloseFederationConsumer(FederationConsumer consumer) throws ActiveMQException {
            this.beforeCloseConsumer.accept(consumer);
        }

        public void afterCloseFederationConsumer(FederationConsumer consumer) throws ActiveMQException {
            this.afterCloseConsumer.accept(consumer);
        }

        public void beforeFederationConsumerMessageHandled(FederationConsumer consumer, org.apache.activemq.artemis.api.core.Message message) throws ActiveMQException {
            this.beforeMessageHandled.accept(consumer, message);
        }

        public void afterFederationConsumerMessageHandled(FederationConsumer consumer, org.apache.activemq.artemis.api.core.Message message) throws ActiveMQException {
            this.afterMessageHandled.accept(consumer, message);
        }

        public boolean shouldCreateFederationConsumerForAddress(AddressInfo address) throws ActiveMQException {
            return this.shouldCreateConsumerForAddress.apply(address);
        }

        public boolean shouldCreateFederationConsumerForQueue(Queue queue) throws ActiveMQException {
            return this.shouldCreateConsumerForQueue.apply(queue);
        }

        public boolean shouldCreateFederationConsumerForDivert(Divert divert, Queue queue) throws ActiveMQException {
            return this.shouldCreateConsumerForDivert.apply(divert, queue);
        }
    }
}

