/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.address.CreateAddress;
import org.apache.activemq.artemis.cli.commands.address.DeleteAddress;
import org.apache.activemq.artemis.cli.commands.address.ShowAddress;
import org.apache.activemq.artemis.cli.commands.address.UpdateAddress;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressCommandTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ByteArrayOutputStream output;
    private ByteArrayOutputStream error;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.output = new ByteArrayOutputStream(1024);
        this.error = new ByteArrayOutputStream(1024);
    }

    @Test
    public void testCreateAddress() throws Exception {
        String address = "address";
        CreateAddress command = new CreateAddress();
        command.setName(address);
        command.setAnycast(true);
        command.setMulticast(true);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)command);
        AddressInfo addressInfo = this.server.getAddressInfo(SimpleString.of((String)address));
        Assertions.assertNotNull((Object)addressInfo);
        Assertions.assertTrue((boolean)addressInfo.getRoutingTypes().contains(RoutingType.ANYCAST));
        Assertions.assertTrue((boolean)addressInfo.getRoutingTypes().contains(RoutingType.MULTICAST));
    }

    @Test
    public void testCreateAddressAlreadyExistsShowsError() throws Exception {
        String address = "address";
        CreateAddress command = new CreateAddress();
        command.setName(address);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)command);
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)address)));
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)command, "Address already exists");
    }

    @Test
    public void testDeleteAddress() throws Exception {
        String address = "address";
        CreateAddress command = new CreateAddress();
        command.setName(address);
        command.execute(new ActionContext());
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)address)));
        DeleteAddress deleteAddress = new DeleteAddress();
        deleteAddress.setName(address);
        deleteAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)deleteAddress);
        Assertions.assertNull((Object)this.server.getAddressInfo(SimpleString.of((String)address)));
    }

    @Test
    public void testDeleteAddressDoesNotExistsShowsError() throws Exception {
        String address = "address";
        DeleteAddress deleteAddress = new DeleteAddress();
        deleteAddress.setName(address);
        deleteAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)deleteAddress, "Address Does Not Exist");
    }

    @Test
    public void testFailDeleteAddressWhenExistsQueues() throws Exception {
        String addressName = "address";
        SimpleString addressSimpleString = SimpleString.of((String)"address");
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST));
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(QueueConfiguration.of((String)"queue1").setAddress(addressSimpleString).setRoutingType(RoutingType.MULTICAST));
        DeleteAddress deleteAddress = new DeleteAddress();
        deleteAddress.setName("address");
        deleteAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)deleteAddress, "Address address has bindings");
    }

    @Test
    public void testForceDeleteAddressWhenExistsQueues() throws Exception {
        String addressName = "address";
        SimpleString addressSimpleString = SimpleString.of((String)"address");
        String queueName = "queue1";
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST));
        this.server.addAddressInfo(addressInfo);
        Queue queue = this.server.createQueue(QueueConfiguration.of((String)"queue1").setAddress(addressSimpleString).setRoutingType(RoutingType.MULTICAST));
        ServerLocator locator = ActiveMQClient.createServerLocator((String)"tcp://127.0.0.1:61616");
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession session = csf.createSession();
        ClientProducer producer = session.createProducer("address");
        producer.send((Message)session.createMessage(true));
        Wait.assertEquals((long)1L, () -> queue.getMessageCount());
        DeleteAddress deleteAddress = new DeleteAddress();
        deleteAddress.setName("address");
        deleteAddress.setForce(Boolean.valueOf(true));
        deleteAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)deleteAddress);
        Wait.assertTrue(() -> this.server.locateQueue("queue1") == null);
    }

    @Test
    public void testShowAddress() throws Exception {
        String address = "address";
        CreateAddress command = new CreateAddress();
        command.setName(address);
        command.execute(new ActionContext());
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)address)));
        ShowAddress showAddress = new ShowAddress();
        showAddress.setName(address);
        showAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        logger.debug(this.output.toString());
    }

    @Test
    public void testShowAddressDoesNotExist() throws Exception {
        String address = "address";
        ShowAddress showAddress = new ShowAddress();
        showAddress.setName(address);
        showAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)showAddress, "Address Does Not Exist");
    }

    @Test
    public void testShowAddressBindings() throws Exception {
        SimpleString address = SimpleString.of((String)"address");
        this.server.addAddressInfo(new AddressInfo(address, RoutingType.MULTICAST));
        this.server.createQueue(QueueConfiguration.of((String)"queue1").setAddress(address).setRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(QueueConfiguration.of((String)"queue2").setAddress(address).setRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(QueueConfiguration.of((String)"queue3").setAddress(address).setRoutingType(RoutingType.MULTICAST));
        DivertConfiguration divertConfiguration = new DivertConfiguration();
        divertConfiguration.setName(address.toString());
        divertConfiguration.setAddress(address.toString());
        this.server.deployDivert(divertConfiguration);
        ShowAddress showAddress = new ShowAddress();
        showAddress.setName(address.toString());
        showAddress.setBindings(true);
        showAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        logger.debug(this.output.toString());
    }

    @Test
    public void testUpdateAddressRoutingTypes() throws Exception {
        String addressName = "address";
        SimpleString address = SimpleString.of((String)"address");
        this.server.addAddressInfo(new AddressInfo(address, RoutingType.ANYCAST));
        UpdateAddress updateAddress = new UpdateAddress();
        updateAddress.setName("address");
        updateAddress.setAnycast(true);
        updateAddress.setMulticast(true);
        updateAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)updateAddress);
        AddressInfo addressInfo = this.server.getAddressInfo(address);
        Assertions.assertNotNull((Object)addressInfo);
        Assertions.assertEquals(EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST), (Object)addressInfo.getRoutingTypes());
    }

    @Test
    public void testFailUpdateAddressDoesNotExist() throws Exception {
        String addressName = "address";
        UpdateAddress updateAddress = new UpdateAddress();
        updateAddress.setName("address");
        updateAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)updateAddress, "Address Does Not Exist");
    }

    @Test
    public void testFailUpdateAddressRoutingTypesWhenExistsQueues() throws Exception {
        String addressName = "address";
        SimpleString addressSimpleString = SimpleString.of((String)"address");
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST));
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(QueueConfiguration.of((String)"queue1").setAddress(addressSimpleString).setRoutingType(RoutingType.MULTICAST));
        UpdateAddress updateAddress = new UpdateAddress();
        updateAddress.setName("address");
        updateAddress.setAnycast(true);
        updateAddress.setMulticast(false);
        updateAddress.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        String expectedErrorMessage = MessageFormat.format("Can''t remove routing type {0}, queues exists for address: {1}. Please delete queues before removing this routing type.", RoutingType.MULTICAST, "address");
        this.checkExecutionFailure((ConnectionAbstract)updateAddress, expectedErrorMessage);
    }

    private void checkExecutionPassed(ConnectionAbstract command) throws Exception {
        String fullMessage = this.output.toString();
        logger.debug("output: {}", (Object)fullMessage);
        Assertions.assertTrue((boolean)fullMessage.contains("successfully"), (String)fullMessage);
    }

    private void checkExecutionFailure(ConnectionAbstract command, String message) throws Exception {
        String fullMessage = this.error.toString();
        logger.debug("error: {}", (Object)fullMessage);
        Assertions.assertTrue((boolean)fullMessage.contains(message), (String)fullMessage);
    }
}

