/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOvsOIOTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testNIOPerf() throws Exception {
        this.testPerf(true);
    }

    @Test
    public void testOIOPerf() throws Exception {
        this.testPerf(false);
    }

    private void doTest(String dest) throws Exception {
        int i;
        int i2;
        ClientSessionFactory sf;
        int i3;
        boolean numSenders = true;
        boolean numReceivers = true;
        int numMessages = 20000;
        Receiver[] receivers = new Receiver[1];
        Sender[] senders = new Sender[1];
        ArrayList<ClientSessionFactory> factories = new ArrayList<ClientSessionFactory>();
        ServerLocator locator = this.createInVMNonHALocator();
        for (i3 = 0; i3 < 1; ++i3) {
            sf = this.createSessionFactory(locator);
            factories.add(sf);
            receivers[i3] = new Receiver(i3, sf, 20000, dest);
            receivers[i3].prepare();
            receivers[i3].start();
        }
        for (i3 = 0; i3 < 1; ++i3) {
            sf = this.createSessionFactory(locator);
            factories.add(sf);
            senders[i3] = new Sender(i3, sf, 20000, dest);
            senders[i3].prepare();
        }
        long start = System.currentTimeMillis();
        for (i2 = 0; i2 < 1; ++i2) {
            senders[i2].start();
        }
        for (i2 = 0; i2 < 1; ++i2) {
            senders[i2].join();
        }
        for (i2 = 0; i2 < 1; ++i2) {
            receivers[i2].await();
        }
        long end = System.currentTimeMillis();
        double rate = 2.0E7 / (double)(end - start);
        this.logAndSystemOut("Rate is " + rate + " msgs sec");
        for (i = 0; i < 1; ++i) {
            senders[i].terminate();
        }
        for (i = 0; i < 1; ++i) {
            receivers[i].terminate();
        }
        for (ClientSessionFactory sf2 : factories) {
            sf2.close();
        }
        locator.close();
    }

    private void testPerf(boolean nio) throws Exception {
        Configuration config = this.createDefaultInVMConfig();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("useNio", nio);
        config.getAcceptorConfigurations().add(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        AddressSettings addressSettings = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK).setMaxSizeBytes(0xA00000L);
        String dest = "test-destination";
        HierarchicalRepository repos = server.getAddressSettingsRepository();
        repos.addMatch("test-destination", (Object)addressSettings);
        server.start();
        for (int i = 0; i < 2; ++i) {
            this.doTest("test-destination");
        }
    }

    private class Receiver
    implements MessageHandler {
        private final ClientSessionFactory sf;
        private final int numMessages;
        private final String dest;
        private ClientSession session;
        private ClientConsumer consumer;
        private final int id;
        private String queueName;
        private final CountDownLatch latch = new CountDownLatch(1);
        private int count;

        Receiver(int id, ClientSessionFactory sf, int numMessages, String dest) {
            this.id = id;
            this.sf = sf;
            this.numMessages = numMessages;
            this.dest = dest;
        }

        void prepare() throws Exception {
            this.session = this.sf.createSession(true, true, 0);
            this.queueName = UUIDGenerator.getInstance().generateStringUUID();
            this.session.createQueue(QueueConfiguration.of((String)this.queueName).setAddress(this.dest).setRoutingType(RoutingType.ANYCAST));
            this.consumer = this.session.createConsumer(this.queueName);
            this.consumer.setMessageHandler((MessageHandler)this);
        }

        void start() throws Exception {
            this.session.start();
        }

        void await() throws Exception {
            ActiveMQTestBase.waitForLatch(this.latch);
        }

        public void onMessage(ClientMessage msg) {
            try {
                msg.acknowledge();
            }
            catch (Exception e) {
                logger.error("Caught exception", (Throwable)e);
            }
            ++this.count;
            if (this.count == this.numMessages) {
                this.latch.countDown();
            }
        }

        public void terminate() throws Exception {
            this.consumer.close();
            this.session.deleteQueue(this.queueName);
            this.session.close();
        }
    }

    private class Sender
    extends Thread {
        private final ClientSessionFactory sf;
        private final int numMessages;
        private final String dest;
        private ClientSession session;
        private ClientProducer producer;
        private final int id;

        Sender(int id, ClientSessionFactory sf, int numMessages, String dest) {
            this.id = id;
            this.sf = sf;
            this.numMessages = numMessages;
            this.dest = dest;
        }

        void prepare() throws Exception {
            this.session = this.sf.createSession(true, true);
            this.producer = this.session.createProducer(this.dest);
        }

        @Override
        public void run() {
            ClientMessage msg = this.session.createMessage(false);
            for (int i = 0; i < this.numMessages; ++i) {
                try {
                    this.producer.send((Message)msg);
                    continue;
                }
                catch (Exception e) {
                    logger.error("Caught exception", (Throwable)e);
                }
            }
        }

        public void terminate() throws Exception {
            this.session.close();
        }
    }
}

