/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SessionCloseTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSessionFactory sf;

    @Test
    public void testCanNotUseAClosedSession() throws Exception {
        ClientSession session = this.sf.createSession(false, true, true);
        session.close();
        Assertions.assertTrue((boolean)session.isClosed());
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.createProducer());
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.createConsumer(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString()));
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.createQueue(QueueConfiguration.of((SimpleString)org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString()).setDurable(Boolean.valueOf(org.apache.activemq.artemis.utils.RandomUtil.randomBoolean()))));
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.createQueue(QueueConfiguration.of((SimpleString)org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString()).setAddress(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString()).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true))));
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.start());
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.stop());
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.commit());
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.rollback());
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.queueQuery(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString()));
        ActiveMQTestBase.expectActiveMQException(ActiveMQExceptionType.OBJECT_CLOSED, () -> session.addressQuery(org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString()));
    }

    @Test
    public void testCanNotUseXAWithClosedSession() throws Exception {
        ClientSession session = this.sf.createSession(true, false, false);
        session.close();
        Assertions.assertTrue((boolean)session.isXA());
        Assertions.assertTrue((boolean)session.isClosed());
        ActiveMQTestBase.expectXAException(-7, () -> session.commit(RandomUtil.randomXid(), true));
        ActiveMQTestBase.expectXAException(4, () -> session.commit(RandomUtil.randomXid(), false));
        ActiveMQTestBase.expectXAException(-7, () -> session.end(RandomUtil.randomXid(), 0x4000000));
        ActiveMQTestBase.expectXAException(-7, () -> session.forget(RandomUtil.randomXid()));
        ActiveMQTestBase.expectXAException(-7, () -> session.prepare(RandomUtil.randomXid()));
        ActiveMQTestBase.expectXAException(-7, () -> session.recover(0x1000000));
        ActiveMQTestBase.expectXAException(-7, () -> session.rollback(RandomUtil.randomXid()));
        ActiveMQTestBase.expectXAException(-7, () -> session.start(RandomUtil.randomXid(), 0));
    }

    @Test
    public void testCloseHierarchy() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(address);
        ClientConsumer consumer = session.createConsumer(queue);
        session.close();
        Assertions.assertTrue((boolean)session.isClosed());
        Assertions.assertTrue((boolean)producer.isClosed());
        Assertions.assertTrue((boolean)consumer.isClosed());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(locator);
    }
}

