/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.activemq.artemis.core.server.cluster.quorum.QuorumVoteServerConnect;
import org.apache.activemq.artemis.core.server.cluster.quorum.ServerConnectVote;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class QuorumVoteServerConnectTest
extends ActiveMQTestBase {
    private final int size;
    private final int trueVotes;

    @Parameters(name="size={0} trueVotes={1}")
    public static Collection primeNumbers() {
        return Arrays.asList({1, 0}, {2, 1}, {3, 2}, {4, 3}, {5, 3}, {6, 4}, {7, 4}, {8, 5}, {9, 5}, {10, 6});
    }

    public QuorumVoteServerConnectTest(int size, int trueVotes) {
        this.size = size;
        this.trueVotes = trueVotes;
    }

    @TestTemplate
    public void testVoteOnRequestToStay() {
        Assumptions.assumeTrue((this.trueVotes > 0 ? 1 : 0) != 0);
        Assumptions.assumeTrue((this.size > this.trueVotes ? 1 : 0) != 0);
        String connector = "primary";
        String backupConnector = "backup";
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo", true, "primary");
        quorum.vote(new ServerConnectVote("foo", true, "backup"));
        Assertions.assertFalse((boolean)quorum.getDecision());
        for (int i = 0; i < this.trueVotes - 1; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, "primary"));
            Assertions.assertFalse((boolean)quorum.getDecision());
        }
        quorum.vote(new ServerConnectVote("foo", true, "primary"));
        Assertions.assertTrue((boolean)quorum.getDecision());
    }

    @TestTemplate
    public void testAllVoteCastFreezeNotRequestToStayDecision() {
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        Assertions.assertFalse((boolean)quorum.isRequestToStayActive());
        boolean decisionBeforeVoteCompleted = quorum.getDecision();
        quorum.allVotesCast(null);
        for (int i = 0; i < this.trueVotes; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        Assertions.assertEquals((Object)decisionBeforeVoteCompleted, (Object)quorum.getDecision());
    }

    @TestTemplate
    public void testAllVoteCastFreezeRequestToStayDecision() {
        String connector = "primary";
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo", true, "primary");
        Assertions.assertTrue((boolean)quorum.isRequestToStayActive());
        boolean decisionBeforeVoteCompleted = quorum.getDecision();
        quorum.allVotesCast(null);
        for (int i = 0; i < this.trueVotes; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, "primary"));
        }
        Assertions.assertEquals((Object)decisionBeforeVoteCompleted, (Object)quorum.getDecision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testAllVoteCastUnblockAwait() throws InterruptedException {
        Assumptions.assumeTrue((this.trueVotes > 0 ? 1 : 0) != 0);
        Assumptions.assumeTrue((this.size > this.trueVotes ? 1 : 0) != 0);
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        Assertions.assertFalse((boolean)quorum.getDecision());
        CountDownLatch taskStarted = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<InterruptedException> waitingTaskResult = executor.submit(() -> {
                taskStarted.countDown();
                try {
                    quorum.await(1, TimeUnit.DAYS);
                    return null;
                }
                catch (InterruptedException e) {
                    return e;
                }
            });
            Assertions.assertTrue((boolean)taskStarted.await(10L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)waitingTaskResult.isDone());
            quorum.allVotesCast(null);
            try {
                Assertions.assertNull((Object)waitingTaskResult.get(5L, TimeUnit.SECONDS));
            }
            catch (TimeoutException ex) {
                Assertions.fail((String)"allVoteCast hasn't unblocked the waiting task");
            }
            catch (ExecutionException ex) {
                Assertions.fail((String)("This shouldn't really happen: the wait task shouldn't throw any exception: " + ex));
            }
            Assertions.assertTrue((boolean)waitingTaskResult.isDone());
            Assertions.assertFalse((boolean)quorum.getDecision());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testRequestToStayQuorumUnblockAwait() throws InterruptedException {
        Assumptions.assumeTrue((this.trueVotes > 0 ? 1 : 0) != 0);
        Assumptions.assumeTrue((this.size > this.trueVotes ? 1 : 0) != 0);
        String connector = "primary";
        String backupConnector = "backup";
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo", true, "primary");
        Assertions.assertFalse((boolean)quorum.getDecision());
        CountDownLatch taskStarted = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<InterruptedException> waitingTaskResult = executor.submit(() -> {
                taskStarted.countDown();
                try {
                    quorum.await(1, TimeUnit.DAYS);
                    return null;
                }
                catch (InterruptedException e) {
                    return e;
                }
            });
            Assertions.assertTrue((boolean)taskStarted.await(10L, TimeUnit.SECONDS));
            quorum.vote(new ServerConnectVote("foo", true, "backup"));
            Assertions.assertFalse((boolean)waitingTaskResult.isDone());
            Assertions.assertFalse((boolean)quorum.getDecision());
            for (int i = 0; i < this.trueVotes - 1; ++i) {
                quorum.vote(new ServerConnectVote("foo", true, "primary"));
                Assertions.assertFalse((boolean)waitingTaskResult.isDone());
                Assertions.assertFalse((boolean)quorum.getDecision());
            }
            quorum.vote(new ServerConnectVote("foo", true, "primary"));
            Assertions.assertTrue((boolean)quorum.getDecision());
            try {
                Assertions.assertNull((Object)waitingTaskResult.get(5L, TimeUnit.SECONDS));
            }
            catch (TimeoutException ex) {
                Assertions.fail((String)"allVoteCast hasn't unblocked the waiting task");
            }
            catch (ExecutionException ex) {
                Assertions.fail((String)("This shouldn't really happen: the wait task shouldn't throw any exception: " + ex));
            }
            Assertions.assertTrue((boolean)waitingTaskResult.isDone());
            Assertions.assertTrue((boolean)quorum.getDecision());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testNotRequestToStayQuorumUnblockAwait() throws InterruptedException {
        Assumptions.assumeTrue((this.trueVotes > 0 ? 1 : 0) != 0);
        Assumptions.assumeTrue((this.size > this.trueVotes ? 1 : 0) != 0);
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        Assertions.assertFalse((boolean)quorum.getDecision());
        CountDownLatch taskStarted = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<InterruptedException> waitingTaskResult = executor.submit(() -> {
                taskStarted.countDown();
                try {
                    quorum.await(1, TimeUnit.DAYS);
                    return null;
                }
                catch (InterruptedException e) {
                    return e;
                }
            });
            Assertions.assertTrue((boolean)taskStarted.await(10L, TimeUnit.SECONDS));
            quorum.vote(new ServerConnectVote("foo", false, null));
            Assertions.assertFalse((boolean)waitingTaskResult.isDone());
            Assertions.assertFalse((boolean)quorum.getDecision());
            for (int i = 0; i < this.trueVotes - 1; ++i) {
                quorum.vote(new ServerConnectVote("foo", true, null));
                Assertions.assertFalse((boolean)waitingTaskResult.isDone());
                Assertions.assertFalse((boolean)quorum.getDecision());
            }
            quorum.vote(new ServerConnectVote("foo", true, null));
            Assertions.assertTrue((boolean)quorum.getDecision());
            try {
                Assertions.assertNull((Object)waitingTaskResult.get(5L, TimeUnit.SECONDS));
            }
            catch (TimeoutException ex) {
                Assertions.fail((String)"allVoteCast hasn't unblocked the waiting task");
            }
            catch (ExecutionException ex) {
                Assertions.fail((String)("This shouldn't really happen: the wait task shouldn't throw any exception: " + ex));
            }
            Assertions.assertTrue((boolean)waitingTaskResult.isDone());
            Assertions.assertTrue((boolean)quorum.getDecision());
        }
        finally {
            executor.shutdownNow();
        }
    }

    @TestTemplate
    public void testSuccessfulVote() {
        int i;
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        for (i = 0; i < this.trueVotes - 1; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        if (this.size > 1) {
            Assertions.assertFalse((boolean)quorum.getDecision());
        }
        quorum = new QuorumVoteServerConnect(this.size, "foo");
        for (i = 0; i < this.trueVotes; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        Assertions.assertTrue((boolean)quorum.getDecision());
    }

    @TestTemplate
    public void testUnSuccessfulVote() {
        int i;
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        for (i = 0; i < this.trueVotes - 1; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        if (this.size > 1) {
            Assertions.assertFalse((boolean)quorum.getDecision());
        }
        quorum = new QuorumVoteServerConnect(this.size, "foo");
        for (i = 0; i < this.trueVotes - 1; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        if (this.size == 1) {
            Assertions.assertTrue((boolean)quorum.getDecision());
        } else {
            Assertions.assertFalse((boolean)quorum.getDecision());
        }
    }
}

