/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShrinkDataOnStartTest
extends ActiveMQTestBase {
    @Test
    public void shrinkDataOnStart() throws Exception {
        ActiveMQServer server = this.addServer(this.createServer(true));
        server.getConfiguration().setJournalMinFiles(10);
        server.getConfiguration().setJournalPoolFiles(2);
        server.start();
        Wait.waitFor(() -> ((ActiveMQServer)server).isActive());
        Assertions.assertEquals((int)10, (int)server.getStorageManager().getMessageJournal().getFileFactory().listFiles("amq").size());
        server.stop();
        server.getConfiguration().setJournalMinFiles(2);
        server.getConfiguration().setJournalPoolFiles(2);
        server.start();
        Assertions.assertEquals((int)2, (int)server.getStorageManager().getMessageJournal().getFileFactory().listFiles("amq").size());
    }
}

