/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.protocol.mqtt.exceptions.InvalidClientIdException;
import org.apache.activemq.artemis.core.remoting.impl.AbstractAcceptor;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager5;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.MQTTException;
import org.fusesource.mqtt.codec.CONNACK;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MQTTSecurityManagerTest
extends MQTTTestSupport {
    private String clientID = "new-" + RandomUtil.randomString();
    private boolean rejectClientId = false;

    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Override
    public void configureBroker() throws Exception {
        super.configureBroker();
        this.server.setSecurityManager((ActiveMQSecurityManager)new ActiveMQSecurityManager5(){

            public Subject authenticate(String user, String password, RemotingConnection remotingConnection, String securityDomain) {
                if (MQTTSecurityManagerTest.this.rejectClientId) {
                    throw new InvalidClientIdException();
                }
                remotingConnection.setClientID(MQTTSecurityManagerTest.this.clientID);
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)new UserPrincipal(user));
                return subject;
            }

            public boolean authorize(Subject subject, Set<Role> roles, CheckType checkType, String address) {
                return true;
            }

            public boolean validateUser(String user, String password) {
                return true;
            }

            public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
                return true;
            }
        });
        this.server.getConfiguration().setAuthenticationCacheSize(0L);
        this.server.getConfiguration().setAuthorizationCacheSize(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testSecurityManagerModifyClientID() throws Exception {
        BlockingConnection connection = null;
        try {
            ProtocolManager protocolManager;
            MQTT mqtt = this.createMQTTConnection(RandomUtil.randomString(), true);
            mqtt.setUserName(this.fullUser);
            mqtt.setPassword(this.fullPass);
            mqtt.setConnectAttemptsMax(1L);
            connection = mqtt.blockingConnection();
            connection.connect();
            BlockingConnection finalConnection = connection;
            Assertions.assertTrue((boolean)Wait.waitFor(() -> finalConnection.isConnected(), (long)5000L, (long)100L), (String)"Should be connected");
            Map sessionStates = null;
            Acceptor acceptor = this.server.getRemotingService().getAcceptor("MQTT");
            if (acceptor instanceof AbstractAcceptor && (protocolManager = (ProtocolManager)((AbstractAcceptor)acceptor).getProtocolMap().get("MQTT")) instanceof MQTTProtocolManager) {
                sessionStates = ((MQTTProtocolManager)protocolManager).getStateManager().getSessionStates();
            }
            Assertions.assertEquals((int)1, (int)sessionStates.size());
            Assertions.assertTrue((boolean)sessionStates.keySet().contains(this.clientID));
            for (MQTTSessionState state : sessionStates.values()) {
                Assertions.assertEquals((Object)this.clientID, (Object)state.getClientId());
            }
        }
        finally {
            if (connection != null && connection.isConnected()) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testSecurityManagerModifyClientIDAndStealConnection() throws Exception {
        BlockingConnection connection1 = null;
        BlockingConnection connection2 = null;
        String CLIENT_ID = "old-" + RandomUtil.randomString();
        try {
            Object protocolManager;
            MQTT mqtt = this.createMQTTConnection(CLIENT_ID, true);
            mqtt.setUserName(this.fullUser);
            mqtt.setPassword(this.fullPass);
            mqtt.setConnectAttemptsMax(1L);
            connection1 = mqtt.blockingConnection();
            connection1.connect();
            BlockingConnection finalConnection = connection1;
            Assertions.assertTrue((boolean)Wait.waitFor(() -> finalConnection.isConnected(), (long)5000L, (long)100L), (String)"Should be connected");
            Map sessionStates = null;
            Acceptor acceptor = this.server.getRemotingService().getAcceptor("MQTT");
            if (acceptor instanceof AbstractAcceptor && (protocolManager = (ProtocolManager)((AbstractAcceptor)acceptor).getProtocolMap().get("MQTT")) instanceof MQTTProtocolManager) {
                sessionStates = ((MQTTProtocolManager)protocolManager).getStateManager().getSessionStates();
            }
            Assertions.assertEquals((int)1, (int)sessionStates.size());
            Assertions.assertTrue((boolean)sessionStates.keySet().contains(this.clientID));
            for (MQTTSessionState state : sessionStates.values()) {
                Assertions.assertEquals((Object)this.clientID, (Object)state.getClientId());
            }
            connection2 = mqtt.blockingConnection();
            connection2.connect();
            BlockingConnection finalConnection2 = connection2;
            Assertions.assertTrue((boolean)Wait.waitFor(() -> finalConnection2.isConnected(), (long)5000L, (long)100L), (String)"Should be connected");
            Wait.assertFalse(() -> finalConnection.isConnected(), (long)5000L, (long)100L);
            Assertions.assertEquals((int)1, (int)sessionStates.size());
            Assertions.assertTrue((boolean)sessionStates.keySet().contains(this.clientID));
            for (MQTTSessionState state : sessionStates.values()) {
                Assertions.assertEquals((Object)this.clientID, (Object)state.getClientId());
            }
        }
        finally {
            if (connection1 != null && connection1.isConnected()) {
                connection1.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testSecurityManagerRejectClientID() throws Exception {
        this.rejectClientId = true;
        BlockingConnection connection = null;
        try {
            MQTT mqtt = this.createMQTTConnection(RandomUtil.randomString(), true);
            mqtt.setUserName(this.fullUser);
            mqtt.setPassword(this.fullPass);
            mqtt.setConnectAttemptsMax(1L);
            connection = mqtt.blockingConnection();
            try {
                connection.connect();
                Assertions.fail((String)"Should have thrown exception");
            }
            catch (MQTTException e) {
                Assertions.assertEquals((Object)CONNACK.Code.CONNECTION_REFUSED_IDENTIFIER_REJECTED, (Object)e.connack.code());
            }
        }
        finally {
            if (connection != null && connection.isConnected()) {
                connection.disconnect();
            }
        }
    }
}

