/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.plugin.impl.LoggingActiveMQServerPlugin;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.tests.integration.plugin.ConfigurationVerifier;
import org.apache.activemq.artemis.tests.integration.plugin.MethodCalledVerifier;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlConfigPluginTest
extends ActiveMQTestBase {
    @Test
    public void testStopStart1() throws Exception {
        ActiveMQServer server = this.createServerFromConfig("broker-plugins-config.xml");
        try {
            server.start();
            Assertions.assertEquals((int)2, (int)server.getBrokerPlugins().size());
            Assertions.assertTrue((boolean)(server.getBrokerPlugins().get(0) instanceof MethodCalledVerifier));
            Assertions.assertTrue((boolean)(server.getBrokerPlugins().get(1) instanceof ConfigurationVerifier));
            ConfigurationVerifier configurationVerifier = (ConfigurationVerifier)server.getBrokerPlugins().get(1);
            Assertions.assertEquals((Object)"val_1", (Object)configurationVerifier.value1, (String)"value1");
            Assertions.assertEquals((Object)"val_2", (Object)configurationVerifier.value2, (String)"value2");
            Assertions.assertNull((Object)configurationVerifier.value3, (String)"value3 should not have been set");
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    @Test
    public void testLoggingActiveMQServerPlugin() throws Exception {
        ActiveMQServer server = this.createServerFromConfig("broker-logging-plugin.xml");
        try {
            server.start();
            Assertions.assertEquals((int)1, (int)server.getBrokerPlugins().size(), (String)"only one plugin should be registered");
            Assertions.assertTrue((boolean)(server.getBrokerPlugins().get(0) instanceof LoggingActiveMQServerPlugin), (String)"ensure LoggingActiveMQServerPlugin is registered");
            LoggingActiveMQServerPlugin loggingActiveMQServerPlugin = (LoggingActiveMQServerPlugin)server.getBrokerPlugins().get(0);
            Assertions.assertTrue((boolean)loggingActiveMQServerPlugin.isLogAll(), (String)"check logAll");
            Assertions.assertTrue((boolean)loggingActiveMQServerPlugin.isLogConnectionEvents(), (String)"check logConnectionEvents");
            Assertions.assertTrue((boolean)loggingActiveMQServerPlugin.isLogSessionEvents(), (String)"check logSessionEvents");
            Assertions.assertTrue((boolean)loggingActiveMQServerPlugin.isLogConsumerEvents(), (String)"check logConsumerEvents");
            Assertions.assertTrue((boolean)loggingActiveMQServerPlugin.isLogDeliveringEvents(), (String)"check logDeliveringEvents");
            Assertions.assertTrue((boolean)loggingActiveMQServerPlugin.isLogSendingEvents(), (String)"check logSendingEvents");
            Assertions.assertTrue((boolean)loggingActiveMQServerPlugin.isLogInternalEvents(), (String)"check logInternalEvents");
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    @Test
    public void testLoggingActiveMQServerPluginWrongValue() throws Exception {
        ActiveMQServer server = this.createServerFromConfig("broker-logging-plugin-wrong.xml");
        try {
            server.start();
            Assertions.assertEquals((int)1, (int)server.getBrokerPlugins().size(), (String)"only one plugin should be registered");
            Assertions.assertTrue((boolean)(server.getBrokerPlugins().get(0) instanceof LoggingActiveMQServerPlugin), (String)"ensure LoggingActiveMQServerPlugin is registered");
            LoggingActiveMQServerPlugin loggingActiveMQServerPlugin = (LoggingActiveMQServerPlugin)server.getBrokerPlugins().get(0);
            Assertions.assertFalse((boolean)loggingActiveMQServerPlugin.isLogAll(), (String)"check logAll");
            Assertions.assertFalse((boolean)loggingActiveMQServerPlugin.isLogConnectionEvents(), (String)"check logConnectionEvents");
            Assertions.assertFalse((boolean)loggingActiveMQServerPlugin.isLogSessionEvents(), (String)"check logSessionEvents");
            Assertions.assertFalse((boolean)loggingActiveMQServerPlugin.isLogConsumerEvents(), (String)"check logConsumerEvents");
            Assertions.assertFalse((boolean)loggingActiveMQServerPlugin.isLogDeliveringEvents(), (String)"check logDeliveringEvents");
            Assertions.assertFalse((boolean)loggingActiveMQServerPlugin.isLogSendingEvents(), (String)"check logSendingEvents");
            Assertions.assertFalse((boolean)loggingActiveMQServerPlugin.isLogInternalEvents(), (String)"check logInternalEvents");
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private ActiveMQServer createServerFromConfig(String configFileName) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileJMSConfiguration fileConfiguration = new FileJMSConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(configFileName);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.addDeployable((Deployable)fileConfiguration);
        deploymentManager.readConfiguration();
        return this.addServer((ActiveMQServer)new ActiveMQServerImpl((Configuration)fc));
    }
}

