/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class NetworkHealthCheckTest
extends ActiveMQTestBase {
    private static final String HEALTH_CHECK_LOGGER_NAME = NetworkHealthCheck.class.getName();
    private static AssertionLoggerHandler.LogLevel previousLevel;

    @BeforeAll
    public static void prepareLogger() {
        previousLevel = AssertionLoggerHandler.setLevel((String)HEALTH_CHECK_LOGGER_NAME, (AssertionLoggerHandler.LogLevel)AssertionLoggerHandler.LogLevel.DEBUG);
    }

    @AfterAll
    public static void clearLogger() {
        AssertionLoggerHandler.setLevel((String)HEALTH_CHECK_LOGGER_NAME, (AssertionLoggerHandler.LogLevel)previousLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomIpv4Command() throws Exception {
        boolean checkingTimeout = true;
        String checkingHost = "10.0.0.1";
        String customIpv4Command = "DUMMYPING %d %s";
        ConfigurationImpl config = this.createBasicConfig().setNetworkCheckTimeout(1).setNetworkCheckList("10.0.0.1").setNetworkCheckPingCommand("DUMMYPING %d %s");
        ActiveMQServer server = this.createServer(false, (Configuration)config);
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            server.start();
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"executing ping:: " + String.format("DUMMYPING %d %s", 1, "10.0.0.1")}));
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{String.format(NetworkHealthCheck.IPV4_DEFAULT_COMMAND, 1, "10.0.0.1")}));
        }
        finally {
            server.stop();
        }
    }
}

