/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.NoCacheLoginException;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class StompWithClientIdValidationTest
extends StompTestBase {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        ConfigurationImpl config = this.createBasicConfig().setSecurityEnabled(this.isSecurityEnabled()).setPersistenceEnabled(this.isPersistenceEnabled()).addAcceptorConfiguration("stomp", "tcp://localhost:61613?enabledProtocols=STOMP").addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName())).setSecurityInvalidationInterval(0L);
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration()){

            public Subject authenticate(String user, String password, RemotingConnection remotingConnection, String securityDomain) throws NoCacheLoginException {
                String clientId;
                Subject validatedUser = super.authenticate(user, password, remotingConnection, securityDomain);
                if (validatedUser == null) {
                    return null;
                }
                if ("STOMP".equals(remotingConnection.getProtocolName()) && ((clientId = remotingConnection.getClientID()) == null || clientId.length() == 0)) {
                    System.err.println("ClientID not set!");
                    return null;
                }
                return validatedUser;
            }
        };
        securityManager.getConfiguration().addUser(this.defUser, this.defPass);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager));
        return this.server;
    }

    @TestTemplate
    public void testStompConnectWithClientId() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        try {
            Assertions.assertEquals((Object)"CONNECTED", (Object)conn.connect(this.defUser, this.defPass, "MyClientID").getCommand());
        }
        finally {
            conn.closeTransport();
        }
    }

    @TestTemplate
    public void testStompConnectWithoutClientId() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        try {
            Assertions.assertEquals((Object)"ERROR", (Object)conn.connect(this.defUser, this.defPass).getCommand());
        }
        finally {
            conn.closeTransport();
        }
    }
}

