/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.impl.fakes;

import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.selector.filter.Filterable;

public class FakeFilter
implements Filter {
    private String headerName;
    private Object headerValue;

    public FakeFilter(String headerName, Object headerValue) {
        this.headerName = headerName;
        this.headerValue = headerValue;
    }

    public FakeFilter() {
    }

    public boolean match(Message message) {
        if (this.headerName != null) {
            Object value = message.getObjectProperty(this.headerName);
            if (value instanceof SimpleString) {
                value = ((SimpleString)value).toString();
            }
            return value != null && this.headerValue.equals(value);
        }
        return true;
    }

    public boolean match(Map<String, String> map) {
        return false;
    }

    public boolean match(Filterable filterable) {
        return false;
    }

    public SimpleString getFilterString() {
        return null;
    }
}

