/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms;

import jakarta.jms.Destination;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActiveMQDestinationTest
extends ActiveMQTestBase {
    @Test
    public void testEquals() throws Exception {
        String destinationName = RandomUtil.randomString();
        String address = "queue://" + destinationName;
        ActiveMQDestination destination = ActiveMQDestination.fromPrefixedName((String)address);
        ActiveMQDestination sameDestination = ActiveMQDestination.fromPrefixedName((String)address);
        ActiveMQDestination differentDestination = ActiveMQDestination.fromPrefixedName((String)(address + RandomUtil.randomString()));
        Assertions.assertFalse((boolean)destination.equals(null));
        Assertions.assertTrue((boolean)destination.equals((Object)destination));
        Assertions.assertTrue((boolean)destination.equals((Object)sameDestination));
        Assertions.assertFalse((boolean)destination.equals((Object)differentDestination));
    }

    @Test
    public void testFromAddressWithQueueAddressPrefix() throws Exception {
        String destinationName = RandomUtil.randomString();
        String address = "queue://" + destinationName;
        ActiveMQDestination destination = ActiveMQDestination.fromPrefixedName((String)address);
        Assertions.assertTrue((boolean)(destination instanceof Queue));
        Assertions.assertEquals((Object)destinationName, (Object)((Queue)destination).getQueueName());
    }

    @Test
    public void testFromAddressWithTopicAddressPrefix() throws Exception {
        String destinationName = RandomUtil.randomString();
        String address = "topic://" + destinationName;
        ActiveMQDestination destination = ActiveMQDestination.fromPrefixedName((String)address);
        Assertions.assertTrue((boolean)(destination instanceof Topic));
        Assertions.assertEquals((Object)destinationName, (Object)((Topic)destination).getTopicName());
    }

    @Test
    public void testFromAddressWithInvalidPrefix() throws Exception {
        String invalidPrefix = "junk";
        String destinationName = RandomUtil.randomString();
        String address = invalidPrefix + destinationName;
        ActiveMQDestination destination = ActiveMQDestination.fromPrefixedName((String)address);
        Assertions.assertTrue((boolean)(destination instanceof Destination));
    }

    @Test
    public void testQueueToStringNPE() {
        ActiveMQQueue destination = new ActiveMQQueue();
        try {
            System.out.println("Destination: " + destination.toString());
        }
        catch (NullPointerException npe) {
            Assertions.fail((String)"Caught NPE!");
        }
    }

    @Test
    public void testTopicToStringNPE() {
        ActiveMQTopic destination = new ActiveMQTopic();
        try {
            System.out.println("Destination: " + destination.toString());
        }
        catch (NullPointerException npe) {
            Assertions.fail((String)"Caught NPE!");
        }
    }
}

