/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.utils.AutomaticLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AutomaticLatchTest {
    @Test
    public void testWthPending() {
        AtomicInteger value = new AtomicInteger(0);
        AutomaticLatch latch = new AutomaticLatch(1);
        latch.afterCompletion(() -> value.incrementAndGet());
        Assertions.assertEquals((int)0, (int)value.get());
        latch.countDown();
        Assertions.assertEquals((int)1, (int)value.get());
    }

    @Test
    public void testWthoutPending() {
        AtomicInteger value = new AtomicInteger(0);
        AutomaticLatch latch = new AutomaticLatch(0);
        latch.afterCompletion(() -> value.incrementAndGet());
        Assertions.assertEquals((int)1, (int)value.get());
        latch.countUp();
        latch.countDown();
        Assertions.assertEquals((int)1, (int)value.get());
        latch.afterCompletion(() -> value.addAndGet(10));
        Assertions.assertEquals((int)11, (int)value.get());
        latch.countUp();
        latch.countDown();
        Assertions.assertEquals((int)11, (int)value.get());
    }

    @Test
    public void testMultipleCallsOrder() {
        ArrayList outcome = new ArrayList();
        AutomaticLatch latch = new AutomaticLatch(1);
        latch.afterCompletion(() -> outcome.add(0));
        latch.afterCompletion(() -> outcome.add(1));
        latch.afterCompletion(() -> outcome.add(2));
        latch.countDown();
        Assertions.assertEquals((Integer)0, (Integer)((Integer)outcome.get(0)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)outcome.get(1)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)outcome.get(2)));
        Assertions.assertEquals((int)3, (int)outcome.size());
    }
}

