/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VersionLoaderTest
extends ActiveMQTestBase {
    @Test
    public void testLoadVersion() throws Exception {
        Version version = VersionLoader.getVersion();
        Properties props = new Properties();
        props.load(ClassLoader.getSystemResourceAsStream("activemq-version.properties"));
        Assertions.assertEquals((Object)props.get("activemq.version.versionName"), (Object)version.getVersionName());
        Assertions.assertEquals((int)Integer.parseInt(props.getProperty("activemq.version.majorVersion")), (int)version.getMajorVersion());
        Assertions.assertEquals((int)Integer.parseInt(props.getProperty("activemq.version.minorVersion")), (int)version.getMinorVersion());
        Assertions.assertEquals((int)Integer.parseInt(props.getProperty("activemq.version.microVersion")), (int)version.getMicroVersion());
        Assertions.assertEquals((int)Integer.parseInt(new StringTokenizer(props.getProperty("activemq.version.incrementingVersion"), ",").nextToken()), (int)version.getIncrementingVersion());
    }
}

