/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpFrameValidator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.transport.Attach;
import org.apache.qpid.proton.amqp.transport.Begin;
import org.apache.qpid.proton.amqp.transport.Close;
import org.apache.qpid.proton.amqp.transport.Detach;
import org.apache.qpid.proton.amqp.transport.Disposition;
import org.apache.qpid.proton.amqp.transport.End;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.amqp.transport.FrameBody;
import org.apache.qpid.proton.amqp.transport.Open;
import org.apache.qpid.proton.amqp.transport.Transfer;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.framing.TransportFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpProtocolTracer
implements ProtocolTracer,
FrameBody.FrameBodyHandler<AmqpFrameValidator> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AmqpConnection connection;

    public AmqpProtocolTracer(AmqpConnection connection) {
        this.connection = connection;
    }

    public void receivedFrame(TransportFrame transportFrame) {
        AmqpFrameValidator inspector;
        if (this.connection.isTraceFrames()) {
            logger.trace("{} | RECV: {}", (Object)this.connection.getRemoteURI(), (Object)transportFrame.getBody());
        }
        if ((inspector = this.connection.getReceivedFrameInspector()) != null) {
            transportFrame.getBody().invoke((FrameBody.FrameBodyHandler)this, transportFrame.getPayload(), (Object)inspector);
        }
    }

    public void sentFrame(TransportFrame transportFrame) {
        AmqpFrameValidator inspector;
        if (this.connection.isTraceFrames()) {
            logger.trace("{} | SENT: {}", (Object)this.connection.getRemoteURI(), (Object)transportFrame.getBody());
        }
        if ((inspector = this.connection.getSentFrameInspector()) != null) {
            transportFrame.getBody().invoke((FrameBody.FrameBodyHandler)this, transportFrame.getPayload(), (Object)inspector);
        }
    }

    public void handleOpen(Open open, Binary payload, AmqpFrameValidator context) {
        context.inspectOpen(open, payload);
    }

    public void handleBegin(Begin begin, Binary payload, AmqpFrameValidator context) {
        context.inspectBegin(begin, payload);
    }

    public void handleAttach(Attach attach, Binary payload, AmqpFrameValidator context) {
        context.inspectAttach(attach, payload);
    }

    public void handleFlow(Flow flow, Binary payload, AmqpFrameValidator context) {
        context.inspectFlow(flow, payload);
    }

    public void handleTransfer(Transfer transfer, Binary payload, AmqpFrameValidator context) {
        context.inspectTransfer(transfer, payload);
    }

    public void handleDisposition(Disposition disposition, Binary payload, AmqpFrameValidator context) {
        context.inspectDisposition(disposition, payload);
    }

    public void handleDetach(Detach detach, Binary payload, AmqpFrameValidator context) {
        context.inspectDetach(detach, payload);
    }

    public void handleEnd(End end, Binary payload, AmqpFrameValidator context) {
        context.inspectEnd(end, payload);
    }

    public void handleClose(Close close, Binary payload, AmqpFrameValidator context) {
        context.inspectClose(close, payload);
    }
}

