/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy.util;

import java.lang.invoke.MethodHandles;
import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.serialization.spi.ProxyServices;

public class WeldDefaultProxyServices
implements ProxyServices {
    private ConcurrentMap<ClassLoader, WeldProxyDeclaringCL> clMap = new ConcurrentHashMap<ClassLoader, WeldProxyDeclaringCL>();

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len) throws ClassFormatError {
        return this.defineClass(originalClass, className, classBytes, off, len, null);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        ClassLoader originalLoader = originalClass.getClassLoader();
        if (originalLoader == null && (originalLoader = Thread.currentThread().getContextClassLoader()) == null) {
            throw BeanLogger.LOG.cannotDetermineClassLoader(className, originalClass);
        }
        try {
            if (className.startsWith("org.jboss.weld.generated.proxies")) {
                return this.defineWithClassLoader(className, classBytes, classBytes.length, originalLoader, protectionDomain);
            }
            return this.defineWithMethodLookup(className, classBytes, originalClass, originalLoader);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> loadClass(Class<?> originalClass, String classBinaryName) throws ClassNotFoundException {
        ClassLoader loader = originalClass.getClassLoader();
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            throw BeanLogger.LOG.cannotDetermineClassLoader(classBinaryName, originalClass);
        }
        if (this.clMap.containsKey(loader)) {
            loader = (ClassLoader)this.clMap.get(loader);
        }
        return loader.loadClass(classBinaryName);
    }

    public void cleanup() {
        this.clMap.clear();
    }

    private Class<?> defineWithClassLoader(String classToDefineName, byte[] classBytes, int length, ClassLoader loader, ProtectionDomain domain) {
        WeldProxyDeclaringCL delegatingClassLoader = this.returnWeldCL(loader);
        if (domain == null) {
            return delegatingClassLoader.publicDefineClass(classToDefineName, classBytes, 0, length);
        }
        return delegatingClassLoader.publicDefineClass(classToDefineName, classBytes, 0, length, domain);
    }

    private WeldProxyDeclaringCL returnWeldCL(ClassLoader loader) {
        if (loader instanceof WeldProxyDeclaringCL) {
            return (WeldProxyDeclaringCL)loader;
        }
        return this.clMap.computeIfAbsent(loader, cl -> new WeldProxyDeclaringCL((ClassLoader)cl));
    }

    private Class<?> defineWithMethodLookup(String classToDefineName, byte[] classBytes, Class<?> originalClass, ClassLoader loader) {
        Module thisModule = WeldDefaultProxyServices.class.getModule();
        try {
            Class<?> lookupBaseClass;
            try {
                lookupBaseClass = loader.loadClass(classToDefineName.substring(0, classToDefineName.indexOf("$")));
            }
            catch (Exception e) {
                lookupBaseClass = originalClass;
            }
            Module lookupClassModule = lookupBaseClass.getModule();
            if (!thisModule.canRead(lookupClassModule)) {
                thisModule.addReads(lookupClassModule);
            }
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(lookupBaseClass, MethodHandles.lookup());
            return lookup.defineClass(classBytes);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private class WeldProxyDeclaringCL
    extends ClassLoader {
        WeldProxyDeclaringCL(ClassLoader parent) {
            super(parent);
        }

        public final Class<?> publicDefineClass(String name, byte[] b, int off, int len) {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return super.defineClass(name, b, off, len);
            }
        }

        public final Class<?> publicDefineClass(String name, byte[] b, int off, int len, ProtectionDomain pd) {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return super.defineClass(name, b, off, len, pd);
            }
        }
    }
}

