/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository.logging;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYDR", length=4)
public interface DeploymentRepositoryLogger
extends BasicLogger {
    public static final DeploymentRepositoryLogger ROOT_LOGGER = (DeploymentRepositoryLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), DeploymentRepositoryLogger.class, (String)"org.jboss.as.repository");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Content added at location %s")
    public void contentAdded(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Content removed from location %s")
    public void contentRemoved(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Cannot delete temp file %s, will be deleted on exit")
    public void cannotDeleteTempFile(@Cause Throwable var1, String var2);

    @Message(id=4, value="Cannot create directory %s")
    public IllegalStateException cannotCreateDirectory(@Cause Throwable var1, String var2);

    @Message(id=5, value="Cannot obtain SHA-1 %s")
    public IllegalStateException cannotObtainSha1(@Cause Throwable var1, String var2);

    @Message(id=6, value="Directory %s is not writable")
    public IllegalStateException directoryNotWritable(String var1);

    @Message(id=7, value="%s is not a directory")
    public IllegalStateException notADirectory(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="Content %s is obsolete and will be removed")
    public void obsoleteContentCleaned(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Couldn't delete content %s")
    public void contentDeletionError(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Couldn't list directory files for %s")
    public void localContentListError(String var1);

    @Message(id=12, value="Cannot hash current deployment content %s")
    public RuntimeException hashingError(@Cause Throwable var1, Path var2);

    @Message(id=13, value="Access denied to the content at %s in the deployment")
    public IllegalArgumentException forbiddenPath(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="Error deleting deployment %s")
    public void couldNotDeleteDeployment(@Cause Exception var1, String var2);

    @Message(id=15, value="%s is not an archive file")
    public IllegalStateException notAnArchive(String var1);

    @Message(id=16, value="Achive file %s not found")
    public ExplodedContentException archiveNotFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17, value="Content exploded at location %s")
    public void contentExploded(String var1);

    @Message(id=18, value="Error exploding content for %s")
    public ExplodedContentException errorExplodingContent(@Cause Exception var1, String var2);

    @Message(id=19, value="Deployment is locked by another operation")
    public ExplodedContentException errorLockingDeployment();

    @Message(id=20, value="Error accessing deployment files")
    public ExplodedContentException errorAccessingDeployment(@Cause Exception var1);

    @Message(id=21, value="Error updating content of exploded deployment")
    public ExplodedContentException errorUpdatingDeployment(@Cause Exception var1);

    @Message(id=22, value="Error copying files of exploded deployment to %s")
    public ExplodedContentException errorCopyingDeployment(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23, value="Error deleting file %s")
    public void cannotDeleteFile(@Cause Exception var1, Path var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=24, value="Error copying file %s")
    public void cannotCopyFile(@Cause Exception var1, Path var2);
}

