/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.util.Objects;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

public class PojoIndexedEmbeddedMappingElement
implements MappingElement {
    private final PojoRawTypeIdentifier<?> declaringType;
    private final String declaringPropertyName;
    private final String relativePrefix;

    public PojoIndexedEmbeddedMappingElement(PojoRawTypeIdentifier<?> declaringType, String declaringPropertyName, String relativePrefix) {
        this.declaringType = declaringType;
        this.declaringPropertyName = declaringPropertyName;
        this.relativePrefix = relativePrefix;
    }

    public String toString() {
        if (this.relativePrefix == null) {
            return "@IndexedEmbedded(...)";
        }
        if (this.relativePrefix.indexOf(".") < this.relativePrefix.length() - 1) {
            return "@IndexedEmbedded(prefix = \"" + this.relativePrefix + "\", ...)";
        }
        return "@IndexedEmbedded(name = \"" + this.relativePrefix.substring(0, this.relativePrefix.length() - 1) + "\", ...)";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoIndexedEmbeddedMappingElement that = (PojoIndexedEmbeddedMappingElement)o;
        return Objects.equals(this.declaringType, that.declaringType) && Objects.equals(this.declaringPropertyName, that.declaringPropertyName) && Objects.equals(this.relativePrefix, that.relativePrefix);
    }

    public int hashCode() {
        return Objects.hash(this.declaringType, this.declaringPropertyName, this.relativePrefix);
    }

    public EventContext eventContext() {
        return PojoEventContexts.fromType(this.declaringType).append(PojoEventContexts.fromPath(PojoModelPath.ofProperty(this.declaringPropertyName)));
    }
}

