/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.media;

import io.smallrye.openapi.internal.models.media.Schema;
import io.smallrye.openapi.model.BaseModel;
import io.smallrye.openapi.model.Extensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.media.Schema;

public final class SchemaSupport {
    static final List<Schema.SchemaType> NULL_SINGLETON = Collections.singletonList(Schema.SchemaType.NULL);

    public static org.eclipse.microprofile.openapi.models.media.Schema nullSchema() {
        return OASFactory.createSchema().type(NULL_SINGLETON);
    }

    private SchemaSupport() {
    }

    public static int getModCount(org.eclipse.microprofile.openapi.models.media.Schema schema) {
        if (schema instanceof BaseModel) {
            return ((BaseModel)schema).getModCount();
        }
        return 0;
    }

    public static Boolean getNullable(org.eclipse.microprofile.openapi.models.media.Schema schema) {
        List<Schema.SchemaType> types = SchemaSupport.getTypeList(schema);
        Boolean nullable = (Boolean)Extensions.getPrivateExtension((Extensible)schema, (String)"nullable", Boolean.class);
        if (types != null) {
            boolean nullPermitted = types.contains(Schema.SchemaType.NULL);
            if (!nullPermitted && nullable == null) {
                return null;
            }
            return nullPermitted;
        }
        return nullable;
    }

    public static void setNullable(org.eclipse.microprofile.openapi.models.media.Schema schema, Boolean nullable) {
        Extensions.setPrivateExtension((Extensible)schema, (String)"nullable", (Object)nullable);
        if (nullable == Boolean.TRUE) {
            List<Schema.SchemaType> types = SchemaSupport.getTypeList(schema);
            if (types != null && !types.contains(Schema.SchemaType.NULL)) {
                schema.addType(Schema.SchemaType.NULL);
            }
        } else {
            schema.removeType(Schema.SchemaType.NULL);
        }
    }

    public static void setType(org.eclipse.microprofile.openapi.models.media.Schema schema, Schema.SchemaType singletonType) {
        if (singletonType == null) {
            SchemaSupport.setTypeList(schema, null);
        } else if (SchemaSupport.getNullable(schema) == Boolean.TRUE) {
            SchemaSupport.setTypeList(schema, List.of(singletonType, Schema.SchemaType.NULL));
        } else {
            SchemaSupport.setTypeList(schema, Collections.singletonList(singletonType));
        }
        SchemaSupport.notifyTypeObservers(schema, o -> SchemaSupport.setType(o, singletonType));
    }

    public static Schema.SchemaType getNonNullType(org.eclipse.microprofile.openapi.models.media.Schema schema) {
        List<Schema.SchemaType> types = SchemaSupport.getTypeList(schema);
        if (types == null || types.isEmpty()) {
            return null;
        }
        for (Schema.SchemaType type : types) {
            if (type.equals((Object)Schema.SchemaType.NULL)) continue;
            return type;
        }
        return null;
    }

    public static void addTypeObserver(org.eclipse.microprofile.openapi.models.media.Schema observed, org.eclipse.microprofile.openapi.models.media.Schema observer) {
        ArrayList<org.eclipse.microprofile.openapi.models.media.Schema> typeObservers = Extensions.getTypeObservers((org.eclipse.microprofile.openapi.models.media.Schema)observed);
        if (typeObservers == null) {
            typeObservers = new ArrayList<org.eclipse.microprofile.openapi.models.media.Schema>(2);
            Extensions.setTypeObservers((org.eclipse.microprofile.openapi.models.media.Schema)observed, typeObservers);
        }
        typeObservers.add(observer);
        SchemaSupport.setTypesRetainingNull(observer, SchemaSupport.getTypeList(observed));
    }

    static void notifyTypeObservers(org.eclipse.microprofile.openapi.models.media.Schema observed, Consumer<org.eclipse.microprofile.openapi.models.media.Schema> observerAction) {
        List typeObservers = Extensions.getTypeObservers((org.eclipse.microprofile.openapi.models.media.Schema)observed);
        if (typeObservers != null) {
            typeObservers.forEach(observerAction);
        }
    }

    static void setTypesRetainingNull(org.eclipse.microprofile.openapi.models.media.Schema target, List<Schema.SchemaType> newTypes) {
        List<Schema.SchemaType> oldTypes = SchemaSupport.getTypeList(target);
        if (oldTypes != null && newTypes != null && oldTypes.contains(Schema.SchemaType.NULL) && !newTypes.contains(Schema.SchemaType.NULL)) {
            newTypes = new ArrayList<Schema.SchemaType>(newTypes);
            newTypes.add(Schema.SchemaType.NULL);
        }
        target.setType(newTypes);
    }

    private static List<Schema.SchemaType> getTypeList(org.eclipse.microprofile.openapi.models.media.Schema schema) {
        if (schema instanceof Schema) {
            return ((Schema)schema).getTypeList();
        }
        return schema.getType();
    }

    private static void setTypeList(org.eclipse.microprofile.openapi.models.media.Schema schema, List<Schema.SchemaType> types) {
        if (schema instanceof Schema) {
            ((Schema)schema).setTypeList(types);
        }
        schema.setType(types);
    }
}

