/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.GroupedMulti;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiGroupIntoLists;
import io.smallrye.mutiny.groups.MultiGroupIntoMultis;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiGroupByOp;
import java.util.function.Function;

public class MultiGroup<T> {
    private final Multi<T> upstream;

    public MultiGroup(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public MultiGroupIntoLists<T> intoLists() {
        return new MultiGroupIntoLists<T>(this.upstream);
    }

    @CheckReturnValue
    public MultiGroupIntoMultis<T> intoMultis() {
        return new MultiGroupIntoMultis<T>(this.upstream);
    }

    @CheckReturnValue
    public <K> Multi<GroupedMulti<K, T>> by(Function<? super T, ? extends K> keyMapper) {
        Function<? super T, ? extends K> mapper = Infrastructure.decorate(ParameterValidation.nonNull(keyMapper, "keyMapper"));
        return Infrastructure.onMultiCreation(new MultiGroupByOp<Object, K, Object>(this.upstream, mapper, x -> x));
    }

    @CheckReturnValue
    public <K, V> Multi<GroupedMulti<K, V>> by(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Function<? super T, ? extends K> k = Infrastructure.decorate(ParameterValidation.nonNull(keyMapper, "keyMapper"));
        Function<? super T, ? extends V> v = Infrastructure.decorate(ParameterValidation.nonNull(valueMapper, "valueMapper"));
        return Infrastructure.onMultiCreation(new MultiGroupByOp<T, K, V>(this.upstream, k, v));
    }
}

